/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FifoPolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "FIFO";
    private FifoComparator comparator = new FifoComparator();

    public String getName() {
        return NAME;
    }

    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        if (schedulables.isEmpty()) {
            return;
        }
        Schedulable earliest = null;
        for (Schedulable schedulable : schedulables) {
            if (earliest != null && schedulable.getStartTime() >= earliest.getStartTime()) continue;
            earliest = schedulable;
        }
        earliest.setFairShare(Resources.clone((Resource)totalResources));
    }

    public byte getApplicableDepth() {
        return 1;
    }
}

