/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FairSharePolicy;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSharePolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "fair";
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private FairShareComparator comparator = new FairShareComparator(null);

    public String getName() {
        return NAME;
    }

    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        ComputeFairShares.computeShares(schedulables, (Resource)totalResources, (ResourceType)ResourceType.MEMORY);
    }

    public byte getApplicableDepth() {
        return 7;
    }

    static /* synthetic */ DefaultResourceCalculator access$100() {
        return RESOURCE_CALCULATOR;
    }
}

