/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.TestAllocationFileLoaderService;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocationFileLoaderService {
    static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();

    @Test
    public void testGetAllocationFileFromClasspath() {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", "test-fair-scheduler.xml");
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        File allocationFile = allocLoader.getAllocationFile(conf);
        Assert.assertEquals((Object)"test-fair-scheduler.xml", (Object)allocationFile.getName());
        junit.framework.Assert.assertTrue((boolean)allocationFile.exists());
    }

    @Test(timeout=10000L)
    public void testReload() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\">");
        out.println("    <maxRunningApps>1</maxRunningApps>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\" />");
        out.println("  <queuePlacementPolicy>");
        out.println("    <rule name='default' />");
        out.println("  </queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        MockClock clock = new MockClock(this, null);
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService((Clock)clock);
        allocLoader.reloadIntervalMs = 5L;
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener(this, null);
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        QueuePlacementPolicy policy = allocConf.getPlacementPolicy();
        List rules = policy.getRules();
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals((long)1L, (long)allocConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)2L, (long)allocConf.getQueueNames().size());
        junit.framework.Assert.assertTrue((boolean)allocConf.getQueueNames().contains("root.queueA"));
        junit.framework.Assert.assertTrue((boolean)allocConf.getQueueNames().contains("root.queueB"));
        confHolder.allocConf = null;
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueB\">");
        out.println("    <maxRunningApps>3</maxRunningApps>");
        out.println("  </queue>");
        out.println("  <queuePlacementPolicy>");
        out.println("    <rule name='specified' />");
        out.println("    <rule name='default' />");
        out.println("  </queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        clock.tick(System.currentTimeMillis() + 5000L + 10000L);
        allocLoader.start();
        while (confHolder.allocConf == null) {
            Thread.sleep(20L);
        }
        allocConf = confHolder.allocConf;
        policy = allocConf.getPlacementPolicy();
        rules = policy.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Specified.class, ((QueuePlacementRule)rules.get(0)).getClass());
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(1)).getClass());
        Assert.assertEquals((long)3L, (long)allocConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)1L, (long)allocConf.getQueueNames().size());
        junit.framework.Assert.assertTrue((boolean)allocConf.getQueueNames().contains("root.queueB"));
    }

    @Test
    public void testAllocationFileParsing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("<schedulingPolicy>fair</schedulingPolicy>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("</queue>");
        out.println("<queue name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>300</fairSharePreemptionTimeout>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener(this, null);
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)5L, (long)queueConf.getQueueNames().size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((Object)"*", (Object)queueConf.getQueueAcl("root", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)"*", (Object)queueConf.getQueueAcl("root", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueB", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueC", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.queueA").getName());
        Assert.assertEquals((Object)"fair", (Object)queueConf.getSchedulingPolicy("root.queueB").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.newqueue").getName());
    }

    @Test
    public void testBackwardsCompatibleAllocationFileParsing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<pool name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</pool>");
        out.println("<pool name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<aclAdministerApps>alice,bob admins</aclAdministerApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueC\">");
        out.println("<aclSubmitApps>alice,bob admins</aclSubmitApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueD\">");
        out.println("<maxRunningApps>3</maxRunningApps>");
        out.println("</pool>");
        out.println("<pool name=\"queueE\">");
        out.println("<minSharePreemptionTimeout>60</minSharePreemptionTimeout>");
        out.println("</pool>");
        out.println("<queueMaxAppsDefault>15</queueMaxAppsDefault>");
        out.println("<userMaxAppsDefault>5</userMaxAppsDefault>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>10</maxRunningApps>");
        out.println("</user>");
        out.println("<defaultMinSharePreemptionTimeout>120</defaultMinSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>300</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener(this, null);
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)5L, (long)queueConf.getQueueNames().size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)" ", (Object)queueConf.getQueueAcl("root.queueA", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueB", QueueACL.ADMINISTER_QUEUE).getAclString());
        Assert.assertEquals((Object)"alice,bob admins", (Object)queueConf.getQueueAcl("root.queueC", QueueACL.SUBMIT_APPLICATIONS).getAclString());
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout());
    }

    @Test
    public void testSimplePlacementPolicyFromConf() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        conf.setBoolean("yarn.scheduler.fair.user-as-default-queue", false);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener(this, null);
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        QueuePlacementPolicy placementPolicy = allocConf.getPlacementPolicy();
        List rules = placementPolicy.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals(QueuePlacementRule.Specified.class, ((QueuePlacementRule)rules.get(0)).getClass());
        junit.framework.Assert.assertEquals((boolean)false, (boolean)((QueuePlacementRule)rules.get((int)0)).create);
        Assert.assertEquals(QueuePlacementRule.Default.class, ((QueuePlacementRule)rules.get(1)).getClass());
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueAlongsideRoot() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("</queue>");
        out.println("<queue name=\"other\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService();
        allocLoader.init(conf);
        ReloadListener confHolder = new ReloadListener(this, null);
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }
}

