/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FakeSchedulable
extends Schedulable {
    private Resource usage;
    private Resource minShare;
    private Resource maxShare;
    private ResourceWeights weights;
    private Priority priority;
    private long startTime;

    public FakeSchedulable() {
        this(0, Integer.MAX_VALUE, 1.0, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare) {
        this(minShare, Integer.MAX_VALUE, 1.0, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, int maxShare) {
        this(minShare, maxShare, 1.0, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, double memoryWeight) {
        this(minShare, Integer.MAX_VALUE, memoryWeight, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, int maxShare, double memoryWeight) {
        this(minShare, maxShare, memoryWeight, 0, 0, 0L);
    }

    public FakeSchedulable(int minShare, int maxShare, double weight, int fairShare, int usage, long startTime) {
        this(Resources.createResource((int)minShare, (int)0), Resources.createResource((int)maxShare, (int)0), new ResourceWeights((float)weight), Resources.createResource((int)fairShare, (int)0), Resources.createResource((int)usage, (int)0), startTime);
    }

    public FakeSchedulable(Resource minShare, ResourceWeights weights) {
        this(minShare, Resources.createResource((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE), weights, Resources.createResource((int)0, (int)0), Resources.createResource((int)0, (int)0), 0L);
    }

    public FakeSchedulable(Resource minShare, Resource maxShare, ResourceWeights weight, Resource fairShare, Resource usage, long startTime) {
        this.minShare = minShare;
        this.maxShare = maxShare;
        this.weights = weight;
        this.setFairShare(fairShare);
        this.usage = usage;
        this.priority = (Priority)Records.newRecord(Priority.class);
        this.startTime = startTime;
    }

    public Resource assignContainer(FSSchedulerNode node) {
        return null;
    }

    public Resource getDemand() {
        return null;
    }

    public String getName() {
        return "FakeSchedulable" + this.hashCode();
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Resource getResourceUsage() {
        return this.usage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public ResourceWeights getWeights() {
        return this.weights;
    }

    public Resource getMinShare() {
        return this.minShare;
    }

    public Resource getMaxShare() {
        return this.maxShare;
    }

    public void updateDemand() {
    }
}

