/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSchedulerApplicationAttempt {
    private static final NodeId nodeId = NodeId.newInstance((String)"somehost", (int)5);
    private Configuration conf = new Configuration();

    @After
    public void tearDown() {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    @Test
    public void testMove() {
        String user = "user1";
        Queue parentQueue = this.createQueue("parent", null);
        Queue oldQueue = this.createQueue("old", parentQueue);
        Queue newQueue = this.createQueue("new", parentQueue);
        QueueMetrics parentMetrics = parentQueue.getMetrics();
        QueueMetrics oldMetrics = oldQueue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        ApplicationAttemptId appAttId = this.createAppAttemptId(0, 0);
        SchedulerApplicationAttempt app = new SchedulerApplicationAttempt(appAttId, "user1", oldQueue, oldQueue.getActiveUsersManager(), null);
        oldMetrics.submitApp("user1");
        Resource requestedResource = Resource.newInstance((int)1536, (int)2);
        Priority requestedPriority = Priority.newInstance((int)2);
        ResourceRequest request = ResourceRequest.newInstance((Priority)requestedPriority, (String)"*", (Resource)requestedResource, (int)3);
        app.updateResourceRequests(Arrays.asList(request));
        RMContainer container1 = this.createRMContainer(appAttId, 1, requestedResource);
        app.liveContainers.put(container1.getContainerId(), container1);
        SchedulerNode node = this.createNode();
        app.appSchedulingInfo.allocate(NodeType.OFF_SWITCH, node, requestedPriority, request, container1.getContainer());
        Priority prio1 = Priority.newInstance((int)1);
        Resource reservedResource = Resource.newInstance((int)2048, (int)3);
        RMContainer container2 = this.createReservedRMContainer(appAttId, 1, reservedResource, node.getNodeID(), prio1);
        HashMap<NodeId, RMContainer> reservations = new HashMap<NodeId, RMContainer>();
        reservations.put(node.getNodeID(), container2);
        app.reservedContainers.put(prio1, reservations);
        oldMetrics.reserveResource("user1", reservedResource);
        this.checkQueueMetrics(oldMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
        this.checkQueueMetrics(newMetrics, 0, 0, 0, 0, 0, 0, 0, 0);
        this.checkQueueMetrics(parentMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
        app.move(newQueue);
        this.checkQueueMetrics(oldMetrics, 0, 0, 0, 0, 0, 0, 0, 0);
        this.checkQueueMetrics(newMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
        this.checkQueueMetrics(parentMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
    }

    private void checkQueueMetrics(QueueMetrics metrics, int activeApps, int runningApps, int allocMb, int allocVcores, int reservedMb, int reservedVcores, int pendingMb, int pendingVcores) {
        Assert.assertEquals((long)activeApps, (long)metrics.getActiveApps());
        Assert.assertEquals((long)runningApps, (long)metrics.getAppsRunning());
        Assert.assertEquals((long)allocMb, (long)metrics.getAllocatedMB());
        Assert.assertEquals((long)allocVcores, (long)metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)reservedMb, (long)metrics.getReservedMB());
        Assert.assertEquals((long)reservedVcores, (long)metrics.getReservedVirtualCores());
        Assert.assertEquals((long)pendingMb, (long)metrics.getPendingMB());
        Assert.assertEquals((long)pendingVcores, (long)metrics.getPendingVirtualCores());
    }

    private SchedulerNode createNode() {
        SchedulerNode node = (SchedulerNode)Mockito.mock(SchedulerNode.class);
        Mockito.when((Object)node.getNodeName()).thenReturn((Object)"somehost");
        Mockito.when((Object)node.getRackName()).thenReturn((Object)"somerack");
        Mockito.when((Object)node.getNodeID()).thenReturn((Object)nodeId);
        return node;
    }

    private RMContainer createReservedRMContainer(ApplicationAttemptId appAttId, int id, Resource resource, NodeId nodeId, Priority reservedPriority) {
        RMContainer container = this.createRMContainer(appAttId, id, resource);
        Mockito.when((Object)container.getReservedResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getReservedPriority()).thenReturn((Object)reservedPriority);
        Mockito.when((Object)container.getReservedNode()).thenReturn((Object)nodeId);
        return container;
    }

    private RMContainer createRMContainer(ApplicationAttemptId appAttId, int id, Resource resource) {
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttId, (int)id);
        RMContainer rmContainer = (RMContainer)Mockito.mock(RMContainer.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        Mockito.when((Object)rmContainer.getContainer()).thenReturn((Object)container);
        Mockito.when((Object)rmContainer.getContainerId()).thenReturn((Object)containerId);
        return rmContainer;
    }

    private Queue createQueue(String name, Queue parent) {
        QueueMetrics metrics = QueueMetrics.forQueue((String)name, (Queue)parent, (boolean)false, (Configuration)this.conf);
        ActiveUsersManager activeUsersManager = new ActiveUsersManager(metrics);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)queue.getMetrics()).thenReturn((Object)metrics);
        Mockito.when((Object)queue.getActiveUsersManager()).thenReturn((Object)activeUsersManager);
        return queue;
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }
}

