/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.mockito.Mockito;

public class RMStateStoreTestBase
extends ClientBaseWithFixes {
    public static final Log LOG = LogFactory.getLog(RMStateStoreTestBase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitNotify(TestDispatcher dispatcher) {
        long startTime = System.currentTimeMillis();
        while (!dispatcher.notified) {
            TestDispatcher testDispatcher = dispatcher;
            synchronized (testDispatcher) {
                try {
                    dispatcher.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            Assert.fail((String)"Timed out attempt store notification");
        }
        dispatcher.notified = false;
    }

    RMApp storeApp(RMStateStore store, ApplicationId appId, long submitTime, long startTime) throws Exception {
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appId);
        RMApp mockApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)mockApp.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)mockApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockApp.getStartTime()).thenReturn((Object)startTime);
        Mockito.when((Object)mockApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockApp.getUser()).thenReturn((Object)"test");
        store.storeNewApplication(mockApp);
        return mockApp;
    }

    ContainerId storeAttempt(RMStateStore store, ApplicationAttemptId attemptId, String containerIdStr, Token<AMRMTokenIdentifier> appToken, SecretKey clientTokenMasterKey, TestDispatcher dispatcher) throws Exception {
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(ConverterUtils.toContainerId((String)containerIdStr));
        RMAppAttempt mockAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockAttempt.getAppAttemptId()).thenReturn((Object)attemptId);
        Mockito.when((Object)mockAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)mockAttempt.getAMRMToken()).thenReturn(appToken);
        Mockito.when((Object)mockAttempt.getClientTokenMasterKey()).thenReturn((Object)clientTokenMasterKey);
        dispatcher.attemptId = attemptId;
        dispatcher.storedException = null;
        store.storeNewApplicationAttempt(mockAttempt);
        this.waitNotify(dispatcher);
        return container.getId();
    }

    void testRMAppStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        long submitTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis() + 1234L;
        YarnConfiguration conf = new YarnConfiguration();
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        AMRMTokenSecretManager appTokenMgr = new AMRMTokenSecretManager((Configuration)conf);
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationAttemptId attemptId1 = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0001_000001");
        ApplicationId appId1 = attemptId1.getApplicationId();
        this.storeApp(store, appId1, submitTime, startTime);
        Token appAttemptToken1 = this.generateAMRMToken(attemptId1, appTokenMgr);
        HashSet<Token> attemptTokenSet1 = new HashSet<Token>();
        attemptTokenSet1.add(appAttemptToken1);
        SecretKey clientTokenKey1 = clientToAMTokenMgr.createMasterKey(attemptId1);
        ContainerId containerId1 = this.storeAttempt(store, attemptId1, "container_1352994193343_0001_01_000001", appAttemptToken1, clientTokenKey1, dispatcher);
        String appAttemptIdStr2 = "appattempt_1352994193343_0001_000002";
        ApplicationAttemptId attemptId2 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr2);
        Token appAttemptToken2 = this.generateAMRMToken(attemptId2, appTokenMgr);
        HashSet<Token> attemptTokenSet2 = new HashSet<Token>();
        attemptTokenSet2.add(appAttemptToken2);
        SecretKey clientTokenKey2 = clientToAMTokenMgr.createMasterKey(attemptId2);
        ContainerId containerId2 = this.storeAttempt(store, attemptId2, "container_1352994193343_0001_02_000001", appAttemptToken2, clientTokenKey2, dispatcher);
        ApplicationAttemptId attemptIdRemoved = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0002_000001");
        ApplicationId appIdRemoved = attemptIdRemoved.getApplicationId();
        this.storeApp(store, appIdRemoved, submitTime, startTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        RMApp mockRemovedApp = (RMApp)Mockito.mock(RMApp.class);
        HashMap<ApplicationAttemptId, RMAppAttempt> attempts = new HashMap<ApplicationAttemptId, RMAppAttempt>();
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appIdRemoved);
        Mockito.when((Object)mockRemovedApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockRemovedApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockRemovedApp.getAppAttempts()).thenReturn(attempts);
        RMAppAttempt mockRemovedAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockRemovedAttempt.getAppAttemptId()).thenReturn((Object)attemptIdRemoved);
        attempts.put(attemptIdRemoved, mockRemovedAttempt);
        store.removeApplication(mockRemovedApp);
        this.storeApp(store, appIdRemoved, submitTime, startTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        store.removeApplication(mockRemovedApp);
        Thread.sleep(1000L);
        store.close();
        this.modifyAppState();
        store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        Map rmAppState = state.getApplicationState();
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(appId1);
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)submitTime, (long)appState.getSubmitTime());
        Assert.assertEquals((long)startTime, (long)appState.getStartTime());
        Assert.assertEquals((Object)appId1, (Object)appState.getApplicationSubmissionContext().getApplicationId());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)attemptId1, (Object)attemptState.getAttemptId());
        Assert.assertEquals((Object)containerId1, (Object)attemptState.getMasterContainer().getId());
        HashSet savedTokens = new HashSet();
        savedTokens.addAll(attemptState.getAppAttemptCredentials().getAllTokens());
        Assert.assertEquals(attemptTokenSet1, savedTokens);
        Assert.assertArrayEquals((byte[])clientTokenKey1.getEncoded(), (byte[])attemptState.getAppAttemptCredentials().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        attemptState = appState.getAttempt(attemptId2);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)attemptId2, (Object)attemptState.getAttemptId());
        Assert.assertEquals((Object)containerId2, (Object)attemptState.getMasterContainer().getId());
        savedTokens.clear();
        savedTokens.addAll(attemptState.getAppAttemptCredentials().getAllTokens());
        Assert.assertEquals(attemptTokenSet2, savedTokens);
        Assert.assertArrayEquals((byte[])clientTokenKey2.getEncoded(), (byte[])attemptState.getAppAttemptCredentials().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        RMStateStore.ApplicationState appState2 = new RMStateStore.ApplicationState(appState.submitTime, appState.startTime, appState.context, appState.user, RMAppState.FINISHED, "appDiagnostics", 1234L);
        appState2.attempts.putAll(appState.attempts);
        store.updateApplicationState(appState2);
        RMStateStore.ApplicationAttemptState oldAttemptState = attemptState;
        RMStateStore.ApplicationAttemptState newAttemptState = new RMStateStore.ApplicationAttemptState(oldAttemptState.getAttemptId(), oldAttemptState.getMasterContainer(), oldAttemptState.getAppAttemptCredentials(), oldAttemptState.getStartTime(), RMAppAttemptState.FINISHED, "myTrackingUrl", "attemptDiagnostics", FinalApplicationStatus.SUCCEEDED);
        store.updateApplicationAttemptState(newAttemptState);
        ApplicationId dummyAppId = ApplicationId.newInstance((long)1234L, (int)10);
        ApplicationSubmissionContextPBImpl dummyContext = new ApplicationSubmissionContextPBImpl();
        dummyContext.setApplicationId(dummyAppId);
        RMStateStore.ApplicationState dummyApp = new RMStateStore.ApplicationState(appState.submitTime, appState.startTime, (ApplicationSubmissionContext)dummyContext, appState.user, RMAppState.FINISHED, "appDiagnostics", 1234L);
        store.updateApplicationState(dummyApp);
        ApplicationAttemptId dummyAttemptId = ApplicationAttemptId.newInstance((ApplicationId)dummyAppId, (int)6);
        RMStateStore.ApplicationAttemptState dummyAttempt = new RMStateStore.ApplicationAttemptState(dummyAttemptId, oldAttemptState.getMasterContainer(), oldAttemptState.getAppAttemptCredentials(), oldAttemptState.getStartTime(), RMAppAttemptState.FINISHED, "myTrackingUrl", "attemptDiagnostics", FinalApplicationStatus.SUCCEEDED);
        store.updateApplicationAttemptState(dummyAttempt);
        Thread.sleep(1000L);
        store.close();
        store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState newRMState = store.loadState();
        Map newRMAppState = newRMState.getApplicationState();
        Assert.assertNotNull(newRMAppState.get(dummyApp.getAppId()));
        RMStateStore.ApplicationState updatedAppState = (RMStateStore.ApplicationState)newRMAppState.get(appId1);
        Assert.assertEquals((Object)appState.getAppId(), (Object)updatedAppState.getAppId());
        Assert.assertEquals((long)appState.getSubmitTime(), (long)updatedAppState.getSubmitTime());
        Assert.assertEquals((long)appState.getStartTime(), (long)updatedAppState.getStartTime());
        Assert.assertEquals((Object)appState.getUser(), (Object)updatedAppState.getUser());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)updatedAppState.getState());
        Assert.assertEquals((Object)"appDiagnostics", (Object)updatedAppState.getDiagnostics());
        Assert.assertEquals((long)1234L, (long)updatedAppState.getFinishTime());
        Assert.assertNotNull((Object)((RMStateStore.ApplicationState)newRMAppState.get(dummyApp.getAppId())).getAttempt(dummyAttemptId));
        RMStateStore.ApplicationAttemptState updatedAttemptState = updatedAppState.getAttempt(newAttemptState.getAttemptId());
        Assert.assertEquals((Object)oldAttemptState.getAttemptId(), (Object)updatedAttemptState.getAttemptId());
        Assert.assertEquals((Object)containerId2, (Object)updatedAttemptState.getMasterContainer().getId());
        Assert.assertArrayEquals((byte[])clientTokenKey2.getEncoded(), (byte[])updatedAttemptState.getAppAttemptCredentials().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        Assert.assertEquals((Object)RMAppAttemptState.FINISHED, (Object)updatedAttemptState.getState());
        Assert.assertEquals((Object)"myTrackingUrl", (Object)updatedAttemptState.getFinalTrackingUrl());
        Assert.assertEquals((Object)"attemptDiagnostics", (Object)updatedAttemptState.getDiagnostics());
        Assert.assertEquals((Object)FinalApplicationStatus.SUCCEEDED, (Object)updatedAttemptState.getFinalApplicationStatus());
        Assert.assertTrue((boolean)stateStoreHelper.isFinalStateValid());
        store.close();
    }

    public void testRMDTSecretManagerStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        Long renewDate1 = new Long(System.currentTimeMillis());
        int sequenceNumber = 1111;
        store.storeRMDelegationTokenAndSequenceNumber(dtId1, renewDate1, sequenceNumber);
        this.modifyRMDelegationTokenState();
        HashMap<RMDelegationTokenIdentifier, Long> token1 = new HashMap<RMDelegationTokenIdentifier, Long>();
        token1.put(dtId1, renewDate1);
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        store.storeRMDTMasterKey(key);
        RMStateStore.RMDTSecretManagerState secretManagerState = store.loadState().getRMDTSecretManagerState();
        junit.framework.Assert.assertEquals(token1, (Object)secretManagerState.getTokenState());
        junit.framework.Assert.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
        junit.framework.Assert.assertEquals((int)sequenceNumber, (int)secretManagerState.getDTSequenceNumber());
        renewDate1 = new Long(System.currentTimeMillis());
        store.updateRMDelegationTokenAndSequenceNumber(dtId1, renewDate1, ++sequenceNumber);
        token1.put(dtId1, renewDate1);
        RMStateStore.RMDTSecretManagerState updateSecretManagerState = store.loadState().getRMDTSecretManagerState();
        junit.framework.Assert.assertEquals(token1, (Object)updateSecretManagerState.getTokenState());
        junit.framework.Assert.assertEquals(keySet, (Object)updateSecretManagerState.getMasterKeyState());
        junit.framework.Assert.assertEquals((int)sequenceNumber, (int)updateSecretManagerState.getDTSequenceNumber());
        store.removeRMDTMasterKey(key);
        keySet.clear();
        RMStateStore.RMDTSecretManagerState noKeySecretManagerState = store.loadState().getRMDTSecretManagerState();
        junit.framework.Assert.assertEquals(token1, (Object)noKeySecretManagerState.getTokenState());
        junit.framework.Assert.assertEquals(keySet, (Object)noKeySecretManagerState.getMasterKeyState());
        junit.framework.Assert.assertEquals((int)sequenceNumber, (int)noKeySecretManagerState.getDTSequenceNumber());
        store.removeRMDelegationToken(dtId1, sequenceNumber);
        RMStateStore.RMDTSecretManagerState noKeyAndTokenSecretManagerState = store.loadState().getRMDTSecretManagerState();
        token1.clear();
        junit.framework.Assert.assertEquals(token1, (Object)noKeyAndTokenSecretManagerState.getTokenState());
        junit.framework.Assert.assertEquals(keySet, (Object)noKeyAndTokenSecretManagerState.getMasterKeyState());
        junit.framework.Assert.assertEquals((int)sequenceNumber, (int)noKeySecretManagerState.getDTSequenceNumber());
        store.close();
    }

    private Token<AMRMTokenIdentifier> generateAMRMToken(ApplicationAttemptId attemptId, AMRMTokenSecretManager appTokenMgr) {
        AMRMTokenIdentifier appTokenId = new AMRMTokenIdentifier(attemptId);
        Token appToken = new Token((TokenIdentifier)appTokenId, (SecretManager)appTokenMgr);
        appToken.setService(new Text("appToken service"));
        return appToken;
    }

    public void testCheckVersion(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)new TestDispatcher());
        RMStateVersion defaultVersion = stateStoreHelper.getCurrentVersion();
        store.checkVersion();
        junit.framework.Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        RMStateVersion compatibleVersion = RMStateVersion.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        stateStoreHelper.writeVersion(compatibleVersion);
        junit.framework.Assert.assertEquals((Object)compatibleVersion, (Object)store.loadVersion());
        store.checkVersion();
        junit.framework.Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        RMStateVersion incompatibleVersion = RMStateVersion.newInstance((int)(defaultVersion.getMajorVersion() + 2), (int)defaultVersion.getMinorVersion());
        stateStoreHelper.writeVersion(incompatibleVersion);
        try {
            store.checkVersion();
            junit.framework.Assert.fail((String)"Invalid version, should fail.");
        }
        catch (Throwable t) {
            junit.framework.Assert.assertTrue((boolean)(t instanceof RMStateVersionIncompatibleException));
        }
    }

    public void testAppDeletion(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)new TestDispatcher());
        ArrayList<RMApp> appList = new ArrayList<RMApp>();
        int NUM_APPS = 5;
        for (int i = 0; i < NUM_APPS; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1383183338L, (int)i);
            RMApp app = this.storeApp(store, appId, 123456789L, 987654321L);
            appList.add(app);
        }
        junit.framework.Assert.assertEquals((int)NUM_APPS, (int)appList.size());
        for (RMApp app : appList) {
            while (!stateStoreHelper.appExists(app)) {
                Thread.sleep(100L);
            }
        }
        for (RMApp app : appList) {
            store.removeApplication(app);
            while (stateStoreHelper.appExists(app)) {
                Thread.sleep(100L);
            }
        }
    }

    protected void modifyAppState() throws Exception {
    }

    protected void modifyRMDelegationTokenState() throws Exception {
    }
}

