/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.TestApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationMasterLauncher {
    private static final Log LOG = LogFactory.getLog(TestApplicationMasterLauncher.class);

    @Test
    public void testAMLaunchAndCleanup() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MyContainerManagerImpl containerManager = new MyContainerManagerImpl(null);
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher((ContainerManagementProtocol)containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (!containerManager.launched && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.launched);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId appAttemptId = attempt.getAppAttemptId();
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)containerManager.attemptIdAtContainerManager);
        Assert.assertEquals((long)app.getSubmitTime(), (long)containerManager.submitTimeAtContainerManager);
        Assert.assertEquals((Object)app.getRMAppAttempt(appAttemptId).getMasterContainer().getId().toString(), (Object)containerManager.containerIdAtContainerManager);
        Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)containerManager.nmHostAtContainerManager);
        Assert.assertEquals((long)2L, (long)containerManager.maxAppAttempts);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), appAttemptId);
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        waitCount = 0;
        while (!containerManager.cleanedup && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Cleanup to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.cleanedup);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.stop();
    }

    @Test(timeout=100000L)
    public void testallocateBeforeAMRegistration() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        boolean thrown = false;
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        int request = 2;
        try {
            AllocateResponse ar = am.allocate("h1", 1000, request, new ArrayList());
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is trying to allocate before registering for: " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
            thrown = true;
        }
        nm1.nodeHeartbeat(true);
        try {
            AllocateResponse amrs = am.allocate(new ArrayList(), new ArrayList());
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is trying to allocate before registering for: " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        am.registerAppAttempt();
        thrown = false;
        try {
            am.registerAppAttempt(false);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is already registered : " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }
}

