/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FifoAppComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.WeightAdjuster;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class FairScheduler
implements ResourceScheduler {
    private boolean initialized;
    private FairSchedulerConfiguration conf;
    private RMContext rmContext;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    private Resource incrAllocation;
    private QueueManager queueMgr;
    private Clock clock;
    private boolean usePortForNodeName;
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    public static final Resource CONTAINER_RESERVED = Resources.createResource((int)-1);
    protected long UPDATE_INTERVAL = 500L;
    private volatile boolean userAsDefaultQueue = false;
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    private static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0));
    FSQueueMetrics rootMetrics;
    protected long lastPreemptionUpdateTime;
    private long lastPreemptCheckTime;
    @VisibleForTesting
    protected Map<ApplicationAttemptId, FSSchedulerApp> applications = new ConcurrentHashMap<ApplicationAttemptId, FSSchedulerApp>();
    private Map<NodeId, FSSchedulerNode> nodes = new ConcurrentHashMap<NodeId, FSSchedulerNode>();
    private Resource clusterCapacity = (Resource)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Resource.class);
    protected long preemptionInterval;
    protected long waitTimeBeforeKill;
    private List<RMContainer> warnedContainers = new ArrayList<RMContainer>();
    protected boolean preemptionEnabled;
    protected boolean sizeBasedWeight;
    protected WeightAdjuster weightAdjuster;
    protected double nodeLocalityThreshold;
    protected double rackLocalityThreshold;
    private FairSchedulerEventLog eventLog;
    protected boolean assignMultiple;
    protected int maxAssign;

    public FairScheduler() {
        this.clock = new SystemClock();
        this.queueMgr = new QueueManager(this);
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem < 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min should equal greater than 0" + ", max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores < 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min should equal greater than 0" + ", max should be no smaller than min.");
        }
    }

    public FairSchedulerConfiguration getConf() {
        return this.conf;
    }

    public QueueManager getQueueManager() {
        return this.queueMgr;
    }

    private RMContainer getRMContainer(ContainerId containerId) {
        FSSchedulerApp application = this.applications.get(containerId.getApplicationAttemptId());
        return application == null ? null : application.getRMContainer(containerId);
    }

    protected synchronized void update() {
        this.queueMgr.reloadAllocsIfNecessary();
        this.updateRunnability();
        this.updatePreemptionVariables();
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        ((Schedulable)rootQueue).updateDemand();
        rootQueue.setFairShare(this.clusterCapacity);
        ((FSQueue)rootQueue).recomputeShares();
    }

    private void updatePreemptionVariables() {
        long now;
        this.lastPreemptionUpdateTime = now = this.clock.getTime();
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            if (!this.isStarvedForMinShare(sched)) {
                sched.setLastTimeAtMinShare(now);
            }
            if (this.isStarvedForFairShare(sched)) continue;
            sched.setLastTimeAtHalfFairShare(now);
        }
    }

    boolean isStarvedForMinShare(FSLeafQueue sched) {
        Resource desiredShare = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getMinShare(), (Resource)sched.getDemand());
        return Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getResourceUsage(), (Resource)desiredShare);
    }

    boolean isStarvedForFairShare(FSLeafQueue sched) {
        Resource desiredFairShare = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)Resources.multiply((Resource)sched.getFairShare(), (double)0.5), (Resource)sched.getDemand());
        return Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getResourceUsage(), (Resource)desiredFairShare);
    }

    protected synchronized void preemptTasksIfNecessary() {
        if (!this.preemptionEnabled) {
            return;
        }
        long curTime = this.clock.getTime();
        if (curTime - this.lastPreemptCheckTime < this.preemptionInterval) {
            return;
        }
        this.lastPreemptCheckTime = curTime;
        Resource resToPreempt = Resources.none();
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            resToPreempt = Resources.add((Resource)resToPreempt, (Resource)this.resToPreempt(sched, curTime));
        }
        if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)resToPreempt, (Resource)Resources.none())) {
            this.preemptResources(this.queueMgr.getLeafQueues(), resToPreempt);
        }
    }

    protected void preemptResources(Collection<FSLeafQueue> scheds, Resource toPreempt) {
        if (scheds.isEmpty() || Resources.equals((Resource)toPreempt, (Resource)Resources.none())) {
            return;
        }
        HashMap<RMContainer, FSSchedulerApp> apps = new HashMap<RMContainer, FSSchedulerApp>();
        HashMap<RMContainer, FSLeafQueue> queues = new HashMap<RMContainer, FSLeafQueue>();
        ArrayList<RMContainer> runningContainers = new ArrayList<RMContainer>();
        for (FSLeafQueue sched : scheds) {
            if (!Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getResourceUsage(), (Resource)sched.getFairShare())) continue;
            for (AppSchedulable as : sched.getAppSchedulables()) {
                for (RMContainer c : as.getApp().getLiveContainers()) {
                    runningContainers.add(c);
                    apps.put(c, as.getApp());
                    queues.put(c, sched);
                }
            }
        }
        Collections.sort(runningContainers, new Comparator<RMContainer>(){

            @Override
            public int compare(RMContainer c1, RMContainer c2) {
                int ret = c1.getContainer().getPriority().compareTo(c2.getContainer().getPriority());
                if (ret == 0) {
                    return c2.getContainerId().compareTo(c1.getContainerId());
                }
                return ret;
            }
        });
        Iterator<RMContainer> warnedIter = this.warnedContainers.iterator();
        HashSet<RMContainer> preemptedThisRound = new HashSet<RMContainer>();
        while (warnedIter.hasNext()) {
            RMContainer container = warnedIter.next();
            if (container.getState() == RMContainerState.RUNNING && Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)toPreempt, (Resource)Resources.none())) {
                this.warnOrKillContainer(container, (FSSchedulerApp)apps.get(container), (FSLeafQueue)queues.get(container));
                preemptedThisRound.add(container);
                Resources.subtractFrom((Resource)toPreempt, (Resource)container.getContainer().getResource());
                continue;
            }
            warnedIter.remove();
        }
        Iterator runningIter = runningContainers.iterator();
        while (runningIter.hasNext() && Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)toPreempt, (Resource)Resources.none())) {
            RMContainer container = (RMContainer)runningIter.next();
            FSLeafQueue sched = (FSLeafQueue)queues.get(container);
            if (preemptedThisRound.contains(container) || !Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getResourceUsage(), (Resource)sched.getFairShare())) continue;
            this.warnOrKillContainer(container, (FSSchedulerApp)apps.get(container), sched);
            this.warnedContainers.add(container);
            Resources.subtractFrom((Resource)toPreempt, (Resource)container.getContainer().getResource());
        }
    }

    private void warnOrKillContainer(RMContainer container, FSSchedulerApp app, FSLeafQueue queue) {
        LOG.info((Object)("Preempting container (prio=" + container.getContainer().getPriority() + "res=" + container.getContainer().getResource() + ") from queue " + queue.getName()));
        Long time = app.getContainerPreemptionTime(container);
        if (time != null) {
            if (time + this.waitTimeBeforeKill < this.clock.getTime()) {
                ContainerStatus status = SchedulerUtils.createPreemptedContainerStatus(container.getContainerId(), "Container preempted by scheduler");
                this.completedContainer(container, status, RMContainerEventType.KILL);
                LOG.info((Object)("Killing container" + container + " (after waiting for premption for " + (this.clock.getTime() - time) + "ms)"));
            }
        } else {
            app.addPreemption(container, this.clock.getTime());
        }
    }

    protected Resource resToPreempt(FSLeafQueue sched, long curTime) {
        Resource resToPreempt;
        Resource target;
        String queue = sched.getName();
        long minShareTimeout = this.queueMgr.getMinSharePreemptionTimeout(queue);
        long fairShareTimeout = this.queueMgr.getFairSharePreemptionTimeout();
        Resource resDueToMinShare = Resources.none();
        Resource resDueToFairShare = Resources.none();
        if (curTime - sched.getLastTimeAtMinShare() > minShareTimeout) {
            target = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getMinShare(), (Resource)sched.getDemand());
            resDueToMinShare = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)Resources.none(), (Resource)Resources.subtract((Resource)target, (Resource)sched.getResourceUsage()));
        }
        if (curTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            target = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)sched.getFairShare(), (Resource)sched.getDemand());
            resDueToFairShare = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)Resources.none(), (Resource)Resources.subtract((Resource)target, (Resource)sched.getResourceUsage()));
        }
        if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)(resToPreempt = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)resDueToMinShare, (Resource)resDueToFairShare)), (Resource)Resources.none())) {
            String message = "Should preempt " + resToPreempt + " res for queue " + sched.getName() + ": resDueToMinShare = " + resDueToMinShare + ", resDueToFairShare = " + resDueToFairShare;
            LOG.info((Object)message);
        }
        return resToPreempt;
    }

    private void updateRunnability() {
        ArrayList<AppSchedulable> apps = new ArrayList<AppSchedulable>();
        for (FSLeafQueue leafQueue : this.queueMgr.getLeafQueues()) {
            for (AppSchedulable a : leafQueue.getAppSchedulables()) {
                a.setRunnable(false);
                apps.add(a);
            }
        }
        Collections.sort(apps, new FifoAppComparator());
        HashMap<String, Integer> userApps = new HashMap<String, Integer>();
        HashMap<String, Integer> queueApps = new HashMap<String, Integer>();
        for (AppSchedulable app : apps) {
            int queueCount;
            String user = app.getApp().getUser();
            String queue = app.getApp().getQueueName();
            int userCount = userApps.containsKey(user) ? (Integer)userApps.get(user) : 0;
            int n = queueCount = queueApps.containsKey(queue) ? (Integer)queueApps.get(queue) : 0;
            if (userCount >= this.queueMgr.getUserMaxApps(user) || queueCount >= this.queueMgr.getQueueMaxApps(queue)) continue;
            userApps.put(user, userCount + 1);
            queueApps.put(queue, queueCount + 1);
            app.setRunnable(true);
        }
    }

    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public synchronized ResourceWeights getAppWeight(AppSchedulable app) {
        if (!app.getRunnable()) {
            return ResourceWeights.NEUTRAL;
        }
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            weight = Math.log1p(app.getDemand().getMemory()) / Math.log(2.0);
        }
        weight *= (double)app.getPriority().getPriority();
        if (this.weightAdjuster != null) {
            weight = this.weightAdjuster.adjustWeight(app, weight);
        }
        return new ResourceWeights((float)weight);
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    public Resource getIncrementResourceCapability() {
        return this.incrAllocation;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    public double getNodeLocalityThreshold() {
        return this.nodeLocalityThreshold;
    }

    public double getRackLocalityThreshold() {
        return this.rackLocalityThreshold;
    }

    public Resource getClusterCapacity() {
        return this.clusterCapacity;
    }

    public synchronized Clock getClock() {
        return this.clock;
    }

    protected synchronized void setClock(Clock clock) {
        this.clock = clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    protected synchronized void addApplication(ApplicationAttemptId applicationAttemptId, String queueName, String user) {
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationAttemptId.getApplicationId());
        FSLeafQueue queue = this.assignToQueue(rmApp, queueName, user);
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, user, queue, new ActiveUsersManager(this.getRootQueueMetrics()), this.rmContext);
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !queue.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
            String msg = "User " + userUgi.getUserName() + " cannot submit applications to queue " + queue.getName();
            LOG.info((Object)msg);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, msg));
            return;
        }
        queue.addApp(schedulerApp);
        queue.getMetrics().submitApp(user, applicationAttemptId.getAttemptId());
        this.applications.put(applicationAttemptId, schedulerApp);
        LOG.info((Object)("Application Submission: " + applicationAttemptId + ", user: " + user + ", currently active: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.APP_ACCEPTED));
    }

    @VisibleForTesting
    FSLeafQueue assignToQueue(RMApp rmApp, String queueName, String user) {
        FSLeafQueue queue;
        if (queueName.equals("default") && this.userAsDefaultQueue) {
            queueName = user;
        }
        if ((queue = this.queueMgr.getLeafQueue(queueName, this.conf.getAllowUndeclaredPools())) == null) {
            queue = this.queueMgr.getLeafQueue("default", false);
        }
        if (rmApp != null) {
            rmApp.setQueue(queue.getName());
        } else {
            LOG.warn((Object)"Couldn't find RM app to set queue name on");
        }
        return queue;
    }

    private synchronized void removeApplication(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done." + " finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        FSSchedulerApp application = this.applications.get(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : application.getLiveContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : application.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        application.stop(rmAppAttemptFinalState);
        FSLeafQueue queue = this.queueMgr.getLeafQueue(application.getQueue().getQueueName(), false);
        queue.removeApp(application);
        this.applications.remove(applicationAttemptId);
    }

    private synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        ApplicationAttemptId applicationAttemptId = container.getId().getApplicationAttemptId();
        FSSchedulerApp application = this.applications.get(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " unknown application " + applicationAttemptId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FSSchedulerNode node = this.nodes.get(container.getNodeId());
        if (rmContainer.getState() == RMContainerState.RESERVED) {
            application.unreserve(node, rmContainer.getReservedPriority());
            node.unreserveResource(application);
        } else {
            application.containerCompleted(rmContainer, containerStatus, event);
            node.releaseContainer(container);
            this.updateRootQueueMetrics();
        }
        LOG.info((Object)("Application " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void addNode(RMNode node) {
        this.nodes.put(node.getNodeID(), new FSSchedulerNode(node, this.usePortForNodeName));
        Resources.addTo((Resource)this.clusterCapacity, (Resource)node.getTotalCapability());
        this.updateRootQueueMetrics();
        LOG.info((Object)("Added node " + node.getNodeAddress() + " cluster capacity: " + this.clusterCapacity));
    }

    private synchronized void removeNode(RMNode rmNode) {
        FSSchedulerNode node = this.nodes.get(rmNode.getNodeID());
        if (node == null) {
            return;
        }
        Resources.subtractFrom((Resource)this.clusterCapacity, (Resource)rmNode.getTotalCapability());
        this.updateRootQueueMetrics();
        List<RMContainer> runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(rmNode.getNodeID());
        LOG.info((Object)("Removed node " + rmNode.getNodeAddress() + " cluster capacity: " + this.clusterCapacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId appAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FSSchedulerApp application = this.applications.get(appAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + appAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, (ResourceCalculator)new DominantResourceCalculator(), this.clusterCapacity, this.minimumAllocation, this.maximumAllocation, this.incrAllocation);
        for (ContainerId releasedContainerId : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainerId);
            if (rmContainer == null) {
                RMAuditLogger.logFailure(application.getUser(), "AM Released Container", "Unauthorized access or invalid container", "FairScheduler", "Trying to release container not owned by app or with invalid id", application.getApplicationId(), releasedContainerId);
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(releasedContainerId, "Container released by application"), RMContainerEventType.RELEASED);
        }
        FSSchedulerApp fSSchedulerApp = application;
        synchronized (fSSchedulerApp) {
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + appAttemptId + " application=" + application.getApplicationId()));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)"allocate: post-update");
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + appAttemptId + " #ask=" + ask.size()));
                LOG.debug((Object)("Preempting " + application.getPreemptionContainers().size() + " container(s)"));
            }
            HashSet<ContainerId> preemptionContainerIds = new HashSet<ContainerId>();
            for (RMContainer container : application.getPreemptionContainers()) {
                preemptionContainerIds.add(container.getContainerId());
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            return new Allocation(application.pullNewlyAllocatedContainers(), application.getHeadroom(), preemptionContainerIds);
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FSSchedulerNode node) {
        ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
        FSSchedulerApp application = this.applications.get(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " launched container " + containerId + " on node: " + node));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    private synchronized void nodeUpdate(RMNode nm) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " cluster capacity: " + this.clusterCapacity));
        }
        this.eventLog.log("HEARTBEAT", nm.getHostName());
        FSSchedulerNode node = this.nodes.get(nm.getNodeID());
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        AppSchedulable reservedAppSchedulable = node.getReservedAppSchedulable();
        if (reservedAppSchedulable != null) {
            Priority reservedPriority = node.getReservedContainer().getReservedPriority();
            if (reservedAppSchedulable != null && !reservedAppSchedulable.hasContainerForNode(reservedPriority, node)) {
                LOG.info((Object)("Releasing reservation that cannot be satisfied for application " + reservedAppSchedulable.getApp().getApplicationAttemptId() + " on node " + nm));
                reservedAppSchedulable.unreserve(reservedPriority, node);
                reservedAppSchedulable = null;
            } else {
                LOG.info((Object)("Trying to fulfill reservation for application " + reservedAppSchedulable.getApp().getApplicationAttemptId() + " on node: " + nm));
                node.getReservedAppSchedulable().assignReservedContainer(node);
            }
        }
        if (reservedAppSchedulable == null) {
            int assignedContainers = 0;
            while (node.getReservedContainer() == null) {
                boolean assignedContainer = false;
                if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterCapacity, (Resource)this.queueMgr.getRootQueue().assignContainer(node), (Resource)Resources.none())) {
                    ++assignedContainers;
                    assignedContainer = true;
                }
                if (assignedContainer && this.assignMultiple && (assignedContainers < this.maxAssign || this.maxAssign <= 0)) continue;
                break;
            }
        }
        this.updateRootQueueMetrics();
    }

    @Override
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        FSSchedulerNode node = this.nodes.get(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    public FSSchedulerApp getSchedulerApp(ApplicationAttemptId appAttemptId) {
        return this.applications.get(appAttemptId);
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId appAttemptId) {
        if (!this.applications.containsKey(appAttemptId)) {
            LOG.error((Object)("Request for appInfo of unknown attempt" + appAttemptId));
            return null;
        }
        return new SchedulerAppReport(this.applications.get(appAttemptId));
    }

    private void updateRootQueueMetrics() {
        this.rootMetrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.clusterCapacity, (Resource)this.rootMetrics.getAllocatedResources()));
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.rootMetrics;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                if (!(event instanceof AppAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queue = appAddedEvent.getQueue();
                this.addApplication(appAddedEvent.getApplicationAttemptId(), queue, appAddedEvent.getUser());
                break;
            }
            case APP_REMOVED: {
                if (!(event instanceof AppRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.removeApplication(appRemovedEvent.getApplicationAttemptID(), appRemovedEvent.getFinalAttemptState());
                break;
            }
            case CONTAINER_EXPIRED: {
                if (!(event instanceof ContainerExpiredSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived at FairScheduler: " + event.toString()));
            }
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        this.conf = new FairSchedulerConfiguration(conf);
        this.validateConf(this.conf);
        this.minimumAllocation = this.conf.getMinimumAllocation();
        this.maximumAllocation = this.conf.getMaximumAllocation();
        this.incrAllocation = this.conf.getIncrementAllocation();
        this.userAsDefaultQueue = this.conf.getUserAsDefaultQueue();
        this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
        this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
        this.preemptionEnabled = this.conf.getPreemptionEnabled();
        this.assignMultiple = this.conf.getAssignMultiple();
        this.maxAssign = this.conf.getMaxAssign();
        this.sizeBasedWeight = this.conf.getSizeBasedWeight();
        this.preemptionInterval = this.conf.getPreemptionInterval();
        this.waitTimeBeforeKill = this.conf.getWaitTimeBeforeKill();
        this.usePortForNodeName = this.conf.getUsePortForNodeName();
        if (!this.initialized) {
            this.rootMetrics = FSQueueMetrics.forQueue("root", null, true, conf);
            this.rmContext = rmContext;
            this.eventLog = new FairSchedulerEventLog();
            this.eventLog.init(this.conf);
            this.initialized = true;
            try {
                this.queueMgr.initialize();
            }
            catch (Exception e) {
                throw new IOException("Failed to start FairScheduler", e);
            }
            Thread updateThread = new Thread(new UpdateThread());
            updateThread.setName("FairSchedulerUpdateThread");
            updateThread.setDaemon(true);
            updateThread.start();
        } else {
            try {
                this.queueMgr.reloadAllocs();
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize FairScheduler", e);
            }
        }
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        if (!this.queueMgr.exists(queueName)) {
            throw new IOException("queue " + queueName + " does not exist");
        }
        return this.queueMgr.getQueue(queueName).getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.queueMgr.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    @Override
    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        FSQueue queue = this.getQueueManager().getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    private class UpdateThread
    implements Runnable {
        private UpdateThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(FairScheduler.this.UPDATE_INTERVAL);
                        FairScheduler.this.update();
                        FairScheduler.this.preemptTasksIfNecessary();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

