/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulable
extends Schedulable {
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private FairScheduler scheduler;
    private FSSchedulerApp app;
    private Resource demand = Resources.createResource((int)0);
    private boolean runnable = false;
    private long startTime;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final Log LOG = LogFactory.getLog(AppSchedulable.class);
    private FSLeafQueue queue;
    private RMContainerTokenSecretManager containerTokenSecretManager;

    public AppSchedulable(FairScheduler scheduler, FSSchedulerApp app, FSLeafQueue queue) {
        this.scheduler = scheduler;
        this.app = app;
        this.startTime = System.currentTimeMillis();
        this.queue = queue;
        this.containerTokenSecretManager = scheduler.getContainerTokenSecretManager();
    }

    @Override
    public String getName() {
        return this.app.getApplicationId().toString();
    }

    public FSSchedulerApp getApp() {
        return this.app;
    }

    @Override
    public void updateDemand() {
        this.demand = Resources.createResource((int)0);
        Resources.addTo((Resource)this.demand, (Resource)this.app.getCurrentConsumption());
        for (Priority p : this.app.getPriorities()) {
            for (ResourceRequest r : this.app.getResourceRequests(p).values()) {
                Resource total = Resources.multiply((Resource)r.getCapability(), (double)r.getNumContainers());
                Resources.addTo((Resource)this.demand, (Resource)total);
            }
        }
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Resource getResourceUsage() {
        return this.app.getCurrentConsumption();
    }

    @Override
    public Resource getMinShare() {
        return Resources.none();
    }

    @Override
    public Resource getMaxShare() {
        return Resources.unbounded();
    }

    public QueueMetrics getMetrics() {
        return this.queue.getMetrics();
    }

    @Override
    public ResourceWeights getWeights() {
        return this.scheduler.getAppWeight(this);
    }

    @Override
    public Priority getPriority() {
        Priority p = (Priority)recordFactory.newRecordInstance(Priority.class);
        p.setPriority(1);
        return p;
    }

    public boolean getRunnable() {
        return this.runnable;
    }

    public void setRunnable(boolean runnable) {
        this.runnable = runnable;
    }

    public Container createContainer(FSSchedulerApp application, FSSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
        Token containerToken = this.containerTokenSecretManager.createContainerToken(containerId, nodeId, application.getUser(), capability);
        if (containerToken == null) {
            return null;
        }
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, (Token)containerToken);
        return container;
    }

    private void reserve(Priority priority, FSSchedulerNode node, Container container, boolean alreadyReserved) {
        LOG.info((Object)("Making reservation: node=" + node.getNodeName() + " app_id=" + this.app.getApplicationId()));
        if (!alreadyReserved) {
            this.getMetrics().reserveResource(this.app.getUser(), container.getResource());
            RMContainer rmContainer = this.app.reserve(node, priority, null, container);
            node.reserveResource(this.app, priority, rmContainer);
        } else {
            RMContainer rmContainer = node.getReservedContainer();
            this.app.reserve(node, priority, rmContainer, container);
            node.reserveResource(this.app, priority, rmContainer);
        }
    }

    public void unreserve(Priority priority, FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        this.app.unreserve(node, priority);
        node.unreserveResource(this.app);
        this.getMetrics().unreserveResource(this.app.getUser(), rmContainer.getContainer().getResource());
    }

    private Resource assignContainer(FSSchedulerNode node, Priority priority, ResourceRequest request, NodeType type, boolean reserved) {
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        Container container = null;
        container = reserved ? node.getReservedContainer().getContainer() : this.createContainer(this.app, node, capability, priority);
        if (Resources.fitsIn((Resource)capability, (Resource)available)) {
            RMContainer allocatedContainer = this.app.allocate(type, node, priority, request, container);
            if (allocatedContainer == null) {
                if (reserved) {
                    this.unreserve(priority, node);
                }
                return Resources.none();
            }
            if (reserved) {
                this.unreserve(priority, node);
            }
            node.allocateContainer(this.app.getApplicationId(), allocatedContainer);
            return container.getResource();
        }
        this.reserve(priority, node, container, reserved);
        return FairScheduler.CONTAINER_RESERVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node offered to app: " + this.getName() + " reserved: " + reserved));
        }
        if (reserved) {
            RMContainer rmContainer = node.getReservedContainer();
            Priority priority = rmContainer.getReservedPriority();
            if (this.app.getTotalRequiredResources(priority) == 0) {
                this.unreserve(priority, node);
                return Resources.none();
            }
        } else if (!this.getRunnable()) {
            return Resources.none();
        }
        Collection<Priority> prioritiesToTry = reserved ? Arrays.asList(node.getReservedContainer().getReservedPriority()) : this.app.getPriorities();
        FSSchedulerApp fSSchedulerApp = this.app;
        synchronized (fSSchedulerApp) {
            for (Priority priority : prioritiesToTry) {
                if (this.app.getTotalRequiredResources(priority) <= 0 || !this.hasContainerForNode(priority, node)) continue;
                this.app.addSchedulingOpportunity(priority);
                ResourceRequest rackLocalRequest = this.app.getResourceRequest(priority, node.getRackName());
                ResourceRequest localRequest = this.app.getResourceRequest(priority, node.getNodeName());
                if (localRequest != null && !localRequest.getRelaxLocality()) {
                    LOG.warn((Object)("Relax locality off is not supported on local request: " + localRequest));
                }
                NodeType allowedLocality = this.app.getAllowedLocalityLevel(priority, this.scheduler.getNumClusterNodes(), this.scheduler.getNodeLocalityThreshold(), this.scheduler.getRackLocalityThreshold());
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && localRequest != null && localRequest.getNumContainers() != 0) {
                    return this.assignContainer(node, priority, localRequest, NodeType.NODE_LOCAL, reserved);
                }
                if (rackLocalRequest != null && !rackLocalRequest.getRelaxLocality()) continue;
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && (allowedLocality.equals((Object)NodeType.RACK_LOCAL) || allowedLocality.equals((Object)NodeType.OFF_SWITCH))) {
                    return this.assignContainer(node, priority, rackLocalRequest, NodeType.RACK_LOCAL, reserved);
                }
                ResourceRequest offSwitchRequest = this.app.getResourceRequest(priority, "*");
                if (offSwitchRequest != null && !offSwitchRequest.getRelaxLocality() || offSwitchRequest == null || offSwitchRequest.getNumContainers() == 0 || !allowedLocality.equals((Object)NodeType.OFF_SWITCH)) continue;
                return this.assignContainer(node, priority, offSwitchRequest, NodeType.OFF_SWITCH, reserved);
            }
        }
        return Resources.none();
    }

    public Resource assignReservedContainer(FSSchedulerNode node) {
        return this.assignContainer(node, true);
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        return this.assignContainer(node, false);
    }

    public boolean hasContainerForNode(Priority prio, FSSchedulerNode node) {
        ResourceRequest anyRequest = this.app.getResourceRequest(prio, "*");
        ResourceRequest rackRequest = this.app.getResourceRequest(prio, node.getRackName());
        ResourceRequest nodeRequest = this.app.getResourceRequest(prio, node.getNodeName());
        return anyRequest != null && anyRequest.getNumContainers() > 0 && (anyRequest.getRelaxLocality() || rackRequest != null && rackRequest.getNumContainers() > 0) && (rackRequest == null || rackRequest.getRelaxLocality() || nodeRequest != null && nodeRequest.getNumContainers() > 0) && Resources.lessThanOrEqual((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)anyRequest.getCapability(), (Resource)node.getRMNode().getTotalCapability());
    }
}

