/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFairSchedulerConfiguration {
    @Test
    public void testParseResourceConfigValue() throws Exception {
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, 1024 mb"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 mb, 2 vcores"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2vcores,1024mb"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb,2vcores"));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testNoUnits() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyMemory() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyCPU() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024vcores");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testGibberish() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1o24vc0res");
    }

    @Test
    public void testGetAllocationFileFromClasspath() {
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration(new Configuration());
        conf.set("yarn.scheduler.fair.allocation.file", "test-fair-scheduler.xml");
        File allocationFile = conf.getAllocationFile();
        junit.framework.Assert.assertEquals((String)"test-fair-scheduler.xml", (String)allocationFile.getName());
        junit.framework.Assert.assertTrue((boolean)allocationFile.exists());
    }
}

