/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestRMDelegationTokens;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMDelegationTokens {
    private YarnConfiguration conf;

    @Before
    public void setup() {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        ExitUtil.disableSystemExit();
        this.conf = new YarnConfiguration();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
    }

    @Test(timeout=15000L)
    public void testRMDTMasterKeyStateOnRollingMasterKey() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmDTState = rmState.getRMDTSecretManagerState().getTokenState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        MyMockRM rm1 = new MyMockRM(this, (Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMDTSecretManager();
        Assert.assertEquals((Object)dtSecretManager.getAllMasterKeys(), (Object)rmDTMasterKeyState);
        HashSet expiringKeys = new HashSet();
        expiringKeys.addAll(dtSecretManager.getAllMasterKeys());
        DelegationKey oldCurrentKey = ((TestRMDelegationTokenSecretManager)dtSecretManager).getCurrentKey();
        GetDelegationTokenRequest request = (GetDelegationTokenRequest)Mockito.mock(GetDelegationTokenRequest.class);
        Mockito.when((Object)request.getRenewer()).thenReturn((Object)"renewer1");
        GetDelegationTokenResponse response = rm1.getClientRMService().getDelegationToken(request);
        org.apache.hadoop.yarn.api.records.Token delegationToken = response.getRMDelegationToken();
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken, null);
        RMDelegationTokenIdentifier dtId1 = (RMDelegationTokenIdentifier)token1.decodeIdentifier();
        while (((TestRMDelegationTokenSecretManager)dtSecretManager).numUpdatedKeys.get() < 1) {
            Thread.sleep(200L);
        }
        Assert.assertTrue((boolean)rmDTMasterKeyState.contains(oldCurrentKey));
        DelegationKey newCurrentKey = ((TestRMDelegationTokenSecretManager)dtSecretManager).getCurrentKey();
        Assert.assertTrue((boolean)rmDTMasterKeyState.contains(newCurrentKey));
        while (((TestRMDelegationTokenSecretManager)dtSecretManager).numUpdatedKeys.get() < 6) {
            Thread.sleep(200L);
        }
        Assert.assertFalse((boolean)rmDTState.containsKey(dtId1));
        rm1.stop();
    }

    @Test(timeout=15000L)
    public void testRemoveExpiredMasterKeyInRMStateStore() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        MyMockRM rm1 = new MyMockRM(this, (Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMDTSecretManager();
        Assert.assertEquals((Object)dtSecretManager.getAllMasterKeys(), (Object)rmDTMasterKeyState);
        HashSet expiringKeys = new HashSet();
        expiringKeys.addAll(dtSecretManager.getAllMasterKeys());
        while (true) {
            boolean allExpired = true;
            for (DelegationKey key : expiringKeys) {
                if (!rmDTMasterKeyState.contains(key)) continue;
                allExpired = false;
            }
            if (allExpired) break;
            Thread.sleep(500L);
        }
    }
}

