/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegationTokenRenewer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewer.class);
    public static final String SCHEME = "hdfs";
    private Timer renewalTimer;
    private RMContext rmContext;
    private DelegationTokenCancelThread dtCancelThread = new DelegationTokenCancelThread();
    private Set<DelegationTokenToRenew> delegationTokens = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<ApplicationId, Long> delayedRemovalMap = new ConcurrentHashMap();
    private long tokenRemovalDelayMs;
    private Thread delayedRemovalThread;
    private boolean isServiceStarted = false;
    private List<DelegationTokenToRenew> pendingTokenForRenewal = new ArrayList();
    private boolean tokenKeepAliveEnabled;

    public DelegationTokenRenewer() {
        super(DelegationTokenRenewer.class.getName());
    }

    protected synchronized void serviceInit(Configuration conf) throws Exception {
        this.tokenKeepAliveEnabled = conf.getBoolean("yarn.log-aggregation-enable", false);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.dtCancelThread.start();
        this.renewalTimer = new Timer(true);
        if (this.tokenKeepAliveEnabled) {
            this.delayedRemovalThread = new Thread((Runnable)new DelayedTokenRemovalRunnable(this, this.getConfig()), "DelayedTokenCanceller");
            this.delayedRemovalThread.start();
        }
        RMDelegationTokenIdentifier.Renewer.setSecretManager((AbstractDelegationTokenSecretManager)this.rmContext.getRMDelegationTokenSecretManager(), (InetSocketAddress)this.rmContext.getClientRMService().getBindAddress());
        this.isServiceStarted = true;
        this.renewIfServiceIsStarted(this.pendingTokenForRenewal);
        this.pendingTokenForRenewal.clear();
        super.serviceStart();
    }

    protected void serviceStop() {
        if (this.renewalTimer != null) {
            this.renewalTimer.cancel();
        }
        this.delegationTokens.clear();
        this.dtCancelThread.interrupt();
        try {
            this.dtCancelThread.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.tokenKeepAliveEnabled && this.delayedRemovalThread != null) {
            this.delayedRemovalThread.interrupt();
            try {
                this.delayedRemovalThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while joining on delayed removal thread.", (Throwable)e);
            }
        }
    }

    private void addTokenToList(DelegationTokenToRenew t) {
        this.delegationTokens.add(t);
    }

    @VisibleForTesting
    public Set<Token<?>> getDelegationTokens() {
        HashSet tokens = new HashSet();
        for (DelegationTokenToRenew delegationToken : this.delegationTokens) {
            tokens.add(delegationToken.token);
        }
        return tokens;
    }

    public void addApplication(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd) throws IOException {
        if (ts == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering tokens for renewal for: appId = " + applicationId));
        }
        Collection tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        ArrayList<DelegationTokenToRenew> tokenList = new ArrayList<DelegationTokenToRenew>();
        for (Token token : tokens) {
            if (!token.isManaged()) continue;
            tokenList.add(new DelegationTokenToRenew(applicationId, token, this.getConfig(), now, shouldCancelAtEnd));
        }
        if (!tokenList.isEmpty()) {
            this.renewIfServiceIsStarted(tokenList);
        }
    }

    protected void renewIfServiceIsStarted(List<DelegationTokenToRenew> dtrs) throws IOException {
        if (this.isServiceStarted) {
            for (DelegationTokenToRenew dtr : dtrs) {
                this.renewToken(dtr);
            }
            for (DelegationTokenToRenew dtr : dtrs) {
                this.addTokenToList(dtr);
                this.setTimerForTokenRenewal(dtr);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Registering token for renewal for: service = " + dtr.token.getService() + " for appId = " + dtr.applicationId));
            }
        } else {
            this.pendingTokenForRenewal.addAll(dtrs);
        }
    }

    @VisibleForTesting
    protected void setTimerForTokenRenewal(DelegationTokenToRenew token) throws IOException {
        long expiresIn = token.expirationDate - System.currentTimeMillis();
        long renewIn = token.expirationDate - expiresIn / 10L;
        RenewalTimerTask tTask = new RenewalTimerTask(this, token);
        token.setTimerTask((TimerTask)tTask);
        this.renewalTimer.schedule(token.timerTask, new Date(renewIn));
    }

    @VisibleForTesting
    protected void renewToken(DelegationTokenToRenew dttr) throws IOException {
        try {
            dttr.expirationDate = (Long)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void cancelToken(DelegationTokenToRenew t) {
        if (t.shouldCancelAtEnd) {
            this.dtCancelThread.cancelToken(t.token, t.conf);
        } else {
            LOG.info((Object)("Did not cancel " + t));
        }
    }

    private void removeFailedDelegationToken(DelegationTokenToRenew t) {
        ApplicationId applicationId = t.applicationId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing failed delegation token for appid=" + applicationId + ";t=" + t.token.getService()));
        }
        this.delegationTokens.remove(t);
        if (t.timerTask != null) {
            t.timerTask.cancel();
        }
    }

    public void applicationFinished(ApplicationId applicationId) {
        if (!this.tokenKeepAliveEnabled) {
            this.removeApplicationFromRenewal(applicationId);
        } else {
            this.delayedRemovalMap.put(applicationId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
        }
    }

    public void updateKeepAliveApplications(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.delayedRemovalMap.put(appId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationFromRenewal(ApplicationId applicationId) {
        Set set = this.delegationTokens;
        synchronized (set) {
            Iterator it = this.delegationTokens.iterator();
            while (it.hasNext()) {
                DelegationTokenToRenew dttr = (DelegationTokenToRenew)it.next();
                if (!dttr.applicationId.equals((Object)applicationId)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing delegation token for appId=" + applicationId + "; token=" + dttr.token.getService()));
                }
                if (dttr.timerTask != null) {
                    dttr.timerTask.cancel();
                }
                this.cancelToken(dttr);
                it.remove();
            }
        }
    }

    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ void access$100(DelegationTokenRenewer x0, DelegationTokenToRenew x1) {
        x0.removeFailedDelegationToken(x1);
    }

    static /* synthetic */ ConcurrentMap access$200(DelegationTokenRenewer x0) {
        return x0.delayedRemovalMap;
    }

    static /* synthetic */ void access$300(DelegationTokenRenewer x0, ApplicationId x1) {
        x0.removeApplicationFromRenewal(x1);
    }
}

