/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFairSchedulerEventLog {
    private File logFile;
    private FairScheduler scheduler;
    private ResourceManager resourceManager;

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("mapred.fairscheduler.eventlog.enabled", "true");
        conf.set("yarn.scheduler.fair.assignmultiple", "false");
        this.resourceManager = new ResourceManager();
        this.resourceManager.init((Configuration)conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.scheduler.reinitialize((Configuration)conf, this.resourceManager.getRMContext());
    }

    @Test
    public void testCreateEventLog() throws IOException {
        FairSchedulerEventLog eventLog = this.scheduler.getEventLog();
        this.logFile = new File(eventLog.getLogFile());
        Assert.assertTrue((boolean)this.logFile.exists());
    }

    @After
    public void tearDown() {
        this.logFile.delete();
        this.logFile.getParentFile().delete();
        this.scheduler = null;
        this.resourceManager = null;
    }
}

