/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSSchedulerApp {
    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    @Test
    public void testDelayScheduling() {
        int i;
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Priority prio = (Priority)Mockito.mock(Priority.class);
        Mockito.when((Object)prio.getPriority()).thenReturn((Object)1);
        double nodeLocalityThreshold = 0.5;
        double rackLocalityThreshold = 0.6;
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, "user1", queue, null, null);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 5; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        schedulerApp.resetAllowedLocalityLevel(prio, NodeType.NODE_LOCAL);
        schedulerApp.resetSchedulingOpportunities(prio);
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 5; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        for (i = 0; i < 6; ++i) {
            schedulerApp.addSchedulingOpportunity(prio);
            Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
        }
        schedulerApp.addSchedulingOpportunity(prio);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, nodeLocalityThreshold, rackLocalityThreshold));
    }

    @Test
    public void testLocalityLevelWithoutDelays() {
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Priority prio = (Priority)Mockito.mock(Priority.class);
        Mockito.when((Object)prio.getPriority()).thenReturn((Object)1);
        ApplicationAttemptId applicationAttemptId = this.createAppAttemptId(1, 1);
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, "user1", queue, null, null);
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)schedulerApp.getAllowedLocalityLevel(prio, 10, -1.0, -1.0));
    }
}

