/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FairSharePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SchedulingPolicy {
    private static final ConcurrentHashMap<Class<? extends SchedulingPolicy>, SchedulingPolicy> instances = new ConcurrentHashMap();
    private static SchedulingPolicy DEFAULT_POLICY = SchedulingPolicy.getInstance(FairSharePolicy.class);
    public static final byte DEPTH_LEAF = 1;
    public static final byte DEPTH_INTERMEDIATE = 2;
    public static final byte DEPTH_ROOT = 4;
    public static final byte DEPTH_PARENT = 6;
    public static final byte DEPTH_ANY = 7;

    public static SchedulingPolicy getDefault() {
        return DEFAULT_POLICY;
    }

    public static void setDefault(String className) throws AllocationConfigurationException {
        DEFAULT_POLICY = SchedulingPolicy.parse((String)className);
    }

    public static SchedulingPolicy getInstance(Class<? extends SchedulingPolicy> clazz) {
        SchedulingPolicy policy = (SchedulingPolicy)instances.get(clazz);
        if (policy == null) {
            policy = (SchedulingPolicy)ReflectionUtils.newInstance(clazz, null);
            instances.put(clazz, policy);
        }
        return policy;
    }

    public static SchedulingPolicy parse(String policy) throws AllocationConfigurationException {
        Class clazz;
        String text = policy.toLowerCase();
        if (text.equalsIgnoreCase("fair")) {
            clazz = FairSharePolicy.class;
        } else if (text.equalsIgnoreCase("FIFO")) {
            clazz = FifoPolicy.class;
        } else if (text.equalsIgnoreCase("DRF")) {
            clazz = DominantResourceFairnessPolicy.class;
        } else {
            try {
                clazz = Class.forName(policy);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AllocationConfigurationException(policy + " SchedulingPolicy class not found!");
            }
        }
        if (!SchedulingPolicy.class.isAssignableFrom(clazz)) {
            throw new AllocationConfigurationException(policy + " does not extend SchedulingPolicy");
        }
        return SchedulingPolicy.getInstance(clazz);
    }

    public void initialize(Resource clusterCapacity) {
    }

    public abstract String getName();

    public abstract byte getApplicableDepth();

    public static boolean isApplicableTo(SchedulingPolicy policy, byte depth) {
        return (policy.getApplicableDepth() & depth) == depth;
    }

    public abstract Comparator<Schedulable> getComparator();

    public abstract void computeShares(Collection<? extends Schedulable> var1, Resource var2);
}

