/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FiCaSchedulerApp
extends SchedulerApplication {
    private static final Log LOG = LogFactory.getLog(FiCaSchedulerApp.class);
    private final Set<ContainerId> containersToPreempt = new HashSet();

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
    }

    public synchronized boolean containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (null == this.liveContainers.remove(rmContainer.getContainerId())) {
            return false;
        }
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + rmContainer.getState() + " event:" + event));
        this.containersToPreempt.remove(rmContainer.getContainerId());
        RMAuditLogger.logSuccess((String)this.getUser(), (String)"AM Released Container", (String)"SchedulerApp", (ApplicationId)this.getApplicationId(), (ContainerId)containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom((Resource)this.currentConsumption, (Resource)containerResource);
        return true;
    }

    public synchronized RMContainer allocate(NodeType type, FiCaSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        if (this.isStopped) {
            return null;
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.rmContext.getDispatcher().getEventHandler(), this.rmContext.getContainerAllocationExpirer());
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        this.appSchedulingInfo.allocate(type, (SchedulerNode)node, priority, request, container);
        Resources.addTo((Resource)this.currentConsumption, (Resource)container.getResource());
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + type));
        }
        RMAuditLogger.logSuccess((String)this.getUser(), (String)"AM Allocated Container", (String)"SchedulerApp", (ApplicationId)this.getApplicationId(), (ContainerId)container.getId());
        return rmContainer;
    }

    public synchronized boolean unreserve(FiCaSchedulerNode node, Priority priority) {
        RMContainer reservedContainer;
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        if (reservedContainers != null && (reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID())) != null && reservedContainer.getContainer() != null && reservedContainer.getContainer().getResource() != null) {
            if (reservedContainers.isEmpty()) {
                this.reservedContainers.remove(priority);
            }
            this.resetReReservations(priority);
            Resource resource = reservedContainer.getContainer().getResource();
            Resources.subtractFrom((Resource)this.currentReservation, (Resource)resource);
            LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation));
            return true;
        }
        return false;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public Resource getTotalPendingRequests() {
        Resource ret = Resource.newInstance((int)0, (int)0);
        for (ResourceRequest rr : this.appSchedulingInfo.getAllResourceRequests()) {
            if (!ResourceRequest.isAnyLocation((String)rr.getResourceName())) continue;
            Resources.addTo((Resource)ret, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getNumContainers()));
        }
        return ret;
    }

    public synchronized void addPreemptContainer(ContainerId cont) {
        if (this.liveContainers.containsKey(cont)) {
            this.containersToPreempt.add(cont);
        }
    }

    public synchronized Allocation getAllocation(ResourceCalculator rc, Resource clusterResource, Resource minimumAllocation) {
        Set<ContainerId> currentContPreemption = Collections.unmodifiableSet(new HashSet(this.containersToPreempt));
        this.containersToPreempt.clear();
        Resource tot = Resource.newInstance((int)0, (int)0);
        for (ContainerId c : currentContPreemption) {
            Resources.addTo((Resource)tot, (Resource)((RMContainer)this.liveContainers.get(c)).getContainer().getResource());
        }
        int numCont = (int)Math.ceil(Resources.divide((ResourceCalculator)rc, (Resource)clusterResource, (Resource)tot, (Resource)minimumAllocation));
        ResourceRequest rr = ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)minimumAllocation, (int)numCont);
        return new Allocation(this.pullNewlyAllocatedContainers(), this.getHeadroom(), null, currentContPreemption, Collections.singletonList(rr));
    }
}

