/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.Mockito;

public class TestUtils {
    private static final Log LOG = LogFactory.getLog(TestUtils.class);
    public static SpyHook spyHook = new SpyHook();
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static RMContext getMockRMContext() {
        1 nullDispatcher = new /* Unavailable Anonymous Inner Class!! */;
        ContainerAllocationExpirer cae = new ContainerAllocationExpirer((Dispatcher)nullDispatcher);
        Configuration conf = new Configuration();
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)nullDispatcher, cae, null, null, null, new AMRMTokenSecretManager(conf), new RMContainerTokenSecretManager(conf), new NMTokenSecretManagerInRM(conf), new ClientToAMTokenSecretManagerInRM());
        return rmContext;
    }

    public static Priority createMockPriority(int priority) {
        Priority p = (Priority)recordFactory.newRecordInstance(Priority.class);
        p.setPriority(priority);
        return p;
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int numContainers, boolean relaxLocality, Priority priority, RecordFactory recordFactory) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        Resource capability = Resources.createResource((int)memory, (int)1);
        request.setNumContainers(numContainers);
        request.setResourceName(resourceName);
        request.setCapability(capability);
        request.setRelaxLocality(relaxLocality);
        request.setPriority(priority);
        return request;
    }

    public static ApplicationId getMockApplicationId(int appId) {
        ApplicationId applicationId = (ApplicationId)Mockito.mock(ApplicationId.class);
        Mockito.when((Object)applicationId.getClusterTimestamp()).thenReturn((Object)0L);
        Mockito.when((Object)applicationId.getId()).thenReturn((Object)appId);
        return applicationId;
    }

    public static ApplicationAttemptId getMockApplicationAttemptId(int appId, int attemptId) {
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)0L, (int)appId);
        ApplicationAttemptId applicationAttemptId = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
        Mockito.when((Object)applicationAttemptId.getApplicationId()).thenReturn((Object)applicationId);
        Mockito.when((Object)applicationAttemptId.getAttemptId()).thenReturn((Object)attemptId);
        return applicationAttemptId;
    }

    public static FiCaSchedulerNode getMockNode(String host, String rack, int port, int capability) {
        NodeId nodeId = (NodeId)Mockito.mock(NodeId.class);
        Mockito.when((Object)nodeId.getHost()).thenReturn((Object)host);
        Mockito.when((Object)nodeId.getPort()).thenReturn((Object)port);
        RMNode rmNode = (RMNode)Mockito.mock(RMNode.class);
        Mockito.when((Object)rmNode.getNodeID()).thenReturn((Object)nodeId);
        Mockito.when((Object)rmNode.getTotalCapability()).thenReturn((Object)Resources.createResource((int)capability, (int)1));
        Mockito.when((Object)rmNode.getNodeAddress()).thenReturn((Object)(host + ":" + port));
        Mockito.when((Object)rmNode.getHostName()).thenReturn((Object)host);
        Mockito.when((Object)rmNode.getRackName()).thenReturn((Object)rack);
        FiCaSchedulerNode node = (FiCaSchedulerNode)Mockito.spy((Object)new FiCaSchedulerNode(rmNode, false));
        LOG.info((Object)("node = " + host + " avail=" + node.getAvailableResource()));
        return node;
    }

    public static ContainerId getMockContainerId(FiCaSchedulerApp application) {
        ContainerId containerId = (ContainerId)Mockito.mock(ContainerId.class);
        ((ContainerId)Mockito.doReturn((Object)application.getApplicationAttemptId()).when((Object)containerId)).getApplicationAttemptId();
        ((ContainerId)Mockito.doReturn((Object)application.getNewContainerId()).when((Object)containerId)).getId();
        return containerId;
    }

    public static Container getMockContainer(ContainerId containerId, NodeId nodeId, Resource resource, Priority priority) {
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)containerId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        Mockito.when((Object)container.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getPriority()).thenReturn((Object)priority);
        return container;
    }
}

