/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCapacityScheduler {
    private static final Log LOG = LogFactory.getLog(TestCapacityScheduler.class);
    private final int GB = 1024;
    private static final String A = "root.a";
    private static final String B = "root.b";
    private static final String A1 = "root.a.a1";
    private static final String A2 = "root.a.a2";
    private static final String B1 = "root.b.b1";
    private static final String B2 = "root.b.b2";
    private static final String B3 = "root.b.b3";
    private static float A_CAPACITY = 10.5f;
    private static float B_CAPACITY = 89.5f;
    private static float A1_CAPACITY = 30.0f;
    private static float A2_CAPACITY = 70.0f;
    private static float B1_CAPACITY = 79.2f;
    private static float B2_CAPACITY = 0.8f;
    private static float B3_CAPACITY = 20.0f;
    private ResourceManager resourceManager = null;

    @Before
    public void setUp() throws Exception {
        this.resourceManager = new ResourceManager();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
    }

    @After
    public void tearDown() throws Exception {
        this.resourceManager.stop();
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        CapacityScheduler scheduler = new CapacityScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.reinitialize((Configuration)conf, null);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            scheduler.reinitialize((Configuration)conf, null);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    @Test
    public void testCapacityScheduler() throws Exception {
        LOG.info((Object)"--- START: testCapacityScheduler ---");
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1));
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1));
        Priority priority_0 = org.apache.hadoop.yarn.server.resourcemanager.resource.Priority.create((int)0);
        Priority priority_1 = org.apache.hadoop.yarn.server.resourcemanager.resource.Priority.create((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)3072, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        LOG.info((Object)"Kick!");
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info((Object)"Adding new tasks...");
        Task task_1_1 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_1);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        application_0.schedule();
        LOG.info((Object)("Sending hb from " + nm_0.getHostName()));
        this.nodeUpdate(nm_0);
        LOG.info((Object)("Sending hb from " + nm_1.getHostName()));
        this.nodeUpdate(nm_1);
        LOG.info((Object)"Trying to allocate...");
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(5120, application_1);
        this.nodeUpdate(nm_0);
        this.nodeUpdate(nm_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"--- END: testCapacityScheduler ---");
    }

    private void nodeUpdate(NodeManager nm) {
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacity("root.a", A_CAPACITY);
        conf.setCapacity("root.b", B_CAPACITY);
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", A1_CAPACITY);
        conf.setUserLimitFactor("root.a.a1", 100.0f);
        conf.setCapacity("root.a.a2", A2_CAPACITY);
        conf.setUserLimitFactor("root.a.a2", 100.0f);
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", B1_CAPACITY);
        conf.setUserLimitFactor("root.b.b1", 100.0f);
        conf.setCapacity("root.b.b2", B2_CAPACITY);
        conf.setUserLimitFactor("root.b.b2", 100.0f);
        conf.setCapacity("root.b.b3", B3_CAPACITY);
        conf.setUserLimitFactor("root.b.b3", 100.0f);
        LOG.info((Object)"Setup top-level queues a and b");
    }

    @Test
    public void testMaximumCapacitySetup() {
        float delta = 1.0E-7f;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        Assert.assertEquals((double)100.0, (double)conf.getMaximumCapacity("root.a"), (double)delta);
        conf.setMaximumCapacity("root.a", 50.0f);
        Assert.assertEquals((double)50.0, (double)conf.getMaximumCapacity("root.a"), (double)delta);
        conf.setMaximumCapacity("root.a", -1.0f);
        Assert.assertEquals((double)100.0, (double)conf.getMaximumCapacity("root.a"), (double)delta);
    }

    @Test
    public void testRefreshQueues() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM()));
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        conf.setCapacity("root.a", 80.0f);
        conf.setCapacity("root.b", 20.0f);
        cs.reinitialize((Configuration)conf, null);
        this.checkQueueCapacities(cs, 80.0f, 20.0f);
    }

    private void checkQueueCapacities(CapacityScheduler cs, float capacityA, float capacityB) {
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = this.findQueue(rootQueue, "root.a");
        CSQueue queueB = this.findQueue(rootQueue, "root.b");
        CSQueue queueA1 = this.findQueue(queueA, "root.a.a1");
        CSQueue queueA2 = this.findQueue(queueA, "root.a.a2");
        CSQueue queueB1 = this.findQueue(queueB, "root.b.b1");
        CSQueue queueB2 = this.findQueue(queueB, "root.b.b2");
        CSQueue queueB3 = this.findQueue(queueB, "root.b.b3");
        float capA = capacityA / 100.0f;
        float capB = capacityB / 100.0f;
        this.checkQueueCapacity(queueA, capA, capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB, capB, capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueA1, A1_CAPACITY / 100.0f, A1_CAPACITY / 100.0f * capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueA2, A2_CAPACITY / 100.0f, A2_CAPACITY / 100.0f * capA, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB1, B1_CAPACITY / 100.0f, B1_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB2, B2_CAPACITY / 100.0f, B2_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
        this.checkQueueCapacity(queueB3, B3_CAPACITY / 100.0f, B3_CAPACITY / 100.0f * capB, 1.0f, 1.0f);
    }

    private void checkQueueCapacity(CSQueue q, float expectedCapacity, float expectedAbsCapacity, float expectedMaxCapacity, float expectedAbsMaxCapacity) {
        float epsilon = 1.0E-5f;
        Assert.assertEquals((String)"capacity", (double)expectedCapacity, (double)q.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((String)"absolute capacity", (double)expectedAbsCapacity, (double)q.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((String)"maximum capacity", (double)expectedMaxCapacity, (double)q.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((String)"absolute maximum capacity", (double)expectedAbsMaxCapacity, (double)q.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
    }

    private CSQueue findQueue(CSQueue root, String queuePath) {
        if (root.getQueuePath().equals(queuePath)) {
            return root;
        }
        List childQueues = root.getChildQueues();
        if (childQueues != null) {
            for (CSQueue q : childQueues) {
                CSQueue result;
                if (!queuePath.startsWith(q.getQueuePath()) || (result = this.findQueue(q, queuePath)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private void checkApplicationResourceUsage(int expected, Application application) {
        junit.framework.Assert.assertEquals((int)expected, (int)application.getUsedResources().getMemory());
    }

    private void checkNodeResourceUsage(int expected, NodeManager node) {
        junit.framework.Assert.assertEquals((int)expected, (int)node.getUsed().getMemory());
        node.checkResourceUsage();
    }

    @Test(expected=IOException.class)
    public void testParseQueue() throws IOException {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        conf.setQueues("root.a.a1", new String[]{"b1"});
        conf.setCapacity("root.a.a1.b1", 100.0f);
        conf.setUserLimitFactor("root.a.a1.b1", 100.0f);
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM()));
    }

    @Test
    public void testReconnectedNode() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.reinitialize((Configuration)csConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM()));
        RMNode n1 = MockNodes.newNodeInfo((int)0, (Resource)MockNodes.newResource((int)4096), (int)1);
        RMNode n2 = MockNodes.newNodeInfo((int)0, (Resource)MockNodes.newResource((int)2048), (int)2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        junit.framework.Assert.assertEquals((int)6144, (int)cs.getClusterResources().getMemory());
        n1 = MockNodes.newNodeInfo((int)0, (Resource)MockNodes.newResource((int)2048), (int)1);
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        junit.framework.Assert.assertEquals((int)4096, (int)cs.getClusterResources().getMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshQueuesWithNewQueue() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.reinitialize((Configuration)conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM()));
        this.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        String B4 = "root.b.b4";
        float B4_CAPACITY = 10.0f;
        B3_CAPACITY -= B4_CAPACITY;
        try {
            conf.setCapacity("root.a", 80.0f);
            conf.setCapacity("root.b", 20.0f);
            conf.setQueues("root.b", new String[]{"b1", "b2", "b3", "b4"});
            conf.setCapacity("root.b.b1", B1_CAPACITY);
            conf.setCapacity("root.b.b2", B2_CAPACITY);
            conf.setCapacity("root.b.b3", B3_CAPACITY);
            conf.setCapacity(B4, B4_CAPACITY);
            cs.reinitialize((Configuration)conf, null);
            this.checkQueueCapacities(cs, 80.0f, 20.0f);
            CSQueue rootQueue = cs.getRootQueue();
            CSQueue queueB = this.findQueue(rootQueue, "root.b");
            CSQueue queueB4 = this.findQueue(queueB, B4);
            Assert.assertEquals((Object)queueB, (Object)queueB4.getParent());
        }
        finally {
            B3_CAPACITY += B4_CAPACITY;
        }
    }

    @Test
    public void testCapacitySchedulerInfo() throws Exception {
        QueueInfo queueInfo = this.resourceManager.getResourceScheduler().getQueueInfo("a", true, true);
        junit.framework.Assert.assertEquals((String)queueInfo.getQueueName(), (String)"a");
        junit.framework.Assert.assertEquals((int)queueInfo.getChildQueues().size(), (int)2);
        List userACLInfo = this.resourceManager.getResourceScheduler().getQueueUserAclInfo();
        junit.framework.Assert.assertNotNull((Object)userACLInfo);
        for (QueueUserACLInfo queueUserACLInfo : userACLInfo) {
            junit.framework.Assert.assertEquals((int)this.getQueueCount(userACLInfo, queueUserACLInfo.getQueueName()), (int)1);
        }
    }

    private int getQueueCount(List<QueueUserACLInfo> queueInformation, String queueName) {
        int result = 0;
        for (QueueUserACLInfo queueUserACLInfo : queueInformation) {
            if (!queueName.equals(queueUserACLInfo.getQueueName())) continue;
            ++result;
        }
        return result;
    }

    @Test
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo((int)0, (Resource)MockNodes.newResource((int)4096), (int)1, (String)host);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAddedSchedulerEvent event = new AppAddedSchedulerEvent(appAttemptId, "default", "user");
        cs.handle((SchedulerEvent)event);
        cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null);
        junit.framework.Assert.assertTrue((boolean)cs.getApplication(appAttemptId).isBlacklisted(host));
        cs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host));
        junit.framework.Assert.assertFalse((boolean)cs.getApplication(appAttemptId).isBlacklisted(host));
        rm.stop();
    }

    @Test(timeout=5000L)
    public void testApplicationComparator() {
        CapacityScheduler cs = new CapacityScheduler();
        Comparator appComparator = cs.getApplicationComparator();
        ApplicationId id1 = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationId id2 = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationId id3 = ApplicationId.newInstance((long)2L, (int)1);
        FiCaSchedulerApp app1 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)id1);
        FiCaSchedulerApp app2 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app2.getApplicationId()).thenReturn((Object)id2);
        FiCaSchedulerApp app3 = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)app3.getApplicationId()).thenReturn((Object)id3);
        Assert.assertTrue((appComparator.compare(app1, app2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((appComparator.compare(app1, app3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((appComparator.compare(app2, app3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentAccessOnApplications() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        TestCapacityScheduler.verifyConcurrentAccessOnApplications((Map)cs.applications, FiCaSchedulerApp.class);
    }

    public static <T extends SchedulerApplication> void verifyConcurrentAccessOnApplications(Map<ApplicationAttemptId, T> applications, Class<T> clazz) throws Exception {
        int size = 10000;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)0);
        Constructor<T> ctor = clazz.getDeclaredConstructor(ApplicationAttemptId.class, String.class, Queue.class, ActiveUsersManager.class, RMContext.class);
        ApplicationAttemptId appAttemptId0 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        applications.put(appAttemptId0, ctor.newInstance(appAttemptId0, null, Mockito.mock(Queue.class), null, null));
        Assert.assertNotNull(applications.get(appAttemptId0));
        AtomicBoolean finished = new AtomicBoolean(false);
        AtomicBoolean failed = new AtomicBoolean(false);
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        while (!finished.get()) {
            Assert.assertNotNull(applications.get(appAttemptId0));
        }
        Assert.assertFalse((boolean)failed.get());
    }
}

