/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class CapacityScheduler
implements PreemptableResourceScheduler,
CapacitySchedulerContext,
Configurable {
    private static final Log LOG = LogFactory.getLog(CapacityScheduler.class);
    private CSQueue root;
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList();
    static final Comparator<CSQueue> queueComparator = new /* Unavailable Anonymous Inner Class!! */;
    static final Comparator<FiCaSchedulerApp> applicationComparator = new /* Unavailable Anonymous Inner Class!! */;
    private CapacitySchedulerConfiguration conf;
    private Configuration yarnConf;
    private RMContext rmContext;
    private Map<String, CSQueue> queues = new ConcurrentHashMap();
    private Map<NodeId, FiCaSchedulerNode> nodes = new ConcurrentHashMap();
    private Resource clusterResource = (Resource)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Resource.class);
    private int numNodeManagers = 0;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    @VisibleForTesting
    protected Map<ApplicationAttemptId, FiCaSchedulerApp> applications = new ConcurrentHashMap();
    private boolean initialized = false;
    private ResourceCalculator calculator;
    private boolean usePortForNodeName;
    @InterfaceAudience.Private
    public static final String ROOT_QUEUE = "yarn.scheduler.capacity.root";
    private static final QueueHook noop = new QueueHook();
    private static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0, (int)0));

    public void setConf(Configuration conf) {
        this.yarnConf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0" + ", max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores <= 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min and max should be greater than 0" + ", max should be no smaller than min.");
        }
    }

    public Configuration getConf() {
        return this.yarnConf;
    }

    public QueueMetrics getRootQueueMetrics() {
        return this.root.getMetrics();
    }

    public CSQueue getRootQueue() {
        return this.root;
    }

    public CapacitySchedulerConfiguration getConfiguration() {
        return this.conf;
    }

    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    public Comparator<FiCaSchedulerApp> getApplicationComparator() {
        return applicationComparator;
    }

    public ResourceCalculator getResourceCalculator() {
        return this.calculator;
    }

    public Comparator<CSQueue> getQueueComparator() {
        return queueComparator;
    }

    public synchronized int getNumClusterNodes() {
        return this.numNodeManagers;
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public Resource getClusterResources() {
        return this.clusterResource;
    }

    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        if (!this.initialized) {
            this.conf = new CapacitySchedulerConfiguration(conf);
            this.validateConf((Configuration)this.conf);
            this.minimumAllocation = this.conf.getMinimumAllocation();
            this.maximumAllocation = this.conf.getMaximumAllocation();
            this.calculator = this.conf.getResourceCalculator();
            this.usePortForNodeName = this.conf.getUsePortForNodeName();
            this.rmContext = rmContext;
            this.initializeQueues(this.conf);
            this.initialized = true;
            LOG.info((Object)("Initialized CapacityScheduler with calculator=" + this.getResourceCalculator().getClass() + ", " + "minimumAllocation=<" + this.getMinimumResourceCapability() + ">, " + "maximumAllocation=<" + this.getMaximumResourceCapability() + ">"));
        } else {
            CapacitySchedulerConfiguration oldConf = this.conf;
            this.conf = new CapacitySchedulerConfiguration(conf);
            this.validateConf((Configuration)this.conf);
            try {
                LOG.info((Object)"Re-initializing queues...");
                this.reinitializeQueues(this.conf);
            }
            catch (Throwable t) {
                this.conf = oldConf;
                throw new IOException("Failed to re-init queues", t);
            }
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this, (CapacitySchedulerConfiguration)conf, null, (String)"root", (Map)this.queues, (Map)this.queues, (QueueHook)noop);
        LOG.info((Object)("Initialized root queue " + this.root));
    }

    @Lock(value={CapacityScheduler.class})
    private void reinitializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        HashMap newQueues = new HashMap();
        CSQueue newRoot = CapacityScheduler.parseQueue((CapacitySchedulerContext)this, (CapacitySchedulerConfiguration)conf, null, (String)"root", newQueues, (Map)this.queues, (QueueHook)noop);
        this.validateExistingQueues(this.queues, newQueues);
        this.addNewQueues(this.queues, newQueues);
        this.root.reinitialize(newRoot, this.clusterResource);
    }

    @Lock(value={CapacityScheduler.class})
    private void validateExistingQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) throws IOException {
        for (String queue : queues.keySet()) {
            if (newQueues.containsKey(queue)) continue;
            throw new IOException(queue + " cannot be found during refresh!");
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void addNewQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) {
        for (Map.Entry<String, CSQueue> e : newQueues.entrySet()) {
            String queueName = e.getKey();
            CSQueue queue = e.getValue();
            if (queues.containsKey(queueName)) continue;
            queues.put(queueName, queue);
        }
    }

    @Lock(value={CapacityScheduler.class})
    static CSQueue parseQueue(CapacitySchedulerContext csContext, CapacitySchedulerConfiguration conf, CSQueue parent, String queueName, Map<String, CSQueue> queues, Map<String, CSQueue> oldQueues, QueueHook hook) throws IOException {
        LeafQueue queue;
        String[] childQueueNames = conf.getQueues(parent == null ? queueName : parent.getQueuePath() + "." + queueName);
        if (childQueueNames == null || childQueueNames.length == 0) {
            if (null == parent) {
                throw new IllegalStateException("Queue configuration missing child queue names for " + queueName);
            }
            queue = new LeafQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook((CSQueue)queue);
        } else {
            ParentQueue parentQueue = new ParentQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook((CSQueue)parentQueue);
            ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
            for (String childQueueName : childQueueNames) {
                CSQueue childQueue = CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)conf, (CSQueue)queue, (String)childQueueName, queues, oldQueues, (QueueHook)hook);
                childQueues.add(childQueue);
            }
            parentQueue.setChildQueues(childQueues);
        }
        if (queue instanceof LeafQueue && queues.containsKey(queueName) && queues.get(queueName) instanceof LeafQueue) {
            throw new IOException("Two leaf queues were named " + queueName + ". Leaf queue names must be distinct");
        }
        queues.put(queueName, (CSQueue)queue);
        LOG.info((Object)("Initialized queue: " + queue));
        return queue;
    }

    synchronized CSQueue getQueue(String queueName) {
        return (CSQueue)this.queues.get(queueName);
    }

    private synchronized void addApplication(ApplicationAttemptId applicationAttemptId, String queueName, String user) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            String message = "Application " + applicationAttemptId + " submitted by user " + user + " to unknown queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, message));
            return;
        }
        if (!(queue instanceof LeafQueue)) {
            String message = "Application " + applicationAttemptId + " submitted by user " + user + " to non-leaf queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, message));
            return;
        }
        FiCaSchedulerApp SchedulerApp = new FiCaSchedulerApp(applicationAttemptId, user, (Queue)queue, queue.getActiveUsersManager(), this.rmContext);
        try {
            queue.submitApplication(SchedulerApp, user, queueName);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application " + applicationAttemptId + " to queue " + queueName + " from user " + user), (Throwable)ace);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, ace.toString()));
            return;
        }
        this.applications.put(applicationAttemptId, SchedulerApp);
        LOG.info((Object)("Application Submission: " + applicationAttemptId + ", user: " + user + " queue: " + queue + ", currently active: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.APP_ACCEPTED));
    }

    private synchronized void doneApplication(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done." + " finalState=" + rmAppAttemptFinalState));
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : application.getLiveContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)rmContainer.getContainerId(), (String)"Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : application.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)rmContainer.getContainerId(), (String)"Application Complete"), RMContainerEventType.KILL);
        }
        application.stop(rmAppAttemptFinalState);
        String queueName = application.getQueue().getQueueName();
        CSQueue queue = (CSQueue)this.queues.get(queueName);
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("Cannot finish application from non-leaf queue: " + queueName));
        } else {
            queue.finishApplication(application, queue.getQueueName());
        }
        this.applications.remove(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value={Lock.NoLock.class})
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, (ResourceCalculator)this.getResourceCalculator(), (Resource)this.getClusterResources(), (Resource)this.getMinimumResourceCapability(), (Resource)this.maximumAllocation);
        for (ContainerId releasedContainerId : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainerId);
            if (rmContainer == null) {
                RMAuditLogger.logFailure((String)application.getUser(), (String)"AM Released Container", (String)"Unauthorized access or invalid container", (String)"CapacityScheduler", (String)"Trying to release container not owned by app or with invalid id", (ApplicationId)application.getApplicationId(), (ContainerId)releasedContainerId);
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)releasedContainerId, (String)"Container released by application"), RMContainerEventType.RELEASED);
        }
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                LOG.info((Object)("Calling allocate on a stopped application " + applicationAttemptId));
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + applicationAttemptId + " application=" + application));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)"allocate: post-update");
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            return application.getAllocation(this.getResourceCalculator(), this.clusterResource, this.getMinimumResourceCapability());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value={Lock.NoLock.class})
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        CSQueue queue = null;
        CapacityScheduler capacityScheduler = this;
        synchronized (capacityScheduler) {
            queue = (CSQueue)this.queues.get(queueName);
        }
        if (queue == null) {
            throw new IOException("Unknown queue: " + queueName);
        }
        return queue.getQueueInfo(includeChildQueues, recursive);
    }

    @Lock(value={Lock.NoLock.class})
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.root.getQueueUserAclInfo(user);
    }

    private synchronized void nodeUpdate(RMNode nm) {
        RMContainer reservedContainer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " clusterResources: " + this.clusterResource));
        }
        FiCaSchedulerNode node = this.getNode(nm.getNodeID());
        List containerInfoList = nm.pullContainerUpdates();
        ArrayList newlyLaunchedContainers = new ArrayList();
        ArrayList completedContainers = new ArrayList();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node being looked for scheduling " + nm + " availableResource: " + node.getAvailableResource()));
        }
        if ((reservedContainer = node.getReservedContainer()) != null) {
            FiCaSchedulerApp reservedApplication = this.getApplication(reservedContainer.getApplicationAttemptId());
            LOG.info((Object)("Trying to fulfill reservation for application " + reservedApplication.getApplicationId() + " on node: " + nm));
            LeafQueue queue = (LeafQueue)reservedApplication.getQueue();
            CSAssignment assignment = queue.assignContainers(this.clusterResource, node);
            RMContainer excessReservation = assignment.getExcessReservation();
            if (excessReservation != null) {
                Container container = excessReservation.getContainer();
                queue.completedContainer(this.clusterResource, assignment.getApplication(), node, excessReservation, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getId(), (String)"Container reservation no longer required."), RMContainerEventType.RELEASED, null);
            }
        }
        if (node.getReservedContainer() == null) {
            this.root.assignContainers(this.clusterResource, node);
        } else {
            LOG.info((Object)("Skipping scheduling since node " + nm + " is reserved by application " + node.getReservedContainer().getContainerId().getApplicationAttemptId()));
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FiCaSchedulerNode node) {
        ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " launched container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    public void handle(SchedulerEvent event) {
        switch (3.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$scheduler$event$SchedulerEventType[((SchedulerEventType)event.getType()).ordinal()]) {
            case 1: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case 2: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case 3: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case 4: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationAttemptId(), appAddedEvent.getQueue(), appAddedEvent.getUser());
                break;
            }
            case 5: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationAttemptID(), appRemovedEvent.getFinalAttemptState());
                break;
            }
            case 6: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private synchronized void addNode(RMNode nodeManager) {
        this.nodes.put(nodeManager.getNodeID(), new FiCaSchedulerNode(nodeManager, this.usePortForNodeName));
        Resources.addTo((Resource)this.clusterResource, (Resource)nodeManager.getTotalCapability());
        this.root.updateClusterResource(this.clusterResource);
        ++this.numNodeManagers;
        LOG.info((Object)("Added node " + nodeManager.getNodeAddress() + " clusterResource: " + this.clusterResource));
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node = (FiCaSchedulerNode)this.nodes.get(nodeInfo.getNodeID());
        if (node == null) {
            return;
        }
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getRMNode().getTotalCapability());
        this.root.updateClusterResource(this.clusterResource);
        --this.numNodeManagers;
        List runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)reservedContainer.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        LOG.info((Object)("Removed node " + nodeInfo.getNodeAddress() + " clusterResource: " + this.clusterResource));
    }

    @Lock(value={CapacityScheduler.class})
    private synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        ApplicationAttemptId applicationAttemptId = container.getId().getApplicationAttemptId();
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " unknown application " + applicationAttemptId + " completed with event " + event));
            return;
        }
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        LeafQueue queue = (LeafQueue)application.getQueue();
        queue.completedContainer(this.clusterResource, application, node, rmContainer, containerStatus, event, null);
        LOG.info((Object)("Application " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + event));
    }

    @Lock(value={Lock.NoLock.class})
    FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return (FiCaSchedulerApp)this.applications.get(applicationAttemptId);
    }

    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId applicationAttemptId) {
        FiCaSchedulerApp app = this.getApplication(applicationAttemptId);
        return app == null ? null : new SchedulerAppReport((SchedulerApplication)app);
    }

    @Lock(value={Lock.NoLock.class})
    FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodes.get(nodeId);
    }

    private RMContainer getRMContainer(ContainerId containerId) {
        FiCaSchedulerApp application = this.getApplication(containerId.getApplicationAttemptId());
        return application == null ? null : application.getRMContainer(containerId);
    }

    @Lock(value={Lock.NoLock.class})
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        FiCaSchedulerNode node = this.getNode(nodeId);
        return node == null ? null : new SchedulerNodeReport((SchedulerNode)node);
    }

    public void dropContainerReservation(RMContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DROP_RESERVATION:" + container.toString()));
        }
        this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container reservation no longer required."), RMContainerEventType.KILL);
    }

    public void preemptContainer(ApplicationAttemptId aid, RMContainer cont) {
        FiCaSchedulerApp app;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PREEMPT_CONTAINER: application:" + aid.toString() + " container: " + cont.toString()));
        }
        if ((app = (FiCaSchedulerApp)this.applications.get(aid)) != null) {
            app.addPreemptContainer(cont.getContainerId());
        }
    }

    public void killContainer(RMContainer cont) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("KILL_CONTAINER: container" + cont.toString()));
        }
        this.completedContainer(cont, SchedulerUtils.createPreemptedContainerStatus((ContainerId)cont.getContainerId(), (String)("Container being forcibly preempted:" + cont.getContainerId())), RMContainerEventType.KILL);
    }

    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }
}

