/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public class RMContainerImpl
implements RMContainer {
    private static final Log LOG = LogFactory.getLog(RMContainerImpl.class);
    private static final StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)RMContainerState.NEW).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition(null)).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition(null)).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition(null)).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition(null)).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED, (SingleArcTransition)new AcquiredTransition(null)).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new FinishedTransition(null)).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new FinishedTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.LAUNCHED, (SingleArcTransition)new LaunchedTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new ContainerFinishedAtAcquiredState(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new FinishedTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.EXPIRE).addTransition((Enum)RMContainerState.COMPLETED, (Enum)RMContainerState.COMPLETED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.EXPIRED, (Enum)RMContainerState.EXPIRED, EnumSet.of(RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.RELEASED, (Enum)RMContainerState.RELEASED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).addTransition((Enum)RMContainerState.KILLED, (Enum)RMContainerState.KILLED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).installTopology();
    private final StateMachine<RMContainerState, RMContainerEventType, RMContainerEvent> stateMachine = stateMachineFactory.make((Object)this);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final ApplicationAttemptId appAttemptId;
    private final NodeId nodeId;
    private final Container container;
    private final EventHandler eventHandler;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private Resource reservedResource;
    private NodeId reservedNode;
    private Priority reservedPriority;

    public RMContainerImpl(Container container, ApplicationAttemptId appAttemptId, NodeId nodeId, EventHandler handler, ContainerAllocationExpirer containerAllocationExpirer) {
        this.containerId = container.getId();
        this.nodeId = nodeId;
        this.container = container;
        this.appAttemptId = appAttemptId;
        this.eventHandler = handler;
        this.containerAllocationExpirer = containerAllocationExpirer;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainerState getState() {
        this.readLock.lock();
        try {
            RMContainerState rMContainerState = (RMContainerState)this.stateMachine.getCurrentState();
            return rMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getReservedResource() {
        return this.reservedResource;
    }

    public NodeId getReservedNode() {
        return this.reservedNode;
    }

    public Priority getReservedPriority() {
        return this.reservedPriority;
    }

    public String toString() {
        return this.containerId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMContainerEvent event) {
        LOG.debug((Object)("Processing " + event.getContainerId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on container " + this.containerId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(event.getContainerId() + " Container Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static /* synthetic */ Resource access$802(RMContainerImpl x0, Resource x1) {
        x0.reservedResource = x1;
        return x0.reservedResource;
    }

    static /* synthetic */ NodeId access$902(RMContainerImpl x0, NodeId x1) {
        x0.reservedNode = x1;
        return x0.reservedNode;
    }

    static /* synthetic */ Priority access$1002(RMContainerImpl x0, Priority x1) {
        x0.reservedPriority = x1;
        return x0.reservedPriority;
    }

    static /* synthetic */ ApplicationAttemptId access$1100(RMContainerImpl x0) {
        return x0.appAttemptId;
    }

    static /* synthetic */ Container access$1200(RMContainerImpl x0) {
        return x0.container;
    }

    static /* synthetic */ EventHandler access$1300(RMContainerImpl x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ ContainerAllocationExpirer access$1400(RMContainerImpl x0) {
        return x0.containerAllocationExpirer;
    }

    static /* synthetic */ NodeId access$1500(RMContainerImpl x0) {
        return x0.nodeId;
    }

    static /* synthetic */ ContainerId access$1600(RMContainerImpl x0) {
        return x0.containerId;
    }
}

