/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStoredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMAppAttemptImpl
implements RMAppAttempt,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final Priority AM_CONTAINER_PRIORITY = (Priority)recordFactory.newRecordInstance(Priority.class);
    private final StateMachine<RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachine;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId applicationAttemptId;
    private final ApplicationSubmissionContext submissionContext;
    private Token<AMRMTokenIdentifier> amrmToken = null;
    private SecretKey clientTokenMasterKey = null;
    private final Set<NodeId> ranNodes = new HashSet();
    private final List<ContainerStatus> justFinishedContainers = new ArrayList();
    private Container masterContainer;
    private float progress = 0.0f;
    private String host = "N/A";
    private int rpcPort;
    private String origTrackingUrl = "N/A";
    private String proxiedTrackingUrl = "N/A";
    private long startTime = 0L;
    private FinalApplicationStatus finalStatus = null;
    private final StringBuilder diagnostics = new StringBuilder();
    private Configuration conf;
    private String user;
    private static final ExpiredTransition EXPIRED_TRANSITION;
    private static final StateMachineFactory<RMAppAttemptImpl, RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachineFactory;
    private static final List<ContainerId> EMPTY_CONTAINER_RELEASE_LIST;
    private static final List<ResourceRequest> EMPTY_CONTAINER_REQUEST_LIST;

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, Configuration conf, String user) {
        this.conf = conf;
        this.applicationAttemptId = appAttemptId;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(null);
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.user = user;
    }

    public ApplicationAttemptId getAppAttemptId() {
        return this.applicationAttemptId;
    }

    public ApplicationSubmissionContext getSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            FinalApplicationStatus finalApplicationStatus = this.finalStatus;
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAppAttemptState getAppAttemptState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        this.readLock.lock();
        try {
            String string = this.host;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRpcPort() {
        this.readLock.lock();
        try {
            int n = this.rpcPort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.getSubmissionContext().getUnmanagedAM() ? this.origTrackingUrl : this.proxiedTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOriginalTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.origTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWebProxyBase() {
        this.readLock.lock();
        try {
            String string = ProxyUriUtils.getPath((ApplicationId)this.applicationAttemptId.getApplicationId());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyUriWithScheme(String trackingUriWithoutScheme) {
        this.readLock.lock();
        try {
            URI trackingUri = StringUtils.isEmpty((String)trackingUriWithoutScheme) ? null : ProxyUriUtils.getUriFromAMUrl((String)trackingUriWithoutScheme);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)this.conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)proxy);
            URI result = ProxyUriUtils.getProxyUri((URI)trackingUri, (URI)proxyUri, (ApplicationId)this.applicationAttemptId.getApplicationId());
            String string = result.toASCIIString();
            return string;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not proxify " + trackingUriWithoutScheme), (Throwable)e);
            String string = trackingUriWithoutScheme;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setTrackingUrlToRMAppPage() {
        this.proxiedTrackingUrl = this.origTrackingUrl = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)this.conf), "cluster", "app", this.getAppAttemptId().getApplicationId()});
    }

    public SecretKey getClientTokenMasterKey() {
        return this.clientTokenMasterKey;
    }

    public Token<AMRMTokenIdentifier> getAMRMToken() {
        return this.amrmToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<ClientToAMTokenIdentifier> createClientToken(String client) {
        this.readLock.lock();
        try {
            Token token = null;
            ClientToAMTokenSecretManagerInRM secretMgr = this.rmContext.getClientToAMTokenSecretManager();
            if (client != null && secretMgr.getMasterKey(this.applicationAttemptId) != null) {
                token = new Token((TokenIdentifier)new ClientToAMTokenIdentifier(this.applicationAttemptId, client), (SecretManager)secretMgr);
            }
            Token token2 = token;
            return token2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDiagnostics() {
        this.readLock.lock();
        try {
            String string = this.diagnostics.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiagnostics(String message) {
        this.writeLock.lock();
        try {
            this.diagnostics.append(message);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerStatus> getJustFinishedContainers() {
        this.readLock.lock();
        try {
            List list = this.justFinishedContainers;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerStatus> pullJustFinishedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerStatus> returnList = new ArrayList<ContainerStatus>(this.justFinishedContainers.size());
            returnList.addAll(this.justFinishedContainers);
            this.justFinishedContainers.clear();
            ArrayList<ContainerStatus> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container getMasterContainer() {
        this.readLock.lock();
        try {
            Container container = this.masterContainer;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setMasterContainer(Container container) {
        this.masterContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppAttemptEvent event) {
        this.writeLock.lock();
        try {
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            LOG.debug((Object)("Processing event for " + appAttemptID + " of type " + event.getType()));
            RMAppAttemptState oldState = this.getAppAttemptState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getAppAttemptState()) {
                LOG.info((Object)(appAttemptID + " State change from " + oldState + " to " + this.getAppAttemptState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        this.readLock.lock();
        try {
            int numUsedContainers = 0;
            int numReservedContainers = 0;
            Resource currentConsumption = Resources.createResource((int)0, (int)0);
            Resource reservedResources = Resources.createResource((int)0, (int)0);
            SchedulerAppReport schedApp = this.scheduler.getSchedulerAppInfo(this.getAppAttemptId());
            if (schedApp != null) {
                Collection liveContainers = schedApp.getLiveContainers();
                Collection reservedContainers = schedApp.getReservedContainers();
                if (liveContainers != null) {
                    numUsedContainers = liveContainers.size();
                    for (RMContainer lc : liveContainers) {
                        Resources.addTo((Resource)currentConsumption, (Resource)lc.getContainer().getResource());
                    }
                }
                if (reservedContainers != null) {
                    numReservedContainers = reservedContainers.size();
                    for (RMContainer rc : reservedContainers) {
                        Resources.addTo((Resource)reservedResources, (Resource)rc.getContainer().getResource());
                    }
                }
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = BuilderUtils.newApplicationResourceUsageReport((int)numUsedContainers, (int)numReservedContainers, (Resource)currentConsumption, (Resource)reservedResources, (Resource)Resources.add((Resource)currentConsumption, (Resource)reservedResources));
            return applicationResourceUsageReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)state.getApplicationState().get(this.getAppAttemptId().getApplicationId());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(this.getAppAttemptId());
        assert (attemptState != null);
        this.setMasterContainer(attemptState.getMasterContainer());
        this.recoverAppAttemptCredentials(attemptState.getAppAttemptCredentials());
        LOG.info((Object)("Recovered attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer));
        this.setDiagnostics("Attempt recovered after RM restart");
        this.handle(new RMAppAttemptEvent(this.getAppAttemptId(), RMAppAttemptEventType.RECOVER));
    }

    private void recoverAppAttemptCredentials(Credentials appAttemptTokens) throws IOException {
        if (appAttemptTokens == null) {
            return;
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            byte[] clientTokenMasterKeyBytes = appAttemptTokens.getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME);
            this.clientTokenMasterKey = this.rmContext.getClientToAMTokenSecretManager().registerMasterKey(this.applicationAttemptId, clientTokenMasterKeyBytes);
        }
        this.amrmToken = appAttemptTokens.getToken(RMStateStore.AM_RM_TOKEN_SERVICE);
        this.rmContext.getAMRMTokenSecretManager().addPersistedPassword(this.amrmToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void launchAttempt() {
        this.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.LAUNCH, (RMAppAttempt)this));
    }

    private void attemptLaunched() {
        this.rmContext.getAMLivelinessMonitor().register((Object)this.getAppAttemptId());
    }

    private void checkAttemptStoreError(RMAppAttemptEvent event) {
        RMAppAttemptStoredEvent storeEvent = (RMAppAttemptStoredEvent)event;
        if (storeEvent.getStoredException() != null) {
            LOG.error((Object)("Failed to store attempt: " + this.getAppAttemptId()), (Throwable)storeEvent.getStoredException());
            ExitUtil.terminate((int)1, (Throwable)storeEvent.getStoredException());
        }
    }

    private void storeAttempt(RMStateStore store) {
        LOG.info((Object)("Storing attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer));
        store.storeApplicationAttempt((RMAppAttempt)this);
    }

    private void removeCredentials(RMAppAttemptImpl appAttempt) {
        if (UserGroupInformation.isSecurityEnabled()) {
            appAttempt.rmContext.getClientToAMTokenSecretManager().unRegisterApplication(appAttempt.getAppAttemptId());
        }
        appAttempt.rmContext.getAMRMTokenSecretManager().applicationMasterFinished(appAttempt.getAppAttemptId());
    }

    private static String sanitizeTrackingUrl(String url) {
        return url == null || url.trim().isEmpty() ? "N/A" : url;
    }

    static /* synthetic */ long access$1402(RMAppAttemptImpl x0, long x1) {
        x0.startTime = x1;
        return x0.startTime;
    }

    static /* synthetic */ ApplicationAttemptId access$1500(RMAppAttemptImpl x0) {
        return x0.applicationAttemptId;
    }

    static /* synthetic */ ApplicationMasterService access$1600(RMAppAttemptImpl x0) {
        return x0.masterService;
    }

    static /* synthetic */ SecretKey access$1702(RMAppAttemptImpl x0, SecretKey x1) {
        x0.clientTokenMasterKey = x1;
        return x0.clientTokenMasterKey;
    }

    static /* synthetic */ RMContext access$1800(RMAppAttemptImpl x0) {
        return x0.rmContext;
    }

    static /* synthetic */ Token access$1902(RMAppAttemptImpl x0, Token x1) {
        x0.amrmToken = x1;
        return x0.amrmToken;
    }

    static /* synthetic */ ApplicationSubmissionContext access$2000(RMAppAttemptImpl x0) {
        return x0.submissionContext;
    }

    static /* synthetic */ String access$2100(RMAppAttemptImpl x0) {
        return x0.user;
    }

    static /* synthetic */ EventHandler access$2200(RMAppAttemptImpl x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ void access$2300(RMAppAttemptImpl x0, RMAppAttemptImpl x1) {
        x0.removeCredentials(x1);
    }

    static /* synthetic */ List access$2400() {
        return EMPTY_CONTAINER_RELEASE_LIST;
    }

    static /* synthetic */ YarnScheduler access$2500(RMAppAttemptImpl x0) {
        return x0.scheduler;
    }

    static /* synthetic */ void access$2600(RMAppAttemptImpl x0, RMStateStore x1) {
        x0.storeAttempt(x1);
    }

    static /* synthetic */ List access$2700() {
        return EMPTY_CONTAINER_REQUEST_LIST;
    }

    static /* synthetic */ void access$2800(RMAppAttemptImpl x0, Container x1) {
        x0.setMasterContainer(x1);
    }

    static /* synthetic */ void access$2900(RMAppAttemptImpl x0, RMAppAttemptEvent x1) {
        x0.checkAttemptStoreError(x1);
    }

    static /* synthetic */ void access$3000(RMAppAttemptImpl x0) {
        x0.launchAttempt();
    }

    static /* synthetic */ void access$3100(RMAppAttemptImpl x0) {
        x0.setTrackingUrlToRMAppPage();
    }

    static /* synthetic */ Log access$3200() {
        return LOG;
    }

    static /* synthetic */ void access$3300(RMAppAttemptImpl x0) {
        x0.attemptLaunched();
    }

    static /* synthetic */ StringBuilder access$3400(RMAppAttemptImpl x0) {
        return x0.diagnostics;
    }

    static /* synthetic */ String access$3502(RMAppAttemptImpl x0, String x1) {
        x0.host = x1;
        return x0.host;
    }

    static /* synthetic */ int access$3602(RMAppAttemptImpl x0, int x1) {
        x0.rpcPort = x1;
        return x0.rpcPort;
    }

    static /* synthetic */ String access$3702(RMAppAttemptImpl x0, String x1) {
        x0.origTrackingUrl = x1;
        return x0.origTrackingUrl;
    }

    static /* synthetic */ String access$3800(String x0) {
        return RMAppAttemptImpl.sanitizeTrackingUrl((String)x0);
    }

    static /* synthetic */ String access$3902(RMAppAttemptImpl x0, String x1) {
        x0.proxiedTrackingUrl = x1;
        return x0.proxiedTrackingUrl;
    }

    static /* synthetic */ String access$3700(RMAppAttemptImpl x0) {
        return x0.origTrackingUrl;
    }

    static /* synthetic */ String access$4000(RMAppAttemptImpl x0, String x1) {
        return x0.generateProxyUriWithScheme(x1);
    }

    static /* synthetic */ float access$4102(RMAppAttemptImpl x0, float x1) {
        x0.progress = x1;
        return x0.progress;
    }

    static /* synthetic */ FinalApplicationStatus access$4202(RMAppAttemptImpl x0, FinalApplicationStatus x1) {
        x0.finalStatus = x1;
        return x0.finalStatus;
    }

    static /* synthetic */ Set access$4300(RMAppAttemptImpl x0) {
        return x0.ranNodes;
    }

    static /* synthetic */ Container access$4400(RMAppAttemptImpl x0) {
        return x0.masterContainer;
    }

    static /* synthetic */ List access$4500(RMAppAttemptImpl x0) {
        return x0.justFinishedContainers;
    }

    static {
        AM_CONTAINER_PRIORITY.setPriority(0);
        EXPIRED_TRANSITION = new ExpiredTransition();
        stateMachineFactory = new StateMachineFactory((Enum)RMAppAttemptState.NEW).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptEventType.START, (SingleArcTransition)new AttemptStartedTransition(null)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new UnexpectedAMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.RECOVERED, (Enum)RMAppAttemptEventType.RECOVER).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition(null)).addTransition((Enum)RMAppAttemptState.SUBMITTED, EnumSet.of(RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.APP_ACCEPTED, (MultipleArcTransition)new ScheduleTransition(null)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new UnexpectedAMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new AMContainerAllocatedTransition(null)).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.ATTEMPT_SAVED, (SingleArcTransition)new AttemptStoredTransition(null)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition(null)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.ATTEMPT_SAVED, (SingleArcTransition)new UnmanagedAMAttemptSavedTransition(null)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new UnexpectedAMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition(null)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.LAUNCHED, (SingleArcTransition)new AMLaunchedTransition(null)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.LAUNCH_FAILED, (SingleArcTransition)new LaunchFailedTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new KillAllocatedAMTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new AMContainerCrashedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new AMRegisteredTransition(null)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new AMContainerCrashedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)EXPIRED_TRANSITION).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.UNREGISTERED, (MultipleArcTransition)new AMUnregisteredTransition(null)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.STATUS_UPDATE, (SingleArcTransition)new StatusUpdateTransition(null)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition(null)).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.RUNNING, RMAppAttemptState.FAILED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition(null)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)EXPIRED_TRANSITION).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, EnumSet.of(RMAppAttemptEventType.EXPIRE, new RMAppAttemptEventType[]{RMAppAttemptEventType.KILL, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED})).addTransition((Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new AMFinishingContainerFinishedTransition(null)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FINISHED)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, EnumSet.of(RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, EnumSet.of(RMAppAttemptEventType.APP_ACCEPTED, new RMAppAttemptEventType[]{RMAppAttemptEventType.APP_REJECTED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.ATTEMPT_SAVED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).addTransition((Enum)RMAppAttemptState.RECOVERED, (Enum)RMAppAttemptState.RECOVERED, EnumSet.of(RMAppAttemptEventType.START, new RMAppAttemptEventType[]{RMAppAttemptEventType.APP_ACCEPTED, RMAppAttemptEventType.APP_REJECTED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_ACQUIRED, RMAppAttemptEventType.ATTEMPT_SAVED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).installTopology();
        EMPTY_CONTAINER_RELEASE_LIST = new ArrayList();
        EMPTY_CONTAINER_REQUEST_LIST = new ArrayList();
    }
}

