/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resourcetracker;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.resourcetracker.TestNMExpiry;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Before;
import org.junit.Test;

public class TestNMExpiry {
    private static final Log LOG = LogFactory.getLog(TestNMExpiry.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    ResourceTrackerService resourceTrackerService;
    boolean stopT = false;
    RegisterNodeManagerRequest request3;

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        InlineDispatcher dispatcher = new InlineDispatcher();
        RMContextImpl context = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, null, null, null);
        dispatcher.register(SchedulerEventType.class, (EventHandler)new InlineDispatcher.EmptyEventHandler());
        dispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)context));
        TestNmLivelinessMonitor nmLivelinessMonitor = new TestNmLivelinessMonitor(this, (Dispatcher)dispatcher);
        nmLivelinessMonitor.init(conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)context);
        nodesListManager.init(conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.start();
        this.resourceTrackerService = new ResourceTrackerService((RMContext)context, nodesListManager, (NMLivelinessMonitor)nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        this.resourceTrackerService.init(conf);
        this.resourceTrackerService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNMExpiry() throws Exception {
        String hostname1 = "localhost1";
        String hostname2 = "localhost2";
        String hostname3 = "localhost3";
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
        request1.setNodeId(nodeId1);
        request1.setHttpPort(0);
        request1.setResource(capability);
        this.resourceTrackerService.registerNodeManager(request1);
        RegisterNodeManagerRequest request2 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId2 = NodeId.newInstance((String)hostname2, (int)0);
        request2.setNodeId(nodeId2);
        request2.setHttpPort(0);
        request2.setResource(capability);
        this.resourceTrackerService.registerNodeManager(request2);
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumLostNMs() != 2 && waitCount++ < 20) {
            TestNMExpiry testNMExpiry = this;
            synchronized (testNMExpiry) {
                this.wait(100L);
            }
        }
        Assert.assertEquals((int)2, (int)ClusterMetrics.getMetrics().getNumLostNMs());
        this.request3 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId3 = NodeId.newInstance((String)hostname3, (int)0);
        this.request3.setNodeId(nodeId3);
        this.request3.setHttpPort(0);
        this.request3.setResource(capability);
        this.resourceTrackerService.registerNodeManager(this.request3);
        this.stopT = false;
        new ThirdNodeHeartBeatThread(this, null).start();
        Assert.assertEquals((int)2, (int)ClusterMetrics.getMetrics().getNumLostNMs());
        this.stopT = true;
    }

    static /* synthetic */ RecordFactory access$000() {
        return recordFactory;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

