/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRemovedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppStoredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStoredEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore
extends AbstractService {
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;
    public static final Text AM_RM_TOKEN_SERVICE = new Text("AM_RM_TOKEN_SERVICE");
    public static final Text AM_CLIENT_TOKEN_MASTER_KEY_NAME = new Text("YARN_CLIENT_TOKEN_MASTER_KEY");

    public RMStateStore() {
        super(RMStateStore.class.getName());
    }

    public void setRMDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, (EventHandler)new ForwardingEventHandler(this, null));
        this.initInternal(conf);
    }

    protected synchronized void serviceStart() throws Exception {
        this.dispatcher.start();
        this.startInternal();
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    protected abstract void startInternal() throws Exception;

    public synchronized void serviceStop() throws Exception {
        this.closeInternal();
        this.dispatcher.stop();
    }

    protected abstract void closeInternal() throws Exception;

    public abstract RMState loadState() throws Exception;

    public synchronized void storeApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), context, app.getUser());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppEvent(appState));
    }

    protected abstract void storeApplicationState(String var1, ApplicationStateDataPBImpl var2) throws Exception;

    public synchronized void storeApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
        ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials);
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptState(String var1, ApplicationAttemptStateDataPBImpl var2) throws Exception;

    public synchronized void storeRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        this.storeRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber);
    }

    protected abstract void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, int sequenceNumber) throws Exception {
        this.removeRMDelegationTokenState(rmDTIdentifier);
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public synchronized void storeRMDTMasterKey(DelegationKey delegationKey) throws Exception {
        this.storeRMDTMasterKeyState(delegationKey);
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeRMDTMasterKey(DelegationKey delegationKey) throws Exception {
        this.removeRMDTMasterKeyState(delegationKey);
    }

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeApplication(RMApp app) {
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getApplicationSubmissionContext(), app.getUser());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
            ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials);
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        this.removeApplication(appState);
    }

    public synchronized void removeApplication(ApplicationState appState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationState(ApplicationState var1) throws Exception;

    private Credentials getCredentialsFromAppAttempt(RMAppAttempt appAttempt) {
        SecretKey clientTokenMasterKey;
        Credentials credentials = new Credentials();
        Token appToken = appAttempt.getAMRMToken();
        if (appToken != null) {
            credentials.addToken(AM_RM_TOKEN_SERVICE, appToken);
        }
        if ((clientTokenMasterKey = appAttempt.getClientTokenMasterKey()) != null) {
            credentials.addSecretKey(AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenMasterKey.getEncoded());
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleStoreEvent(RMStateStoreEvent event) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$recovery$RMStateStoreEventType[((RMStateStoreEventType)event.getType()).ordinal()]) {
            case 1: {
                ApplicationState apptState = ((RMStateStoreAppEvent)event).getAppState();
                Exception storedException = null;
                ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl();
                appStateData.setSubmitTime(apptState.getSubmitTime());
                appStateData.setApplicationSubmissionContext(apptState.getApplicationSubmissionContext());
                appStateData.setUser(apptState.getUser());
                ApplicationId appId = apptState.getApplicationSubmissionContext().getApplicationId();
                LOG.info((Object)("Storing info for app: " + appId));
                try {
                    this.storeApplicationState(appId.toString(), appStateData);
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Error storing app: " + appId), (Throwable)e);
                        storedException = e;
                    }
                    catch (Throwable throwable) {
                        this.notifyDoneStoringApplication(appId, storedException);
                        throw throwable;
                    }
                    this.notifyDoneStoringApplication(appId, storedException);
                    break;
                }
                this.notifyDoneStoringApplication(appId, storedException);
                break;
            }
            case 2: {
                ApplicationAttemptState attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
                Exception storedException = null;
                Credentials credentials = attemptState.getAppAttemptCredentials();
                ByteBuffer appAttemptTokens = null;
                try {
                    if (credentials != null) {
                        DataOutputBuffer dob = new DataOutputBuffer();
                        credentials.writeTokenStorageToStream((DataOutputStream)dob);
                        appAttemptTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
                    }
                    ApplicationAttemptStateDataPBImpl attemptStateData = (ApplicationAttemptStateDataPBImpl)ApplicationAttemptStateDataPBImpl.newApplicationAttemptStateData((ApplicationAttemptId)attemptState.getAttemptId(), (Container)attemptState.getMasterContainer(), appAttemptTokens);
                    LOG.info((Object)("Storing info for attempt: " + attemptState.getAttemptId()));
                    this.storeApplicationAttemptState(attemptState.getAttemptId().toString(), attemptStateData);
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Error storing appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                        storedException = e;
                    }
                    catch (Throwable throwable) {
                        this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                        throw throwable;
                    }
                    this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                    break;
                }
                this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                break;
            }
            case 3: {
                ApplicationState appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
                ApplicationId appId = appState.getAppId();
                Exception removedException = null;
                LOG.info((Object)("Removing info for app: " + appId));
                try {
                    this.removeApplicationState(appState);
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Error removing app: " + appId), (Throwable)e);
                        removedException = e;
                    }
                    catch (Throwable throwable) {
                        this.notifyDoneRemovingApplcation(appId, removedException);
                        throw throwable;
                    }
                    this.notifyDoneRemovingApplcation(appId, removedException);
                    break;
                }
                this.notifyDoneRemovingApplcation(appId, removedException);
                break;
            }
            default: {
                LOG.error((Object)("Unknown RMStateStoreEvent type: " + event.getType()));
            }
        }
    }

    private void notifyDoneStoringApplication(ApplicationId appId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppStoredEvent(appId, storedException));
    }

    private void notifyDoneStoringApplicationAttempt(ApplicationAttemptId attemptId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppAttemptStoredEvent(attemptId, storedException));
    }

    private void notifyDoneRemovingApplcation(ApplicationId appId, Exception removedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppRemovedEvent(appId, removedException));
    }

    static /* synthetic */ void access$100(RMStateStore x0, RMStateStoreEvent x1) {
        x0.handleStoreEvent(x1);
    }
}

