/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(FileSystemRMStateStore.class);
    private static final String ROOT_DIR_NAME = "FSRMStateRoot";
    private static final String RM_DT_SECRET_MANAGER_ROOT = "RMDTSecretManagerRoot";
    private static final String RM_APP_ROOT = "RMAppRoot";
    private static final String DELEGATION_KEY_PREFIX = "DelegationKey_";
    private static final String DELEGATION_TOKEN_PREFIX = "RMDelegationToken_";
    private static final String DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX = "RMDTSequenceNumber_";
    protected FileSystem fs;
    private Path rootDirPath;
    private Path rmDTSecretManagerRoot;
    private Path rmAppRoot;
    private Path dtSequenceNumberPath = null;
    @VisibleForTesting
    Path fsWorkingPath;

    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.state-store.uri"));
        this.rootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.rmDTSecretManagerRoot = new Path(this.rootDirPath, RM_DT_SECRET_MANAGER_ROOT);
        this.rmAppRoot = new Path(this.rootDirPath, RM_APP_ROOT);
    }

    protected synchronized void startInternal() throws Exception {
        this.fs = this.fsWorkingPath.getFileSystem(this.getConfig());
        this.fs.mkdirs(this.rmDTSecretManagerRoot);
        this.fs.mkdirs(this.rmAppRoot);
    }

    protected synchronized void closeInternal() throws Exception {
        this.fs.close();
    }

    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        return rmState;
    }

    private void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        try {
            ArrayList<RMStateStore.ApplicationAttemptState> attempts = new ArrayList<RMStateStore.ApplicationAttemptState>();
            for (FileStatus appDir : this.fs.listStatus(this.rmAppRoot)) {
                for (FileStatus childNodeStatus : this.fs.listStatus(appDir.getPath())) {
                    assert (childNodeStatus.isFile());
                    String childNodeName = childNodeStatus.getPath().getName();
                    byte[] childData = this.readFile(childNodeStatus.getPath(), childNodeStatus.getLen());
                    if (childNodeName.startsWith("application_")) {
                        LOG.info((Object)("Loading application from node: " + childNodeName));
                        ApplicationId appId = ConverterUtils.toApplicationId((String)childNodeName);
                        ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.parseFrom((byte[])childData));
                        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser());
                        assert (appId.equals((Object)appState.context.getApplicationId()));
                        rmState.appState.put(appId, appState);
                        continue;
                    }
                    if (childNodeName.startsWith("appattempt_")) {
                        LOG.info((Object)("Loading application attempt from node: " + childNodeName));
                        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)childNodeName);
                        ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.parseFrom((byte[])childData));
                        Credentials credentials = null;
                        if (attemptStateData.getAppAttemptTokens() != null) {
                            credentials = new Credentials();
                            DataInputByteBuffer dibb = new DataInputByteBuffer();
                            dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
                            credentials.readTokenStorageStream((DataInputStream)dibb);
                        }
                        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer(), credentials);
                        assert (attemptId.equals((Object)attemptState.getAttemptId()));
                        attempts.add(attemptState);
                        continue;
                    }
                    LOG.info((Object)("Unknown child node with name: " + childNodeName));
                }
            }
            for (RMStateStore.ApplicationAttemptState attemptState : attempts) {
                ApplicationId appId = attemptState.getAttemptId().getApplicationId();
                RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmState.appState.get(appId);
                assert (appState != null);
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus[] childNodes;
        for (FileStatus childNodeStatus : childNodes = this.fs.listStatus(this.rmDTSecretManagerRoot)) {
            assert (childNodeStatus.isFile());
            String childNodeName = childNodeStatus.getPath().getName();
            if (childNodeName.startsWith(DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX)) {
                rmState.rmSecretManagerState.dtSequenceNumber = Integer.parseInt(childNodeName.split("_")[1]);
                continue;
            }
            Path childNodePath = this.getNodePath(this.rmDTSecretManagerRoot, childNodeName);
            byte[] childData = this.readFile(childNodePath, childNodeStatus.getLen());
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            if (childNodeName.startsWith(DELEGATION_KEY_PREFIX)) {
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
            } else if (childNodeName.startsWith(DELEGATION_TOKEN_PREFIX)) {
                RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier();
                identifier.readFields((DataInput)fsIn);
                long renewDate = fsIn.readLong();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
            } else {
                LOG.warn((Object)"Unknown file for recovering RMDelegationTokenSecretManager");
            }
            fsIn.close();
        }
    }

    public synchronized void storeApplicationState(String appId, ApplicationStateDataPBImpl appStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appId);
        this.fs.mkdirs(appDirPath);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId);
        LOG.info((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    public synchronized void storeApplicationAttemptState(String attemptId, ApplicationAttemptStateDataPBImpl attemptStateDataPB) throws Exception {
        ApplicationAttemptId appAttemptId = ConverterUtils.toApplicationAttemptId((String)attemptId);
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        Path nodeCreatePath = this.getNodePath(appDirPath, attemptId);
        LOG.info((Object)("Storing info for attempt: " + attemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for attempt: " + attemptId), (Throwable)e);
            throw e;
        }
    }

    public synchronized void removeApplicationState(RMStateStore.ApplicationState appState) throws Exception {
        String appId = appState.getAppId().toString();
        Path nodeRemovePath = this.getAppDir(this.rmAppRoot, appId);
        LOG.info((Object)("Removing info for app: " + appId + " at: " + nodeRemovePath));
        this.deleteFile(nodeRemovePath);
    }

    public synchronized void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier identifier, Long renewDate, int latestSequenceNumber) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, DELEGATION_TOKEN_PREFIX + identifier.getSequenceNumber());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        LOG.info((Object)("Storing RMDelegationToken_" + identifier.getSequenceNumber()));
        identifier.write((DataOutput)fsOut);
        fsOut.writeLong(renewDate);
        this.writeFile(nodeCreatePath, os.toByteArray());
        fsOut.close();
        Path latestSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX + latestSequenceNumber);
        LOG.info((Object)("Storing RMDTSequenceNumber_" + latestSequenceNumber));
        if (this.dtSequenceNumberPath == null) {
            if (!this.createFile(latestSequenceNumberPath)) {
                throw new Exception("Failed to create " + latestSequenceNumberPath);
            }
        } else if (!this.renameFile(this.dtSequenceNumberPath, latestSequenceNumberPath)) {
            throw new Exception("Failed to rename " + this.dtSequenceNumberPath);
        }
        this.dtSequenceNumberPath = latestSequenceNumberPath;
    }

    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier identifier) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, DELEGATION_TOKEN_PREFIX + identifier.getSequenceNumber());
        LOG.info((Object)("Removing RMDelegationToken_" + identifier.getSequenceNumber()));
        this.deleteFile(nodeCreatePath);
    }

    public synchronized void storeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, DELEGATION_KEY_PREFIX + masterKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        LOG.info((Object)("Storing RMDelegationKey_" + masterKey.getKeyId()));
        masterKey.write((DataOutput)fsOut);
        this.writeFile(nodeCreatePath, os.toByteArray());
        fsOut.close();
    }

    public synchronized void removeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, DELEGATION_KEY_PREFIX + masterKey.getKeyId());
        LOG.info((Object)("Removing RMDelegationKey_" + masterKey.getKeyId()));
        this.deleteFile(nodeCreatePath);
    }

    private Path getAppDir(Path root, String appId) {
        return this.getNodePath(root, appId);
    }

    private void deleteFile(Path deletePath) throws Exception {
        if (!this.fs.delete(deletePath, true)) {
            throw new Exception("Failed to delete " + deletePath);
        }
    }

    private byte[] readFile(Path inputPath, long len) throws Exception {
        FSDataInputStream fsIn = this.fs.open(inputPath);
        byte[] data = new byte[(int)len];
        fsIn.readFully(data);
        fsIn.close();
        return data;
    }

    private void writeFile(Path outputPath, byte[] data) throws Exception {
        FSDataOutputStream fsOut = this.fs.create(outputPath, false);
        fsOut.write(data);
        fsOut.close();
    }

    private boolean renameFile(Path src, Path dst) throws Exception {
        return this.fs.rename(src, dst);
    }

    private boolean createFile(Path newFile) throws Exception {
        return this.fs.createNewFile(newFile);
    }

    private Path getNodePath(Path root, String nodeName) {
        return new Path(root, nodeName);
    }
}

