/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import java.security.PrivilegedExceptionAction;
import junit.framework.Assert;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestAMRMRPCResponseId {
    private MockRM rm;
    ApplicationMasterService amService = null;

    @Before
    public void setUp() {
        this.rm = new MockRM();
        this.rm.start();
        this.amService = this.rm.getApplicationMasterService();
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    private AllocateResponse allocate(ApplicationAttemptId attemptId, AllocateRequest req) throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)attemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(attemptId.getApplicationId())).getRMAppAttempt(attemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        return (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testARRMResponseId() throws Exception {
        MockNM nm1 = this.rm.registerNode("h1:1234", 5000);
        RMApp app = this.rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = this.rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        AllocateResponse response = this.allocate(attempt.getAppAttemptId(), allocateRequest);
        Assert.assertEquals((int)1, (int)response.getResponseId());
        Assert.assertTrue((response.getAMCommand() == null ? 1 : 0) != 0);
        allocateRequest = AllocateRequest.newInstance((int)response.getResponseId(), (float)0.0f, null, null, null);
        response = this.allocate(attempt.getAppAttemptId(), allocateRequest);
        Assert.assertEquals((int)2, (int)response.getResponseId());
        response = this.allocate(attempt.getAppAttemptId(), allocateRequest);
        Assert.assertEquals((int)2, (int)response.getResponseId());
        allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        response = this.allocate(attempt.getAppAttemptId(), allocateRequest);
        Assert.assertTrue((response.getAMCommand() == AMCommand.AM_RESYNC ? 1 : 0) != 0);
    }
}

