/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.TestResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Test;

public class TestResourceTrackerService {
    private static final File TEMP_DIR = new File(System.getProperty("test.build.data", "/tmp"), "decommision");
    private File hostFile = new File(TEMP_DIR + File.separator + "hostFile.txt");
    private MockRM rm;

    @Test(timeout=50000L)
    public void testGetNextHeartBeatInterval() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", "4000");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat.getNextHeartBeatInterval());
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat2.getNextHeartBeatInterval());
    }

    @Test
    public void testDecommissionWithIncludeHosts() throws Exception {
        this.writeToHostsFile(new String[]{"localhost", "host1", "host2"});
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int metricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile(new String[]{"host1", ip});
        this.rm.getNodesListManager().refreshNodes(conf);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((int)0, (int)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"Node is not decommisioned.", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        this.checkDecommissionedNMCount(this.rm, ++metricCount);
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((int)metricCount, (int)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
    }

    @Test
    public void testDecommissionWithExcludeHosts() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile(new String[]{""});
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        int metricCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile(new String[]{"host2", ip});
        this.rm.getNodesListManager().refreshNodes(conf);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        this.checkDecommissionedNMCount(this.rm, ++metricCount);
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        this.checkDecommissionedNMCount(this.rm, ++metricCount);
    }

    @Test
    public void testAddNewIncludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile(new String[]{"host1"});
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been decomissioned.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((String)("Node should have been decomissioned but is in state" + nodeHeartbeat.getNodeAction()), (Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat.getNodeAction());
        this.checkDecommissionedNMCount(this.rm, ++initialMetricCount);
    }

    @Test
    public void testAddNewExcludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile(new String[]{"host2"});
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been decomissioned.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((String)("Node should have been decomissioned but is in state" + nodeHeartbeat.getNodeAction()), (Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat.getNodeAction());
        this.checkDecommissionedNMCount(this.rm, ++initialMetricCount);
    }

    @Test
    public void testNodeRegistrationFailure() throws Exception {
        this.writeToHostsFile(new String[]{"host1"});
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertEquals((String)"Disallowed NodeManager from  host2, Sending SHUTDOWN signal to the NodeManager.", (String)response.getDiagnosticsMessage());
    }

    @Test
    public void testSetRMIdentifierInRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        RegisterNodeManagerResponse response = nm.registerNode();
        Assert.assertEquals((long)ResourceManager.clusterTimeStamp, (long)response.getRMIdentifier());
    }

    @Test
    public void testNodeRegistrationWithMinimumAllocations() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.minimum-allocation-mb", "2048");
        conf.set("yarn.scheduler.minimum-allocation-vcores", "4");
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)1234);
        req.setNodeId(nodeId);
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        req.setResource(capability);
        RegisterNodeManagerResponse response1 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response1.getNodeAction());
        capability.setMemory(2048);
        capability.setVirtualCores(1);
        req.setResource(capability);
        RegisterNodeManagerResponse response2 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response2.getNodeAction());
        capability.setMemory(1024);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response3 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response3.getNodeAction());
        capability.setMemory(2048);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response4 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response4.getNodeAction());
    }

    @Test
    public void testReboot() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:1234", 2048);
        int initialMetricCount = ClusterMetrics.getMetrics().getNumRebootedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(new HashMap(), true, -100);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((String)"Too far behind rm response id:0 nm response id:-100", (String)nodeHeartbeat.getDiagnosticsMessage());
        this.checkRebootedNMCount(this.rm, ++initialMetricCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRebootedNMCount(MockRM rm2, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumRebootedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                this.wait(100L);
            }
        }
        Assert.assertEquals((String)"The rebooted metrics are not updated", (int)count, (int)ClusterMetrics.getMetrics().getNumRebootedNMs());
    }

    @Test
    public void testUnhealthyNodeStatus() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        Assert.assertEquals((int)0, (int)ClusterMetrics.getMetrics().getUnhealthyNMs());
        nm1.nodeHeartbeat(true);
        nm1.nodeHeartbeat(false);
        this.checkUnealthyNMCount(this.rm, nm1, true, 1);
        nm1.nodeHeartbeat(true);
        this.checkUnealthyNMCount(this.rm, nm1, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnealthyNMCount(MockRM rm, MockNM nm1, boolean health, int count) throws Exception {
        int waitCount = 0;
        while (((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                this.wait(100L);
            }
        }
        Assert.assertFalse((((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unhealthy metrics not incremented", (int)count, (int)ClusterMetrics.getMetrics().getUnhealthyNMs());
    }

    @Test
    public void testReconnectNode() throws Exception {
        DrainDispatcher dispatcher = new DrainDispatcher();
        1 rm = new /* Unavailable Anonymous Inner Class!! */;
        rm.start();
        MockNM nm1 = rm.registerNode("host1:1234", 5120);
        MockNM nm2 = rm.registerNode("host2:5678", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        dispatcher.await();
        this.checkUnealthyNMCount((MockRM)rm, nm2, true, 1);
        int expectedNMs = ClusterMetrics.getMetrics().getNumActiveNMs();
        QueueMetrics metrics = rm.getResourceScheduler().getRootQueueMetrics();
        Assert.assertEquals((int)5120, (int)metrics.getAvailableMB());
        nm1 = rm.registerNode("host1:1234", 5120);
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        dispatcher.await();
        Assert.assertEquals((int)expectedNMs, (int)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnealthyNMCount((MockRM)rm, nm2, true, 1);
        nm2 = rm.registerNode("host2:5678", 5120);
        response = nm2.nodeHeartbeat(false);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        dispatcher.await();
        Assert.assertEquals((int)expectedNMs, (int)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnealthyNMCount((MockRM)rm, nm2, true, 1);
        nm2 = rm.registerNode("host2:5678", 5120);
        dispatcher.await();
        response = nm2.nodeHeartbeat(true);
        response = nm2.nodeHeartbeat(true);
        dispatcher.await();
        Assert.assertEquals((int)10240, (int)metrics.getAvailableMB());
        nm1 = rm.registerNode("host2:5678", 10240);
        dispatcher.await();
        response = nm2.nodeHeartbeat(true);
        dispatcher.await();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((int)15360, (int)metrics.getAvailableMB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHostsFile(String ... hosts) throws IOException {
        if (!this.hostFile.exists()) {
            TEMP_DIR.mkdirs();
            this.hostFile.createNewFile();
        }
        FileOutputStream fStream = null;
        try {
            fStream = new FileOutputStream(this.hostFile);
            for (int i = 0; i < hosts.length; ++i) {
                fStream.write(hosts[i].getBytes());
                fStream.write("\n".getBytes());
            }
        }
        finally {
            if (fStream != null) {
                IOUtils.closeStream((Closeable)fStream);
                fStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDecommissionedNMCount(MockRM rm, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumDecommisionedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                this.wait(100L);
            }
        }
        Assert.assertEquals((int)count, (int)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The decommisioned metrics are not updated", (int)count, (int)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
    }

    @After
    public void tearDown() {
        if (this.hostFile != null && this.hostFile.exists()) {
            this.hostFile.delete();
        }
        ClusterMetrics.destroy();
        if (this.rm != null) {
            this.rm.stop();
        }
    }
}

