/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMRestart {
    private YarnConfiguration conf;
    private static InetSocketAddress rmAddr;

    @Before
    public void setup() throws UnknownHostException {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        ExitUtil.disableSystemExit();
        this.conf = new YarnConfiguration();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.set("yarn.resourcemanager.recovery.enabled", "true");
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        rmAddr = new InetSocketAddress("localhost", 8032);
    }

    @Test(timeout=180000L)
    public void testRMRestart() throws Exception {
        Assert.assertTrue((boolean)true);
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        MockRM rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:5678", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        RMApp app0 = rm1.submitApp(200);
        RMAppAttempt attempt0 = app0.getCurrentAppAttempt();
        Assert.assertEquals((long)1L, (long)rmAppState.size());
        nm1.nodeHeartbeat(true);
        MockAM am0 = rm1.sendAMLaunched(attempt0.getAppAttemptId());
        am0.registerAppAttempt();
        am0.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt0.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am0.waitForState(RMAppAttemptState.FINISHED);
        rm1.waitForState(app0.getApplicationId(), RMAppState.FINISHED);
        Assert.assertEquals((long)0L, (long)rmAppState.size());
        RMApp app1 = rm1.submitApp(200);
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(app1.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app1.getApplicationSubmissionContext().getApplicationId());
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt1.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (int)1), (Object)attemptState.getMasterContainer().getId());
        MockAM am1 = rm1.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.allocate("127.0.0.1", 1000, 1, new ArrayList());
        nm1.nodeHeartbeat(true);
        List conts = am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        while (conts.size() == 0) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        RMApp app2 = rm1.submitApp(200);
        appState = (RMStateStore.ApplicationState)rmAppState.get(app2.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app2.getApplicationSubmissionContext().getApplicationId());
        RMApp appUnmanaged = rm1.submitApp(200, "someApp", "someUser", null, true, null, this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2), null);
        ApplicationAttemptId unmanagedAttemptId = appUnmanaged.getCurrentAppAttempt().getAppAttemptId();
        ApplicationId unmanagedAppId = appUnmanaged.getApplicationId();
        appState = (RMStateStore.ApplicationState)rmAppState.get(unmanagedAppId);
        Assert.assertNotNull((Object)appState);
        rm1.waitForState(unmanagedAttemptId, RMAppAttemptState.LAUNCHED);
        rm1.waitForState(unmanagedAppId, RMAppState.ACCEPTED);
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)appUnmanaged.getApplicationSubmissionContext().getApplicationId());
        MockRM rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        nm2.setResourceTrackerService(rm2.getResourceTrackerService());
        Assert.assertEquals((long)2L, (long)rm2.getRMContext().getRMApps().size());
        RMApp loadedApp1 = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        Assert.assertNotNull((Object)loadedApp1);
        Assert.assertEquals((Object)app1.getApplicationSubmissionContext().getApplicationId(), (Object)loadedApp1.getApplicationSubmissionContext().getApplicationId());
        RMApp loadedApp2 = (RMApp)rm2.getRMContext().getRMApps().get(app2.getApplicationId());
        Assert.assertNotNull((Object)loadedApp2);
        Assert.assertEquals((Object)app2.getApplicationSubmissionContext().getApplicationId(), (Object)loadedApp2.getApplicationSubmissionContext().getApplicationId());
        rm2.waitForState(loadedApp1.getApplicationId(), RMAppState.ACCEPTED);
        rm2.waitForState(loadedApp2.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)2L, (long)loadedApp1.getAppAttempts().size());
        Assert.assertEquals((long)1L, (long)loadedApp2.getAppAttempts().size());
        am1.setAMRMProtocol((ApplicationMasterProtocol)rm2.getApplicationMasterService());
        AllocateResponse allocResponse = am1.allocate(new ArrayList(), new ArrayList());
        Assert.assertTrue((allocResponse.getAMCommand() == AMCommand.AM_RESYNC ? 1 : 0) != 0);
        NodeHeartbeatResponse hbResponse = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.RESYNC, (Object)hbResponse.getNodeAction());
        hbResponse = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.RESYNC, (Object)hbResponse.getNodeAction());
        nm1 = rm2.registerNode("127.0.0.1:1234", 15120);
        nm2 = rm2.registerNode("127.0.0.2:5678", 15120);
        hbResponse = nm1.nodeHeartbeat(true);
        Assert.assertTrue((NodeAction.RESYNC != hbResponse.getNodeAction() ? 1 : 0) != 0);
        hbResponse = nm2.nodeHeartbeat(true);
        Assert.assertTrue((NodeAction.RESYNC != hbResponse.getNodeAction() ? 1 : 0) != 0);
        attempt1 = loadedApp1.getCurrentAppAttempt();
        attemptId1 = attempt1.getAppAttemptId();
        rm2.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        appState = (RMStateStore.ApplicationState)rmAppState.get(loadedApp1.getApplicationId());
        attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (int)1), (Object)attemptState.getMasterContainer().getId());
        MockNM am1Node = nm1;
        if (attemptState.getMasterContainer().getNodeId().toString().contains("127.0.0.2")) {
            am1Node = nm2;
        }
        RMAppAttempt attempt2 = loadedApp2.getCurrentAppAttempt();
        ApplicationAttemptId attemptId2 = attempt2.getAppAttemptId();
        rm2.waitForState(attemptId2, RMAppAttemptState.ALLOCATED);
        appState = (RMStateStore.ApplicationState)rmAppState.get(loadedApp2.getApplicationId());
        attemptState = appState.getAttempt(attemptId2);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId2, (int)1), (Object)attemptState.getMasterContainer().getId());
        MockNM am2Node = nm1;
        if (attemptState.getMasterContainer().getNodeId().toString().contains("127.0.0.2")) {
            am2Node = nm2;
        }
        am1 = rm2.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        MockAM am2 = rm2.sendAMLaunched(attempt2.getAppAttemptId());
        am2.registerAppAttempt();
        am1.allocate("127.0.0.1", 1000, 3, new ArrayList());
        am2.allocate("127.0.0.2", 1000, 1, new ArrayList());
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        conts = am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        while (conts.size() == 0) {
            nm1.nodeHeartbeat(true);
            nm2.nodeHeartbeat(true);
            conts.addAll(am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        am1.unregisterAppAttempt();
        rm2.waitForState(loadedApp1.getApplicationId(), RMAppState.FINISHING);
        am1Node.nodeHeartbeat(attempt1.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am1.waitForState(RMAppAttemptState.FINISHED);
        am2.unregisterAppAttempt();
        rm2.waitForState(loadedApp2.getApplicationId(), RMAppState.FINISHING);
        am2Node.nodeHeartbeat(attempt2.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am2.waitForState(RMAppAttemptState.FINISHED);
        rm2.stop();
        rm1.stop();
        Assert.assertEquals((long)0L, (long)rmAppState.size());
    }

    @Test
    public void testRMRestartOnMaxAppAttempts() throws Exception {
        Assert.assertTrue((boolean)true);
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        MockRM rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap(), false, "default", 1, null);
        RMApp app2 = rm1.submitApp(200, "name", "user", new HashMap(), false, "default", -1, null);
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(app1.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)0L, (long)appState.getAttemptCount());
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)app1.getApplicationSubmissionContext().getApplicationId());
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (int)1), (Object)attemptState.getMasterContainer().getId());
        MockRM rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals((long)2L, (long)((RMApp)rm2.getRMContext().getRMApps().get(app2.getApplicationId())).getMaxAppAttempts());
        Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
        Assert.assertNotNull(rm2.getRMContext().getRMApps().get(app2.getApplicationId()));
        Assert.assertNull(rm2.getRMContext().getRMApps().get(app1.getApplicationId()));
        Assert.assertNotNull(rmAppState.get(app2.getApplicationId()));
        Assert.assertNull(rmAppState.get(app1.getApplicationId()));
        rm1.stop();
        rm2.stop();
    }

    @Test
    public void testDelegationTokenRestoredInDelegationTokenRenewer() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        HashSet<Token> tokenSet = new HashSet<Token>();
        Credentials ts = new Credentials();
        Text userText1 = new Text("user1");
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
        Token token1 = new Token((TokenIdentifier)dtId1, (SecretManager)rm1.getRMDTSecretManager());
        SecurityUtil.setTokenService((Token)token1, (InetSocketAddress)rmAddr);
        ts.addToken(userText1, token1);
        tokenSet.add(token1);
        Text userText2 = new Text("user2");
        RMDelegationTokenIdentifier dtId2 = new RMDelegationTokenIdentifier(userText2, new Text("renewer2"), userText2);
        Token token2 = new Token((TokenIdentifier)dtId2, (SecretManager)rm1.getRMDTSecretManager());
        SecurityUtil.setTokenService((Token)token2, (InetSocketAddress)rmAddr);
        ts.addToken(userText2, token2);
        tokenSet.add(token2);
        RMApp app = rm1.submitApp(200, "name", "user", new HashMap(), false, "default", 1, ts);
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(app.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals(tokenSet, (Object)rm1.getRMContext().getDelegationTokenRenewer().getDelegationTokens());
        DataOutputBuffer dob = new DataOutputBuffer();
        ts.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        securityTokens.rewind();
        Assert.assertEquals((Object)securityTokens, (Object)appState.getApplicationSubmissionContext().getAMContainerSpec().getTokens());
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        Assert.assertEquals(tokenSet, (Object)rm2.getRMContext().getDelegationTokenRenewer().getDelegationTokens());
        rm1.stop();
        rm2.stop();
    }

    @Test
    public void testAppAttemptTokensRestoredOnRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("0.0.0.0:4321", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap(), "default");
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(app1.getApplicationId());
        Assert.assertNotNull((Object)appState);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        ApplicationAttemptId attemptId1 = attempt1.getAppAttemptId();
        rm1.waitForState(attemptId1, RMAppAttemptState.ALLOCATED);
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId1, (int)1), (Object)attemptState.getMasterContainer().getId());
        HashSet<Token> tokenSet = new HashSet<Token>();
        tokenSet.add(attempt1.getAMRMToken());
        byte[] clientTokenMasterKey = attempt1.getClientTokenMasterKey().getEncoded();
        Credentials savedCredentials = attemptState.getAppAttemptCredentials();
        HashSet<Token> savedTokens = new HashSet<Token>();
        savedTokens.addAll(savedCredentials.getAllTokens());
        Assert.assertEquals(tokenSet, savedTokens);
        Assert.assertArrayEquals((String)"client token master key not saved", (byte[])clientTokenMasterKey, (byte[])savedCredentials.getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        RMApp loadedApp1 = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        RMAppAttempt loadedAttempt1 = loadedApp1.getRMAppAttempt(attemptId1);
        Assert.assertNotNull((Object)loadedAttempt1);
        savedTokens.clear();
        savedTokens.add(loadedAttempt1.getAMRMToken());
        Assert.assertEquals(tokenSet, savedTokens);
        Assert.assertEquals((String)"client token master key not restored", (Object)attempt1.getClientTokenMasterKey(), (Object)loadedAttempt1.getClientTokenMasterKey());
        Assert.assertArrayEquals((byte[])clientTokenMasterKey, (byte[])rm2.getClientToAMTokenSecretManager().getMasterKey(attemptId1).getEncoded());
        Token amrmToken = loadedAttempt1.getAMRMToken();
        Assert.assertArrayEquals((byte[])amrmToken.getPassword(), (byte[])rm2.getAMRMTokenSecretManager().retrievePassword((AMRMTokenIdentifier)amrmToken.decodeIdentifier()));
        rm1.stop();
        rm2.stop();
    }

    @Test
    public void testRMDelegationTokenRestoredOnRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("yarn.resourcemanager.address", "localhost:8032");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmAppState = rmState.getApplicationState();
        Map rmDTState = rmState.getRMDTSecretManagerState().getTokenState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        TestSecurityMockRM rm1 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        Credentials ts = new Credentials();
        GetDelegationTokenRequest request1 = GetDelegationTokenRequest.newInstance((String)"renewer1");
        UserGroupInformation.getCurrentUser().setAuthenticationMethod(SaslRpcServer.AuthMethod.KERBEROS);
        GetDelegationTokenResponse response1 = rm1.getClientRMService().getDelegationToken(request1);
        org.apache.hadoop.yarn.api.records.Token delegationToken1 = response1.getRMDelegationToken();
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken1, (InetSocketAddress)rmAddr);
        RMDelegationTokenIdentifier dtId1 = (RMDelegationTokenIdentifier)token1.decodeIdentifier();
        HashSet<RMDelegationTokenIdentifier> tokenIdentSet = new HashSet<RMDelegationTokenIdentifier>();
        ts.addToken(token1.getService(), token1);
        tokenIdentSet.add(dtId1);
        RMApp app = rm1.submitApp(200, "name", "user", new HashMap(), false, "default", 1, ts);
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)rmAppState.get(app.getApplicationId());
        Assert.assertNotNull((Object)appState);
        Set allKeysRM1 = rm1.getRMDTSecretManager().getAllMasterKeys();
        Assert.assertEquals((Object)allKeysRM1, (Object)rmDTMasterKeyState);
        Map allTokensRM1 = rm1.getRMDTSecretManager().getAllTokens();
        Assert.assertEquals(tokenIdentSet, allTokensRM1.keySet());
        Assert.assertEquals((Object)allTokensRM1, (Object)rmDTState);
        Assert.assertEquals((long)rm1.getRMDTSecretManager().getLatestDTSequenceNumber(), (long)rmState.getRMDTSecretManagerState().getDTSequenceNumber());
        GetDelegationTokenRequest request2 = GetDelegationTokenRequest.newInstance((String)"renewer2");
        GetDelegationTokenResponse response2 = rm1.getClientRMService().getDelegationToken(request2);
        org.apache.hadoop.yarn.api.records.Token delegationToken2 = response2.getRMDelegationToken();
        Token token2 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken2, (InetSocketAddress)rmAddr);
        RMDelegationTokenIdentifier dtId2 = (RMDelegationTokenIdentifier)token2.decodeIdentifier();
        try {
            rm1.getRMDTSecretManager().cancelToken(token2, UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)rm1.getRMDTSecretManager().getLatestDTSequenceNumber(), (long)dtId2.getSequenceNumber());
        Assert.assertFalse((boolean)rmDTState.containsKey(dtId2));
        TestSecurityMockRM rm2 = new TestSecurityMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm2.start();
        Map allTokensRM2 = rm2.getRMDTSecretManager().getAllTokens();
        Assert.assertEquals(allTokensRM2.keySet(), allTokensRM1.keySet());
        Assert.assertTrue((boolean)rm2.getRMDTSecretManager().getAllMasterKeys().containsAll(allKeysRM1));
        Assert.assertEquals((long)rm1.getRMDTSecretManager().getLatestDTSequenceNumber(), (long)rm2.getRMDTSecretManager().getLatestDTSequenceNumber());
        Long renewDateBeforeRenew = (Long)allTokensRM2.get(dtId1);
        try {
            Thread.sleep(1L);
            rm2.getRMDTSecretManager().renewToken(token1, "renewer1");
        }
        catch (Exception e) {
            Assert.fail();
        }
        allTokensRM2 = rm2.getRMDTSecretManager().getAllTokens();
        Long renewDateAfterRenew = (Long)allTokensRM2.get(dtId1);
        Assert.assertTrue((renewDateAfterRenew > renewDateBeforeRenew ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rmDTState.containsValue(renewDateAfterRenew));
        Assert.assertFalse((boolean)rmDTState.containsValue(renewDateBeforeRenew));
        try {
            rm2.getRMDTSecretManager().cancelToken(token1, UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (Exception e) {
            Assert.fail();
        }
        allTokensRM2 = rm2.getRMDTSecretManager().getAllTokens();
        Assert.assertFalse((boolean)allTokensRM2.containsKey(dtId1));
        Assert.assertFalse((boolean)rmDTState.containsKey(dtId1));
        rm1.stop();
        rm2.stop();
    }
}

