/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.TestClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestClientRMService {
    private static final Log LOG = LogFactory.getLog(TestClientRMService.class);
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private String appType = "MockApp";
    private static RMDelegationTokenSecretManager dtsm;
    private static final UserGroupInformation owner;
    private static final UserGroupInformation other;

    @BeforeClass
    public static void setupSecretManager() throws IOException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)new NullRMStateStore());
        dtsm = new RMDelegationTokenSecretManager(60000L, 60000L, 60000L, 60000L, rmContext);
        dtsm.startThreads();
    }

    @AfterClass
    public static void teardownSecretManager() {
        if (dtsm != null) {
            dtsm.stopThreads();
        }
    }

    @Test
    public void testGetClusterNodes() throws Exception {
        1 rm = new /* Unavailable Anonymous Inner Class!! */;
        rm.start();
        MockNM node = rm.registerNode("host1:1234", 1024);
        rm.sendNodeStarted(node);
        node.nodeHeartbeat(true);
        MockNM lostNode = rm.registerNode("host2:1235", 1024);
        rm.sendNodeStarted(lostNode);
        lostNode.nodeHeartbeat(true);
        rm.NMwaitForState(lostNode.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(lostNode);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((int)1, (int)nodeReports.size());
        Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        node.nodeHeartbeat(false);
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((String)"Unhealthy nodes should not show up by default", (int)0, (int)nodeReports.size());
        request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.UNHEALTHY));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((int)1, (int)nodeReports.size());
        Assert.assertEquals((String)"Node is expected to be unhealthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        rm.registerNode("host3:1236", 1024);
        request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((int)3, (int)nodeReports.size());
    }

    @Test
    public void testGetApplicationReport() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(ApplicationId.newInstance((long)0L, (int)0));
        try {
            rmService.getApplicationReport(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((String)ex.getMessage(), (String)("Application with id '" + request.getApplicationId() + "' doesn't exist in RM."));
        }
    }

    @Test
    public void testForceKillApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        try {
            rmService.forceKillApplication(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((String)ex.getMessage(), (String)("Trying to kill an absent application " + request.getApplicationId()));
        }
    }

    @Test
    public void testGetQueueInfo() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, null, null, null);
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo = rmService.getQueueInfo(request);
        List applications = queueInfo.getQueueInfo().getApplications();
        Assert.assertEquals((int)2, (int)applications.size());
        request.setQueueName("nonexistentqueue");
        request.setIncludeApplications(true);
        queueInfo = rmService.getQueueInfo(request);
    }

    @Test
    public void testTokenRenewalByOwner() throws Exception {
        owner.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testTokenRenewalWrongUser() throws Exception {
        try {
            owner.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"renew should have failed");
    }

    @Test
    public void testTokenRenewalByLoginUser() throws Exception {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkTokenRenewal(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        rmService.renewDelegationToken(request);
    }

    @Test(timeout=30000L)
    public void testAppSubmit() throws Exception {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        ApplicationId appId1 = this.getApplicationId(100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        Assert.assertEquals((String)"app name doesn't match", (String)"N/A", (String)app1.getName());
        Assert.assertEquals((String)"app queue doesn't match", (String)"default", (String)app1.getQueue());
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId2 = this.getApplicationId(101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, name, queue);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        Assert.assertEquals((String)"app name doesn't match", (String)name, (String)app2.getName());
        Assert.assertEquals((String)"app queue doesn't match", (String)queue, (String)app2.getQueue());
        try {
            rmService.submitApplication(submitRequest2);
            Assert.fail((String)"Exception is expected.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not expected.", (boolean)e.getMessage().contains("Cannot add a duplicate!"));
        }
        GetApplicationsRequest getAllAppsRequest = GetApplicationsRequest.newInstance(new HashSet());
        GetApplicationsResponse getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((int)5, (int)getAllApplicationsResponse.getApplicationList().size());
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("matchType");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((int)1, (int)getAllApplicationsResponse.getApplicationList().size());
        Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
    }

    @Test(timeout=4000L)
    public void testConcurrentAppSubmit() throws IOException, InterruptedException, BrokenBarrierException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        ApplicationId appId1 = this.getApplicationId(100);
        ApplicationId appId2 = this.getApplicationId(101);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        CyclicBarrier startBarrier = new CyclicBarrier(2);
        CyclicBarrier endBarrier = new CyclicBarrier(2);
        6 eventHandler = new /* Unavailable Anonymous Inner Class!! */;
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)eventHandler);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, null, null, null);
        7 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        startBarrier.await();
        rmService.submitApplication(submitRequest2);
        endBarrier.await();
        t.join();
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue) {
        ContainerLaunchContext amContainerSpec = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setAMContainerSpec(amContainerSpec);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        return submitRequest;
    }

    private void mockRMContext(YarnScheduler yarnScheduler, RMContext rmContext) throws IOException {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn((Object)eventHandler);
        QueueInfo queInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queInfo.setQueueName("testqueue");
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"testqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queInfo);
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"nonexistentqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("queue does not exist")});
        ConcurrentHashMap apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn((Object)apps);
    }

    private ConcurrentHashMap<ApplicationId, RMApp> getRMApps(RMContext rmContext, YarnScheduler yarnScheduler) {
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        ApplicationId applicationId1 = this.getApplicationId(1);
        ApplicationId applicationId2 = this.getApplicationId(2);
        ApplicationId applicationId3 = this.getApplicationId(3);
        YarnConfiguration config = new YarnConfiguration();
        apps.put(applicationId1, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId1, config, "testqueue"));
        apps.put(applicationId2, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId2, config, "a"));
        apps.put(applicationId3, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId3, config, "testqueue"));
        return apps;
    }

    private ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)123456L, (int)id);
    }

    private RMAppImpl getRMApp(RMContext rmContext, YarnScheduler yarnScheduler, ApplicationId applicationId3, YarnConfiguration config, String queueName) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asContext.getMaxAppAttempts()).thenReturn((Object)1);
        RMAppImpl app = (RMAppImpl)Mockito.spy((Object)new RMAppImpl(applicationId3, rmContext, (Configuration)config, null, null, queueName, asContext, yarnScheduler, null, System.currentTimeMillis(), "YARN"));
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId3, (int)1);
        RMAppAttemptImpl rmAppAttemptImpl = new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, null);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)rmAppAttemptImpl);
        return app;
    }

    private static YarnScheduler mockYarnScheduler() {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        Mockito.when((Object)yarnScheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)yarnScheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        return yarnScheduler;
    }

    static /* synthetic */ UserGroupInformation access$000() {
        return owner;
    }

    static /* synthetic */ void access$100(TestClientRMService x0, UserGroupInformation x1, UserGroupInformation x2) throws IOException, YarnException {
        x0.checkTokenRenewal(x1, x2);
    }

    static /* synthetic */ UserGroupInformation access$200() {
        return other;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static {
        owner = UserGroupInformation.createRemoteUser((String)"owner");
        other = UserGroupInformation.createRemoteUser((String)"other");
    }
}

