/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.TestAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAppManager {
    private static RMAppEventType appEventType = RMAppEventType.KILL;
    private RMContext rmContext;
    private TestRMAppManager appMonitor;
    private ApplicationSubmissionContext asContext;
    private ApplicationId appId;

    public synchronized RMAppEventType getAppEventType() {
        return appEventType;
    }

    public synchronized void setAppEventType(RMAppEventType newType) {
        appEventType = newType;
    }

    public static List<RMApp> newRMApps(int n, long time, RMAppState state) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(new MockRMApp(i, time, state));
        }
        return list;
    }

    public static RMContext mockRMContext(int n, long time) {
        List apps = TestAppManager.newRMApps((int)n, (long)time, (RMAppState)RMAppState.FINISHED);
        ConcurrentMap map = Maps.newConcurrentMap();
        for (RMApp app : apps) {
            map.put(app.getApplicationId(), app);
        }
        AsyncDispatcher rmDispatcher = new AsyncDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = new ContainerAllocationExpirer((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amLivelinessMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amFinishingMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void addToCompletedApps(TestRMAppManager appMonitor, RMContext rmContext) {
        for (RMApp app : rmContext.getRMApps().values()) {
            if (app.getState() != RMAppState.FINISHED && app.getState() != RMAppState.KILLED && app.getState() != RMAppState.FAILED) continue;
            appMonitor.finishApplication(app.getApplicationId());
        }
    }

    @Before
    public void setUp() {
        long now = System.currentTimeMillis();
        this.rmContext = TestAppManager.mockRMContext((int)1, (long)(now - 10L));
        ResourceScheduler scheduler = TestAppManager.mockResourceScheduler();
        Configuration conf = new Configuration();
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)scheduler);
        this.appMonitor = new TestRMAppManager(this, this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)scheduler, masterService, new ApplicationACLsManager(conf), conf);
        this.appId = MockApps.newAppID((int)1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        this.asContext = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        this.asContext.setApplicationId(this.appId);
        this.asContext.setAMContainerSpec(TestAppManager.mockContainerLaunchContext((RecordFactory)recordFactory));
        this.asContext.setResource(TestAppManager.mockResource());
        this.setupDispatcher(this.rmContext, conf);
    }

    @After
    public void tearDown() {
        this.setAppEventType(RMAppEventType.KILL);
        ((Service)this.rmContext.getDispatcher()).stop();
    }

    @Test
    public void testRMAppRetireNone() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = TestAppManager.mockRMContext((int)10, (long)(now - 10L));
        TestRMAppManager appMonitor = new TestRMAppManager(this, rmContext, new Configuration());
        appMonitor.setCompletedAppsMax(10);
        Assert.assertEquals((String)"Number of apps incorrect before checkAppTimeLimit", (int)10, (int)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (int)10, (int)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (int)10, (int)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireSome() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = TestAppManager.mockRMContext((int)10, (long)(now - 20000L));
        TestRMAppManager appMonitor = new TestRMAppManager(this, rmContext, new Configuration());
        appMonitor.setCompletedAppsMax(3);
        Assert.assertEquals((String)"Number of apps incorrect before", (int)10, (int)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (int)3, (int)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (int)3, (int)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireSomeDifferentStates() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = TestAppManager.mockRMContext((int)10, (long)(now - 20000L));
        TestRMAppManager appMonitor = new TestRMAppManager(this, rmContext, new Configuration());
        appMonitor.setCompletedAppsMax(2);
        rmContext.getRMApps().clear();
        Assert.assertEquals((String)"map isn't empty", (int)0, (int)rmContext.getRMApps().size());
        MockRMApp app = new MockRMApp(0, now - 20000L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(1, now - 200000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(2, now - 30000L, RMAppState.FINISHED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(3, now - 20000L, RMAppState.RUNNING);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(4, now - 20000L, RMAppState.NEW);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(5, now - 10001L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(6, now - 30000L, RMAppState.ACCEPTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(7, now - 20000L, RMAppState.SUBMITTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(8, now - 10001L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(9, now - 20000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        Assert.assertEquals((String)"Number of apps incorrect before", (int)10, (int)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (int)6, (int)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (int)2, (int)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireNullApp() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = TestAppManager.mockRMContext((int)10, (long)(now - 20000L));
        TestRMAppManager appMonitor = new TestRMAppManager(this, rmContext, new Configuration());
        Assert.assertEquals((String)"Number of apps incorrect before", (int)10, (int)rmContext.getRMApps().size());
        appMonitor.finishApplication(null);
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (int)0, (int)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireZeroSetting() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = TestAppManager.mockRMContext((int)10, (long)(now - 20000L));
        TestRMAppManager appMonitor = new TestRMAppManager(this, rmContext, new Configuration());
        Assert.assertEquals((String)"Number of apps incorrect before", (int)10, (int)rmContext.getRMApps().size());
        appMonitor.setCompletedAppsMax(0);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (int)10, (int)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (int)0, (int)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (int)0, (int)appMonitor.getCompletedAppsListSize());
    }

    protected void setupDispatcher(RMContext rmContext, Configuration conf) {
        TestDispatcher testDispatcher = new TestDispatcher(this);
        TestAppManagerDispatcher testAppManagerDispatcher = new TestAppManagerDispatcher(this);
        rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)testDispatcher);
        rmContext.getDispatcher().register(RMAppManagerEventType.class, (EventHandler)testAppManagerDispatcher);
        ((Service)rmContext.getDispatcher()).init(conf);
        ((Service)rmContext.getDispatcher()).start();
        Assert.assertEquals((String)"app event type is wrong before", (Object)RMAppEventType.KILL, (Object)appEventType);
    }

    @Test
    public void testRMAppSubmit() throws Exception {
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)this.appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.NEW, (Object)app.getState());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitMaxAppAttempts() throws Exception {
        int[] globalMaxAppAttempts = new int[]{10, 1};
        int[][] individualMaxAppAttempts = new int[][]{{9, 10, 11, 0}, {1, 10, 0, -1}};
        int[][] expectedNums = new int[][]{{9, 10, 10, 10}, {1, 1, 1, 1}};
        for (int i = 0; i < globalMaxAppAttempts.length; ++i) {
            for (int j = 0; j < individualMaxAppAttempts.length; ++j) {
                ResourceScheduler scheduler = TestAppManager.mockResourceScheduler();
                Configuration conf = new Configuration();
                conf.setInt("yarn.resourcemanager.am.max-attempts", globalMaxAppAttempts[i]);
                ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)scheduler);
                TestRMAppManager appMonitor = new TestRMAppManager(this, this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)scheduler, masterService, new ApplicationACLsManager(conf), conf);
                ApplicationId appID = MockApps.newAppID((int)(i * 4 + j + 1));
                this.asContext.setApplicationId(appID);
                if (individualMaxAppAttempts[i][j] != 0) {
                    this.asContext.setMaxAppAttempts(individualMaxAppAttempts[i][j]);
                }
                appMonitor.submitApplication(this.asContext, "test");
                RMApp app = (RMApp)this.rmContext.getRMApps().get(appID);
                Assert.assertEquals((String)"max application attempts doesn't match", (int)expectedNums[i][j], (int)app.getMaxAppAttempts());
                int timeoutSecs = 0;
                while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
                    Thread.sleep(1000L);
                }
                this.setAppEventType(RMAppEventType.KILL);
            }
        }
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitDuplicateApplicationId() throws Exception {
        ApplicationId appId = MockApps.newAppID((int)0);
        this.asContext.setApplicationId(appId);
        RMApp appOrig = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertTrue((String)"app name matches but shouldn't", ("testApp1" != appOrig.getName() ? 1 : 0) != 0);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Exception is expected when applicationId is duplicate.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not the expectd one.", (boolean)e.getMessage().contains("Cannot add a duplicate!"));
        }
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.FINISHED, (Object)app.getState());
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitInvalidResourceRequest() throws Exception {
        this.asContext.setResource(Resources.createResource((int)8193));
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because resource request is invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not InvalidResourceRequestException", (boolean)e.getMessage().contains("Invalid resource request"));
        }
    }

    private static ResourceScheduler mockResourceScheduler() {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)scheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        return scheduler;
    }

    private static ContainerLaunchContext mockContainerLaunchContext(RecordFactory recordFactory) {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        amContainer.setApplicationACLs(new HashMap());
        return amContainer;
    }

    private static Resource mockResource() {
        return Resources.createResource((int)1024);
    }
}

