/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=Parameterized.class)
public class TestAMAuthorization {
    private static final Log LOG = LogFactory.getLog(TestAMAuthorization.class);
    private final Configuration conf;
    private MockRM rm;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        Configuration conf = new Configuration();
        Configuration confWithSecurity = new Configuration();
        confWithSecurity.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
        return Arrays.asList({conf}, {confWithSecurity});
    }

    public TestAMAuthorization(Configuration conf) {
        this.conf = conf;
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testAuthorizedAccess() throws Exception {
        MyContainerManager containerManager = new MyContainerManager();
        this.rm = new MockRMWithAMS(this.conf, (ContainerManagementProtocol)containerManager);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        RMApp app = this.rm.submitApp(1024, "appname", "appuser", acls);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (containerManager.containerTokens == null && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertNotNull((Object)containerManager.containerTokens);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        this.waitForLaunchedState(attempt);
        Configuration conf = this.rm.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        InetSocketAddress rmBindAddress = this.rm.getApplicationMasterService().getBindAddress();
        Token amRMToken = MockRMWithAMS.setupAndReturnAMRMToken((InetSocketAddress)rmBindAddress, (Collection)credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        RegisterApplicationMasterResponse response = client.registerApplicationMaster(request);
        Assert.assertNotNull((Object)response.getClientToAMTokenMasterKey());
        if (UserGroupInformation.isSecurityEnabled()) {
            Assert.assertTrue((response.getClientToAMTokenMasterKey().array().length > 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"Register response has bad ACLs", (Object)"*", response.getApplicationACLs().get(ApplicationAccessType.VIEW_APP));
    }

    @Test
    public void testUnauthorizedAccess() throws Exception {
        MyContainerManager containerManager = new MyContainerManager();
        this.rm = new MockRMWithAMS(this.conf, (ContainerManagementProtocol)containerManager);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("localhost:1234", 5120);
        RMApp app = this.rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (containerManager.containerTokens == null && waitCount++ < 40) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertNotNull((Object)containerManager.containerTokens);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        this.waitForLaunchedState(attempt);
        Configuration conf = this.rm.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress serviceAddr = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        try {
            client.registerApplicationMaster(request);
            Assert.fail((String)"Should fail with authorization error");
        }
        catch (Exception e) {
            String expectedMessage = "";
            expectedMessage = UserGroupInformation.isSecurityEnabled() ? "Client cannot authenticate via:[TOKEN]" : "SIMPLE authentication is not enabled.  Available:[TOKEN]";
            Assert.assertTrue((boolean)e.getCause().getMessage().contains(expectedMessage));
        }
    }

    private void waitForLaunchedState(RMAppAttempt attempt) throws InterruptedException {
        int waitCount = 0;
        while (attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && waitCount++ < 40) {
            LOG.info((Object)("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState()));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
    }

    static /* synthetic */ MockRM access$000(TestAMAuthorization x0) {
        return x0.rm;
    }
}

