/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;

public class RMServerUtils {
    public static List<RMNode> queryRMNodes(RMContext context, EnumSet<NodeState> acceptedStates) {
        ArrayList<RMNode> results = new ArrayList<RMNode>();
        if (acceptedStates.contains(NodeState.NEW) || acceptedStates.contains(NodeState.RUNNING) || acceptedStates.contains(NodeState.UNHEALTHY)) {
            for (RMNode rmNode : context.getRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        if (acceptedStates.contains(NodeState.DECOMMISSIONED) || acceptedStates.contains(NodeState.LOST) || acceptedStates.contains(NodeState.REBOOTED)) {
            for (RMNode rmNode : context.getInactiveRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        return results;
    }

    public static void validateResourceRequests(List<ResourceRequest> ask, Resource maximumResource) throws InvalidResourceRequestException {
        for (ResourceRequest resReq : ask) {
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maximumResource);
        }
    }

    public static void validateBlacklistRequest(ResourceBlacklistRequest blacklistRequest) throws InvalidResourceBlacklistRequestException {
        List plus;
        if (blacklistRequest != null && (plus = blacklistRequest.getBlacklistAdditions()) != null && plus.contains("*")) {
            throw new InvalidResourceBlacklistRequestException("Cannot add * to the blacklist!");
        }
    }

    public static void validateContainerReleaseRequest(List<ContainerId> containerReleaseList, ApplicationAttemptId appAttemptId) throws InvalidContainerReleaseException {
        for (ContainerId cId : containerReleaseList) {
            if (appAttemptId.equals((Object)cId.getApplicationAttemptId())) continue;
            throw new InvalidContainerReleaseException("Cannot release container : " + cId.toString() + " not belonging to this application attempt : " + appAttemptId);
        }
    }
}

