/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfoBeans;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.mortbay.util.ajax.JSON;

public class RMNMInfo
implements RMNMInfoBeans {
    private static final Log LOG = LogFactory.getLog(RMNMInfo.class);
    private RMContext rmContext;
    private ResourceScheduler scheduler;

    public RMNMInfo(RMContext rmc, ResourceScheduler sched) {
        this.rmContext = rmc;
        this.scheduler = sched;
        try {
            StandardMBean bean = new StandardMBean(this, RMNMInfoBeans.class);
            MBeans.register((String)"ResourceManager", (String)"RMNMInfo", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn((Object)"Error registering RMNMInfo MBean", (Throwable)e);
        }
        LOG.info((Object)"Registered RMNMInfo MBean");
    }

    public String getLiveNodeManagers() {
        Collection nodes = this.rmContext.getRMNodes().values();
        ArrayList<InfoMap> nodesInfo = new ArrayList<InfoMap>();
        for (RMNode ni : nodes) {
            SchedulerNodeReport report = this.scheduler.getNodeReport(ni.getNodeID());
            InfoMap info = new InfoMap();
            info.put((Object)"HostName", (Object)ni.getHostName());
            info.put((Object)"Rack", (Object)ni.getRackName());
            info.put((Object)"State", (Object)ni.getState().toString());
            info.put((Object)"NodeId", (Object)ni.getNodeID());
            info.put((Object)"NodeHTTPAddress", (Object)ni.getHttpAddress());
            info.put((Object)"LastHealthUpdate", (Object)ni.getLastHealthReportTime());
            info.put((Object)"HealthReport", (Object)ni.getHealthReport());
            if (report != null) {
                info.put((Object)"NumContainers", (Object)report.getNumContainers());
                info.put((Object)"UsedMemoryMB", (Object)report.getUsedResource().getMemory());
                info.put((Object)"AvailableMemoryMB", (Object)report.getAvailableResource().getMemory());
            }
            nodesInfo.add(info);
        }
        return JSON.toString(nodesInfo);
    }
}

