/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

public class MockNM {
    private int responseId;
    private NodeId nodeId;
    private final int memory;
    private final int vCores;
    private ResourceTrackerService resourceTracker;
    private final int httpPort = 2;
    private MasterKey currentContainerTokenMasterKey;
    private MasterKey currentNMTokenMasterKey;

    public MockNM(String nodeIdStr, int memory, ResourceTrackerService resourceTracker) {
        this(nodeIdStr, memory, Math.max(1, memory * 8 / 8192), resourceTracker);
    }

    public MockNM(String nodeIdStr, int memory, int vcores, ResourceTrackerService resourceTracker) {
        this.memory = memory;
        this.vCores = vcores;
        this.resourceTracker = resourceTracker;
        String[] splits = nodeIdStr.split(":");
        this.nodeId = BuilderUtils.newNodeId((String)splits[0], (int)Integer.parseInt(splits[1]));
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getHttpPort() {
        return 2;
    }

    void setResourceTrackerService(ResourceTrackerService resourceTracker) {
        this.resourceTracker = resourceTracker;
    }

    public void containerStatus(ContainerStatus containerStatus) throws Exception {
        HashMap<ApplicationId, List<ContainerStatus>> conts = new HashMap<ApplicationId, List<ContainerStatus>>();
        conts.put(containerStatus.getContainerId().getApplicationAttemptId().getApplicationId(), Arrays.asList(containerStatus));
        this.nodeHeartbeat(conts, true);
    }

    public RegisterNodeManagerResponse registerNode() throws Exception {
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        req.setNodeId(this.nodeId);
        req.setHttpPort(2);
        Resource resource = BuilderUtils.newResource((int)this.memory, (int)this.vCores);
        req.setResource(resource);
        RegisterNodeManagerResponse registrationResponse = this.resourceTracker.registerNodeManager(req);
        this.currentContainerTokenMasterKey = registrationResponse.getContainerTokenMasterKey();
        this.currentNMTokenMasterKey = registrationResponse.getNMTokenMasterKey();
        return registrationResponse;
    }

    public NodeHeartbeatResponse nodeHeartbeat(boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(new HashMap(), isHealthy, ++this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(ApplicationAttemptId attemptId, int containerId, ContainerState containerState) throws Exception {
        HashMap nodeUpdate = new HashMap(1);
        ContainerStatus amContainerStatus = BuilderUtils.newContainerStatus((ContainerId)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId, (int)1), (ContainerState)ContainerState.COMPLETE, (String)"Success", (int)0);
        ArrayList<ContainerStatus> containerStatusList = new ArrayList<ContainerStatus>(1);
        containerStatusList.add(amContainerStatus);
        nodeUpdate.put(attemptId.getApplicationId(), containerStatusList);
        return this.nodeHeartbeat(nodeUpdate, true);
    }

    public NodeHeartbeatResponse nodeHeartbeat(Map<ApplicationId, List<ContainerStatus>> conts, boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(conts, isHealthy, ++this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(Map<ApplicationId, List<ContainerStatus>> conts, boolean isHealthy, int resId) throws Exception {
        NodeHeartbeatRequest req = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeStatus status = (NodeStatus)Records.newRecord(NodeStatus.class);
        status.setResponseId(resId);
        status.setNodeId(this.nodeId);
        for (Map.Entry<ApplicationId, List<ContainerStatus>> entry : conts.entrySet()) {
            status.setContainersStatuses(entry.getValue());
        }
        NodeHealthStatus healthStatus = (NodeHealthStatus)Records.newRecord(NodeHealthStatus.class);
        healthStatus.setHealthReport("");
        healthStatus.setIsNodeHealthy(isHealthy);
        healthStatus.setLastHealthReportTime(1L);
        status.setNodeHealthStatus(healthStatus);
        req.setNodeStatus(status);
        req.setLastKnownContainerTokenMasterKey(this.currentContainerTokenMasterKey);
        req.setLastKnownNMTokenMasterKey(this.currentNMTokenMasterKey);
        NodeHeartbeatResponse heartbeatResponse = this.resourceTracker.nodeHeartbeat(req);
        MasterKey masterKeyFromRM = heartbeatResponse.getContainerTokenMasterKey();
        if (masterKeyFromRM != null && masterKeyFromRM.getKeyId() != this.currentContainerTokenMasterKey.getKeyId()) {
            this.currentContainerTokenMasterKey = masterKeyFromRM;
        }
        if ((masterKeyFromRM = heartbeatResponse.getNMTokenMasterKey()) != null && masterKeyFromRM.getKeyId() != this.currentNMTokenMasterKey.getKeyId()) {
            this.currentNMTokenMasterKey = masterKeyFromRM;
        }
        return heartbeatResponse;
    }
}

