/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSLeafQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSLeafQueue.class.getName());
    private final List<AppSchedulable> appScheds = new ArrayList<AppSchedulable>();
    private final FairScheduler scheduler;
    private final QueueManager queueMgr;
    private Resource demand = Resources.createResource((int)0);
    private long lastTimeAtMinShare;
    private long lastTimeAtHalfFairShare;

    public FSLeafQueue(String name, QueueManager queueMgr, FairScheduler scheduler, FSParentQueue parent) {
        super(name, queueMgr, scheduler, parent);
        this.scheduler = scheduler;
        this.queueMgr = queueMgr;
        this.lastTimeAtMinShare = scheduler.getClock().getTime();
        this.lastTimeAtHalfFairShare = scheduler.getClock().getTime();
    }

    public void addApp(FSSchedulerApp app) {
        AppSchedulable appSchedulable = new AppSchedulable(this.scheduler, app, this);
        app.setAppSchedulable(appSchedulable);
        this.appScheds.add(appSchedulable);
    }

    void addAppSchedulable(AppSchedulable appSched) {
        this.appScheds.add(appSched);
    }

    public void removeApp(FSSchedulerApp app) {
        Iterator<AppSchedulable> it = this.appScheds.iterator();
        while (it.hasNext()) {
            AppSchedulable appSched = it.next();
            if (appSched.getApp() != app) continue;
            it.remove();
            break;
        }
    }

    public Collection<AppSchedulable> getAppSchedulables() {
        return this.appScheds;
    }

    @Override
    public void setPolicy(SchedulingPolicy policy) throws AllocationConfigurationException {
        if (!SchedulingPolicy.isApplicableTo(policy, (byte)1)) {
            this.throwPolicyDoesnotApplyException(policy);
        }
        this.policy = policy;
    }

    @Override
    public void recomputeShares() {
        this.policy.computeShares(this.getAppSchedulables(), this.getFairShare());
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource((int)0);
        for (AppSchedulable app : this.appScheds) {
            Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
        }
        return usage;
    }

    @Override
    public void updateDemand() {
        Resource maxRes = this.queueMgr.getMaxResources(this.getName());
        this.demand = Resources.createResource((int)0);
        for (AppSchedulable sched : this.appScheds) {
            sched.updateDemand();
            Resource toAdd = sched.getDemand();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Counting resource from " + sched.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
            }
            this.demand = Resources.add((Resource)this.demand, (Resource)toAdd);
            this.demand = Resources.componentwiseMin((Resource)this.demand, (Resource)maxRes);
            if (!Resources.equals((Resource)this.demand, (Resource)maxRes)) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        Resource assigned = Resources.none();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node " + node.getNodeName() + " offered to queue: " + this.getName()));
        }
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        Comparator<Schedulable> comparator = this.policy.getComparator();
        Collections.sort(this.appScheds, comparator);
        for (AppSchedulable sched : this.appScheds) {
            if (sched.getRunnable() && !SchedulerAppUtils.isBlacklisted(sched.getApp(), node, LOG) && !(assigned = sched.assignContainer(node)).equals((Object)Resources.none())) break;
        }
        return assigned;
    }

    @Override
    public Collection<FSQueue> getChildQueues() {
        return new ArrayList<FSQueue>(1);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public long getLastTimeAtMinShare() {
        return this.lastTimeAtMinShare;
    }

    public void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    public long getLastTimeAtHalfFairShare() {
        return this.lastTimeAtHalfFairShare;
    }

    public void setLastTimeAtHalfFairShare(long lastTimeAtHalfFairShare) {
        this.lastTimeAtHalfFairShare = lastTimeAtHalfFairShare;
    }
}

