/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestFifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.junit.Test;

public class TestContainerAllocation {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;

    @Test(timeout=3000000L)
    public void testExcessReservationThanNodeManagerCapacity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 2048, 4);
        MockNM nm2 = rm.registerNode("127.0.0.1:2234", 3072, 4);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        int waitCount = 20;
        int size = rm.getRMContext().getRMNodes().size();
        while ((size = rm.getRMContext().getRMNodes().size()) != 2 && waitCount-- > 0) {
            LOG.info((Object)("Waiting for node managers to register : " + size));
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)2, (int)rm.getRMContext().getRMNodes().size());
        RMApp app1 = rm.submitApp(128);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        LOG.info((Object)"sending container requests ");
        am1.addRequests(new String[]{"*"}, 3072, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        int waitCounter = 20;
        LOG.info((Object)"heartbeating nm1");
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
        LOG.info((Object)"heartbeating nm2");
        waitCounter = 20;
        nm2.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 1 ? 1 : 0) != 0);
        rm.stop();
    }
}

