/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestApplicationLimits {
    private static final Log LOG = LogFactory.getLog(TestApplicationLimits.class);
    static final int GB = 1024;
    LeafQueue queue;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private static final String A = "a";
    private static final String B = "b";

    @Before
    public void setUp() throws IOException {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration();
        this.setupQueueConfiguration(csConf);
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)csContext.getClusterResources()).thenReturn((Object)Resources.createResource((int)163840, (int)320));
        Mockito.when((Object)csContext.getApplicationComparator()).thenReturn((Object)CapacityScheduler.applicationComparator);
        Mockito.when((Object)csContext.getQueueComparator()).thenReturn((Object)CapacityScheduler.queueComparator);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        this.queue = (LeafQueue)Mockito.spy((Object)new LeafQueue(csContext, A, root, null));
        ((LeafQueue)Mockito.doReturn((Object)true).when((Object)this.queue)).hasAccess((QueueACL)Matchers.any(QueueACL.class), (UserGroupInformation)Matchers.any(UserGroupInformation.class));
        ((LeafQueue)Mockito.doReturn((Object)100).when((Object)this.queue)).getMaxApplications();
        ((LeafQueue)Mockito.doReturn((Object)25).when((Object)this.queue)).getMaxApplicationsPerUser();
        ((LeafQueue)Mockito.doReturn((Object)10).when((Object)this.queue)).getMaximumActiveApplications();
        ((LeafQueue)Mockito.doReturn((Object)2).when((Object)this.queue)).getMaximumActiveApplicationsPerUser();
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{A, B});
        String Q_A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        String Q_B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        LOG.info((Object)"Setup top-level queues a and b");
    }

    private FiCaSchedulerApp getMockApplication(int appId, String user) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ApplicationAttemptId applicationAttemptId = TestUtils.getMockApplicationAttemptId(appId, 0);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId.getApplicationId()).when((Object)application)).getApplicationId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId).when((Object)application)).getApplicationAttemptId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        return application;
    }

    @Test
    public void testLimitsComputation() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)16));
        Mockito.when((Object)csContext.getApplicationComparator()).thenReturn((Object)CapacityScheduler.applicationComparator);
        Mockito.when((Object)csContext.getQueueComparator()).thenReturn((Object)CapacityScheduler.queueComparator);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Resource clusterResource = Resources.createResource((int)0x190000, (int)1600);
        Mockito.when((Object)csContext.getClusterResources()).thenReturn((Object)clusterResource);
        HashMap queues = new HashMap();
        CSQueue root = CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        LeafQueue queue = (LeafQueue)queues.get(A);
        LOG.info((Object)("Queue 'A' - maxActiveApplications=" + queue.getMaximumActiveApplications() + " maxActiveApplicationsPerUser=" + queue.getMaximumActiveApplicationsPerUser()));
        int expectedMaxActiveApps = Math.max(1, (int)Math.ceil((float)clusterResource.getMemory() / 1024.0f * csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath()) * queue.getAbsoluteMaximumCapacity()));
        Assert.assertEquals((long)expectedMaxActiveApps, (long)queue.getMaximumActiveApplications());
        int expectedMaxActiveAppsUsingAbsCap = Math.max(1, (int)Math.ceil((float)clusterResource.getMemory() / 1024.0f * csConf.getMaximumApplicationMasterResourcePercent() * queue.getAbsoluteCapacity()));
        Assert.assertEquals((long)((int)Math.ceil((float)expectedMaxActiveAppsUsingAbsCap * ((float)queue.getUserLimit() / 100.0f) * queue.getUserLimitFactor())), (long)queue.getMaximumActiveApplicationsPerUser());
        Assert.assertEquals((long)((int)((float)clusterResource.getMemory() * queue.getAbsoluteCapacity())), (long)queue.getMetrics().getAvailableMB());
        clusterResource = Resources.createResource((int)0x1E0000);
        root.updateClusterResource(clusterResource);
        expectedMaxActiveApps = Math.max(1, (int)Math.ceil((float)clusterResource.getMemory() / 1024.0f * csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath()) * queue.getAbsoluteMaximumCapacity()));
        Assert.assertEquals((long)expectedMaxActiveApps, (long)queue.getMaximumActiveApplications());
        expectedMaxActiveAppsUsingAbsCap = Math.max(1, (int)Math.ceil((float)clusterResource.getMemory() / 1024.0f * csConf.getMaximumApplicationMasterResourcePercent() * queue.getAbsoluteCapacity()));
        Assert.assertEquals((long)((int)Math.ceil((float)expectedMaxActiveAppsUsingAbsCap * ((float)queue.getUserLimit() / 100.0f) * queue.getUserLimitFactor())), (long)queue.getMaximumActiveApplicationsPerUser());
        Assert.assertEquals((long)((int)((float)clusterResource.getMemory() * queue.getAbsoluteCapacity())), (long)queue.getMetrics().getAvailableMB());
        Assert.assertEquals((long)-1L, (long)csConf.getMaximumApplicationsPerQueue(queue.getQueuePath()));
        int expectedMaxApps = (int)(10000.0f * queue.getAbsoluteCapacity());
        Assert.assertEquals((long)expectedMaxApps, (long)queue.getMaxApplications());
        int expectedMaxAppsPerUser = (int)((float)expectedMaxApps * ((float)queue.getUserLimit() / 100.0f) * queue.getUserLimitFactor());
        Assert.assertEquals((long)expectedMaxAppsPerUser, (long)queue.getMaxApplicationsPerUser());
        Assert.assertEquals((long)0L, (long)((long)csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath())));
        csConf.setFloat("yarn.scheduler.capacity." + queue.getQueuePath() + ".maximum-am-resource-percent", 0.5f);
        queues = new HashMap();
        root = CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        clusterResource = Resources.createResource((int)0x190000);
        queue = (LeafQueue)queues.get(A);
        expectedMaxActiveApps = Math.max(1, (int)Math.ceil((float)clusterResource.getMemory() / 1024.0f * csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath()) * queue.getAbsoluteMaximumCapacity()));
        Assert.assertEquals((long)0L, (long)((long)csConf.getMaximumApplicationMasterResourcePerQueuePercent(queue.getQueuePath())));
        Assert.assertEquals((long)expectedMaxActiveApps, (long)queue.getMaximumActiveApplications());
        csConf.setInt("yarn.scheduler.capacity." + queue.getQueuePath() + ".maximum-applications", 9999);
        queues = new HashMap();
        root = CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        queue = (LeafQueue)queues.get(A);
        Assert.assertEquals((long)9999L, (long)csConf.getMaximumApplicationsPerQueue(queue.getQueuePath()));
        Assert.assertEquals((long)9999L, (long)queue.getMaxApplications());
        expectedMaxAppsPerUser = (int)(9999.0f * ((float)queue.getUserLimit() / 100.0f) * queue.getUserLimitFactor());
        Assert.assertEquals((long)expectedMaxAppsPerUser, (long)queue.getMaxApplicationsPerUser());
    }

    @Test
    public void testActiveApplicationLimits() throws Exception {
        String user_0 = "user_0";
        String user_1 = "user_1";
        int APPLICATION_ID = 0;
        FiCaSchedulerApp app_0 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_0, "user_0", A);
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_1 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_1, "user_0", A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_2 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_2, "user_0", A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        this.queue.finishApplication(app_0, A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        FiCaSchedulerApp app_3 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_3, "user_0", A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        ((LeafQueue)Mockito.doReturn((Object)3).when((Object)this.queue)).getMaximumActiveApplications();
        FiCaSchedulerApp app_4 = this.getMockApplication(APPLICATION_ID++, "user_1");
        this.queue.submitApplication(app_4, "user_1", A);
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
        FiCaSchedulerApp app_5 = this.getMockApplication(APPLICATION_ID++, "user_1");
        this.queue.submitApplication(app_5, "user_1", A);
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_1"));
        this.queue.finishApplication(app_4, A);
        Assert.assertEquals((long)3L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_1"));
    }

    @Test
    public void testActiveLimitsWithKilledApps() throws Exception {
        String user_0 = "user_0";
        int APPLICATION_ID = 0;
        ((LeafQueue)Mockito.doReturn((Object)2).when((Object)this.queue)).getMaximumActiveApplications();
        FiCaSchedulerApp app_0 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_0, "user_0", A);
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.activeApplications.contains(app_0));
        FiCaSchedulerApp app_1 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_1, "user_0", A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.activeApplications.contains(app_1));
        FiCaSchedulerApp app_2 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_2, "user_0", A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.pendingApplications.contains(app_2));
        FiCaSchedulerApp app_3 = this.getMockApplication(APPLICATION_ID++, "user_0");
        this.queue.submitApplication(app_3, "user_0", A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)2L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.pendingApplications.contains(app_3));
        this.queue.finishApplication(app_2, A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)1L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertFalse((boolean)this.queue.pendingApplications.contains(app_2));
        Assert.assertFalse((boolean)this.queue.activeApplications.contains(app_2));
        this.queue.finishApplication(app_0, A);
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)2L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertTrue((boolean)this.queue.activeApplications.contains(app_3));
        Assert.assertFalse((boolean)this.queue.pendingApplications.contains(app_3));
        Assert.assertFalse((boolean)this.queue.activeApplications.contains(app_0));
        this.queue.finishApplication(app_1, A);
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)1L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertFalse((boolean)this.queue.activeApplications.contains(app_1));
        this.queue.finishApplication(app_3, A);
        Assert.assertEquals((long)0L, (long)this.queue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications());
        Assert.assertEquals((long)0L, (long)this.queue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)this.queue.getNumPendingApplications("user_0"));
        Assert.assertFalse((boolean)this.queue.activeApplications.contains(app_3));
    }

    @Test
    public void testHeadroom() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setUserLimit("root.a", 25);
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384));
        Mockito.when((Object)csContext.getApplicationComparator()).thenReturn((Object)CapacityScheduler.applicationComparator);
        Mockito.when((Object)csContext.getQueueComparator()).thenReturn((Object)CapacityScheduler.queueComparator);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Resource clusterResource = Resources.createResource((int)0x190000);
        Mockito.when((Object)csContext.getClusterResources()).thenReturn((Object)clusterResource);
        HashMap queues = new HashMap();
        CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", queues, queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        LeafQueue queue = TestLeafQueue.stubLeafQueue((LeafQueue)queues.get(A));
        String host_0 = "host_0";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, rack_0, 0, 16384);
        String user_0 = "user_0";
        String user_1 = "user_1";
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        RMContext rmContext = TestUtils.getMockRMContext();
        Priority priority_1 = TestUtils.createMockPriority(1);
        ApplicationAttemptId appAttemptId_0_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0_0, "user_0", (Queue)queue, queue.getActiveUsersManager(), rmContext));
        queue.submitApplication(app_0_0, "user_0", A);
        ArrayList<ResourceRequest> app_0_0_requests = new ArrayList<ResourceRequest>();
        app_0_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_0_0.updateResourceRequests(app_0_0_requests);
        queue.assignContainers(clusterResource, node_0);
        Resource expectedHeadroom = Resources.createResource((int)163840, (int)1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_0)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ApplicationAttemptId appAttemptId_0_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_0_1 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0_1, "user_0", (Queue)queue, queue.getActiveUsersManager(), rmContext));
        queue.submitApplication(app_0_1, "user_0", A);
        ArrayList<ResourceRequest> app_0_1_requests = new ArrayList<ResourceRequest>();
        app_0_1_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_0_1.updateResourceRequests(app_0_1_requests);
        queue.assignContainers(clusterResource, node_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_0, (VerificationMode)Mockito.times((int)2))).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_1)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ApplicationAttemptId appAttemptId_1_0 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_1_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_1_0, "user_1", (Queue)queue, queue.getActiveUsersManager(), rmContext));
        queue.submitApplication(app_1_0, "user_1", A);
        ArrayList<ResourceRequest> app_1_0_requests = new ArrayList<ResourceRequest>();
        app_1_0_requests.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, recordFactory));
        app_1_0.updateResourceRequests(app_1_0_requests);
        queue.assignContainers(clusterResource, node_0);
        expectedHeadroom = Resources.createResource((int)81920, (int)1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_0)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_1)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_1_0)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        clusterResource = Resources.createResource((int)1474560);
        queue.assignContainers(clusterResource, node_0);
        expectedHeadroom = Resources.createResource((int)73728, (int)1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_0)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0_1)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_1_0)).setHeadroom((Resource)Matchers.eq((Object)expectedHeadroom));
    }

    @After
    public void tearDown() {
    }
}

