/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceRequestPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSchedulerUtils {
    private static final Log LOG = LogFactory.getLog(TestSchedulerUtils.class);

    @Test(timeout=30000L)
    public void testNormalizeRequest() {
        DefaultResourceCalculator resourceCalculator = new DefaultResourceCalculator();
        int minMemory = 1024;
        int maxMemory = 8192;
        Resource minResource = Resources.createResource((int)1024, (int)0);
        Resource maxResource = Resources.createResource((int)8192, (int)0);
        ResourceRequestPBImpl ask = new ResourceRequestPBImpl();
        ask.setCapability(Resources.createResource((int)-1024));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)1024L, (long)ask.getCapability().getMemory());
        ask.setCapability(Resources.createResource((int)0));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)1024L, (long)ask.getCapability().getMemory());
        ask.setCapability(Resources.createResource((int)2048));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)2048L, (long)ask.getCapability().getMemory());
        ask.setCapability(Resources.createResource((int)1034));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)2048L, (long)ask.getCapability().getMemory());
        ask.setCapability(Resources.createResource((int)8192));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)8192L, (long)ask.getCapability().getMemory());
        ask.setCapability(Resources.createResource((int)8182));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)8192L, (long)ask.getCapability().getMemory());
        maxResource = Resources.createResource((int)8182, (int)0);
        ask.setCapability(Resources.createResource((int)8092));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)maxResource.getMemory(), (long)ask.getCapability().getMemory());
        maxResource = Resources.createResource((int)8192, (int)0);
        ask.setCapability(Resources.createResource((int)8292));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, null, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((long)maxResource.getMemory(), (long)ask.getCapability().getMemory());
    }

    @Test(timeout=30000L)
    public void testNormalizeRequestWithDominantResourceCalculator() {
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Resource minResource = Resources.createResource((int)1024, (int)1);
        Resource maxResource = Resources.createResource((int)10240, (int)10);
        Resource clusterResource = Resources.createResource((int)10240, (int)10);
        ResourceRequestPBImpl ask = new ResourceRequestPBImpl();
        ask.setCapability(Resources.createResource((int)-1024, (int)-1));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)clusterResource, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((Object)minResource, (Object)ask.getCapability());
        ask.setCapability(Resources.createResource((int)0, (int)0));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)clusterResource, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((Object)minResource, (Object)ask.getCapability());
        Assert.assertEquals((long)1L, (long)ask.getCapability().getVirtualCores());
        Assert.assertEquals((long)1024L, (long)ask.getCapability().getMemory());
        ask.setCapability(Resources.createResource((int)1536, (int)0));
        SchedulerUtils.normalizeRequest((ResourceRequest)ask, (ResourceCalculator)resourceCalculator, (Resource)clusterResource, (Resource)minResource, (Resource)maxResource);
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)1), (Object)ask.getCapability());
        Assert.assertEquals((long)1L, (long)ask.getCapability().getVirtualCores());
        Assert.assertEquals((long)2048L, (long)ask.getCapability().getMemory());
    }

    @Test(timeout=30000L)
    public void testValidateResourceRequest() {
        ResourceRequest resReq;
        Resource resource;
        Resource maxResource = Resources.createResource((int)8192, (int)4);
        try {
            resource = Resources.createResource((int)0, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Zero memory should be accepted");
        }
        try {
            resource = Resources.createResource((int)1024, (int)0);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Zero vcores should be accepted");
        }
        try {
            resource = Resources.createResource((int)8192, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Max memory should be accepted");
        }
        try {
            resource = Resources.createResource((int)1024, (int)4);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
        }
        catch (InvalidResourceRequestException e) {
            Assert.fail((String)"Max vcores should not be accepted");
        }
        try {
            resource = Resources.createResource((int)-1, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
            Assert.fail((String)"Negative memory should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            // empty catch block
        }
        try {
            resource = Resources.createResource((int)1024, (int)-1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
            Assert.fail((String)"Negative vcores should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            // empty catch block
        }
        try {
            resource = Resources.createResource((int)8193, (int)1);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
            Assert.fail((String)"More than max memory should not be accepted");
        }
        catch (InvalidResourceRequestException e) {
            // empty catch block
        }
        try {
            resource = Resources.createResource((int)1024, (int)5);
            resReq = BuilderUtils.newResourceRequest((Priority)((Priority)Mockito.mock(Priority.class)), (String)"*", (Resource)resource, (int)1);
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maxResource);
            Assert.fail((String)"More than max vcores should not be accepted");
        }
        catch (InvalidResourceRequestException invalidResourceRequestException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateResourceBlacklistRequest() throws Exception {
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS((Configuration)new YarnConfiguration(), containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        RMApp app = rm.submitApp(1024, "appname", "appuser", acls);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        this.waitForLaunchedState(attempt);
        final Configuration conf = rm.getConfig();
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        final InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
        Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, rmBindAddress, conf);
            }
        });
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        client.registerApplicationMaster(request);
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(Collections.singletonList("*"), null);
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, (ResourceBlacklistRequest)blacklistRequest);
        boolean error = false;
        try {
            client.allocate(allocateRequest);
        }
        catch (InvalidResourceBlacklistRequestException e) {
            error = true;
        }
        rm.stop();
        Assert.assertTrue((String)"Didn't not catch InvalidResourceBlacklistRequestException", (boolean)error);
    }

    private void waitForLaunchedState(RMAppAttempt attempt) throws InterruptedException {
        int waitCount = 0;
        while (attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && waitCount++ < 20) {
            LOG.info((Object)("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState()));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
    }

    @Test
    public void testComparePriorities() {
        Priority low;
        Priority high = Priority.newInstance((int)1);
        Assert.assertTrue((high.compareTo(low = Priority.newInstance((int)2)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateAbnormalContainerStatus() {
        ContainerStatus cd = SchedulerUtils.createAbnormalContainerStatus((ContainerId)ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1), (int)1), (String)"x");
        Assert.assertEquals((long)-100L, (long)cd.getExitStatus());
    }

    @Test
    public void testCreatePreemptedContainerStatus() {
        ContainerStatus cd = SchedulerUtils.createPreemptedContainerStatus((ContainerId)ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1), (int)1), (String)"x");
        Assert.assertEquals((long)-102L, (long)cd.getExitStatus());
    }
}

