/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestRMNodeTransitions {
    RMNodeImpl node;
    private RMContext rmContext;
    private YarnScheduler scheduler;
    private SchedulerEventType eventType;
    private List<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
    private NodesListManagerEvent nodesListManagerEvent = null;

    @Before
    public void setUp() throws Exception {
        InlineDispatcher rmDispatcher = new InlineDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)rmDispatcher, null, null, null, (DelegationTokenRenewer)Mockito.mock(DelegationTokenRenewer.class), null, null, null, null);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ((YarnScheduler)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                SchedulerEvent event = (SchedulerEvent)invocation.getArguments()[0];
                TestRMNodeTransitions.this.eventType = (SchedulerEventType)event.getType();
                if (TestRMNodeTransitions.this.eventType == SchedulerEventType.NODE_UPDATE) {
                    List lastestContainersInfoList = ((NodeUpdateSchedulerEvent)event).getRMNode().pullContainerUpdates();
                    for (UpdatedContainerInfo lastestContainersInfo : lastestContainersInfoList) {
                        TestRMNodeTransitions.this.completedContainers.addAll(lastestContainersInfo.getCompletedContainers());
                    }
                }
                return null;
            }
        }).when((Object)this.scheduler)).handle((Event)Matchers.any(SchedulerEvent.class));
        rmDispatcher.register(SchedulerEventType.class, (EventHandler)new TestSchedulerEventDispatcher());
        rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)new TestNodeListManagerEventDispatcher());
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        this.node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null);
        this.nodesListManagerEvent = null;
    }

    @After
    public void tearDown() throws Exception {
    }

    private RMNodeStatusEvent getMockRMNodeStatusEvent() {
        NodeHeartbeatResponse response = (NodeHeartbeatResponse)Mockito.mock(NodeHeartbeatResponse.class);
        NodeHealthStatus healthStatus = (NodeHealthStatus)Mockito.mock(NodeHealthStatus.class);
        Boolean yes = new Boolean(true);
        ((NodeHealthStatus)Mockito.doReturn((Object)yes).when((Object)healthStatus)).getIsNodeHealthy();
        RMNodeStatusEvent event = (RMNodeStatusEvent)Mockito.mock(RMNodeStatusEvent.class);
        ((RMNodeStatusEvent)Mockito.doReturn((Object)healthStatus).when((Object)event)).getNodeHealthStatus();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)response).when((Object)event)).getLatestResponse();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)RMNodeEventType.STATUS_UPDATE).when((Object)event)).getType();
        return event;
    }

    @Test(timeout=5000L)
    public void testExpiredContainer() {
        this.node.handle(new RMNodeEvent(null, RMNodeEventType.STARTED));
        ((YarnScheduler)Mockito.verify((Object)this.scheduler)).handle((Event)Matchers.any(NodeAddedSchedulerEvent.class));
        ContainerId completedContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (int)0);
        this.node.handle((RMNodeEvent)new RMNodeCleanContainerEvent(null, completedContainerId));
        Assert.assertEquals((int)1, (int)this.node.getContainersToCleanUp().size());
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEvent();
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId).when((Object)containerStatus)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus)).when((Object)statusEvent)).getContainers();
        this.node.handle((RMNodeEvent)statusEvent);
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(NodeUpdateSchedulerEvent.class));
    }

    @Test(timeout=5000L)
    public void testContainerUpdate() throws InterruptedException {
        this.node.handle(new RMNodeEvent(null, RMNodeEventType.STARTED));
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost:1", (int)1);
        RMNodeImpl node2 = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null);
        node2.handle(new RMNodeEvent(null, RMNodeEventType.STARTED));
        ContainerId completedContainerIdFromNode1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (int)0);
        ContainerId completedContainerIdFromNode2_1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)1L, (int)1), (int)1), (int)1);
        ContainerId completedContainerIdFromNode2_2 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)1L, (int)1), (int)1), (int)2);
        RMNodeStatusEvent statusEventFromNode1 = this.getMockRMNodeStatusEvent();
        RMNodeStatusEvent statusEventFromNode2_1 = this.getMockRMNodeStatusEvent();
        RMNodeStatusEvent statusEventFromNode2_2 = this.getMockRMNodeStatusEvent();
        ContainerStatus containerStatusFromNode1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerStatus containerStatusFromNode2_1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerStatus containerStatusFromNode2_2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerIdFromNode1).when((Object)containerStatusFromNode1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatusFromNode1)).when((Object)statusEventFromNode1)).getContainers();
        this.node.handle((RMNodeEvent)statusEventFromNode1);
        Assert.assertEquals((int)1, (int)this.completedContainers.size());
        Assert.assertEquals((Object)completedContainerIdFromNode1, (Object)this.completedContainers.get(0).getContainerId());
        this.completedContainers.clear();
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerIdFromNode2_1).when((Object)containerStatusFromNode2_1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatusFromNode2_1)).when((Object)statusEventFromNode2_1)).getContainers();
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerIdFromNode2_2).when((Object)containerStatusFromNode2_2)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatusFromNode2_2)).when((Object)statusEventFromNode2_2)).getContainers();
        node2.setNextHeartBeat(false);
        node2.handle((RMNodeEvent)statusEventFromNode2_1);
        node2.setNextHeartBeat(true);
        node2.handle((RMNodeEvent)statusEventFromNode2_2);
        Assert.assertEquals((int)2, (int)this.completedContainers.size());
        Assert.assertEquals((Object)completedContainerIdFromNode2_1, (Object)this.completedContainers.get(0).getContainerId());
        Assert.assertEquals((Object)completedContainerIdFromNode2_2, (Object)this.completedContainers.get(1).getContainerId());
    }

    @Test(timeout=5000L)
    public void testStatusChange() {
        this.node.handle(new RMNodeEvent(null, RMNodeEventType.STARTED));
        this.node.setNextHeartBeat(false);
        ContainerId completedContainerId1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (int)0);
        ContainerId completedContainerId2 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)1L, (int)1), (int)1), (int)1);
        RMNodeStatusEvent statusEvent1 = this.getMockRMNodeStatusEvent();
        RMNodeStatusEvent statusEvent2 = this.getMockRMNodeStatusEvent();
        ContainerStatus containerStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerStatus containerStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId1).when((Object)containerStatus1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus1)).when((Object)statusEvent1)).getContainers();
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId2).when((Object)containerStatus2)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus2)).when((Object)statusEvent2)).getContainers();
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)Matchers.any(NodeUpdateSchedulerEvent.class));
        this.node.handle((RMNodeEvent)statusEvent1);
        this.node.handle((RMNodeEvent)statusEvent2);
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)Matchers.any(NodeUpdateSchedulerEvent.class));
        Assert.assertEquals((int)2, (int)this.node.getQueueSize());
        this.node.handle(new RMNodeEvent(this.node.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((int)0, (int)this.node.getQueueSize());
    }

    @Test
    public void testRunningExpire() {
        RMNodeImpl node = this.getRunningNode();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((Object)NodeState.LOST, (Object)node.getState());
    }

    @Test
    public void testUnhealthyExpire() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((String)"Active Nodes", (int)initialActive, (int)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (int)(initialLost + 1), (int)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (int)(initialUnhealthy - 1), (int)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (int)initialDecommissioned, (int)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (int)initialRebooted, (int)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.LOST, (Object)node.getState());
    }

    @Test
    public void testUnhealthyExpireForSchedulerRemove() {
        RMNodeImpl node = this.getUnhealthyNode();
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(NodeRemovedSchedulerEvent.class));
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(NodeRemovedSchedulerEvent.class));
        Assert.assertEquals((Object)NodeState.LOST, (Object)node.getState());
    }

    @Test
    public void testRunningDecommission() {
        RMNodeImpl node = this.getRunningNode();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.DECOMMISSION));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testUnhealthyDecommission() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.DECOMMISSION));
        Assert.assertEquals((String)"Active Nodes", (int)initialActive, (int)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (int)initialLost, (int)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (int)(initialUnhealthy - 1), (int)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (int)(initialDecommissioned + 1), (int)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (int)initialRebooted, (int)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testRunningRebooting() {
        RMNodeImpl node = this.getRunningNode();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.REBOOTING));
        Assert.assertEquals((Object)NodeState.REBOOTED, (Object)node.getState());
    }

    @Test
    public void testUnhealthyRebooting() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.REBOOTING));
        Assert.assertEquals((String)"Active Nodes", (int)initialActive, (int)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (int)initialLost, (int)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (int)(initialUnhealthy - 1), (int)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (int)initialDecommissioned, (int)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (int)(initialRebooted + 1), (int)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.REBOOTED, (Object)node.getState());
    }

    @Test(timeout=20000L)
    public void testUpdateHeartbeatResponseForCleanup() {
        RMNodeImpl node = this.getRunningNode();
        NodeId nodeId = node.getNodeID();
        ContainerId completedContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (int)0);
        node.handle((RMNodeEvent)new RMNodeCleanContainerEvent(nodeId, completedContainerId));
        Assert.assertEquals((int)1, (int)node.getContainersToCleanUp().size());
        ApplicationId finishedAppId = BuilderUtils.newApplicationId((long)0L, (int)1);
        node.handle((RMNodeEvent)new RMNodeCleanAppEvent(nodeId, finishedAppId));
        Assert.assertEquals((int)1, (int)node.getAppsToCleanup().size());
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEvent();
        node.handle((RMNodeEvent)statusEvent);
        Assert.assertEquals((int)1, (int)node.getContainersToCleanUp().size());
        Assert.assertEquals((int)1, (int)node.getAppsToCleanup().size());
        NodeHeartbeatResponse hbrsp = (NodeHeartbeatResponse)Records.newRecord(NodeHeartbeatResponse.class);
        node.updateNodeHeartbeatResponseForCleanup(hbrsp);
        Assert.assertEquals((int)0, (int)node.getContainersToCleanUp().size());
        Assert.assertEquals((int)0, (int)node.getAppsToCleanup().size());
        Assert.assertEquals((int)1, (int)hbrsp.getContainersToCleanup().size());
        Assert.assertEquals((Object)completedContainerId, hbrsp.getContainersToCleanup().get(0));
        Assert.assertEquals((int)1, (int)hbrsp.getApplicationsToCleanup().size());
        Assert.assertEquals((Object)finishedAppId, hbrsp.getApplicationsToCleanup().get(0));
    }

    private RMNodeImpl getRunningNode() {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        Resource capability = Resource.newInstance((int)4096, (int)4);
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, capability);
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.STARTED));
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        return node;
    }

    private RMNodeImpl getUnhealthyNode() {
        RMNodeImpl node = this.getRunningNode();
        NodeHealthStatus status = NodeHealthStatus.newInstance((boolean)false, (String)"sick", (long)System.currentTimeMillis());
        node.handle((RMNodeEvent)new RMNodeStatusEvent(node.getNodeID(), status, new ArrayList(), null, null));
        Assert.assertEquals((Object)NodeState.UNHEALTHY, (Object)node.getState());
        return node;
    }

    private RMNodeImpl getNewNode() {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null);
        return node;
    }

    @Test
    public void testAdd() {
        RMNodeImpl node = this.getNewNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.STARTED));
        Assert.assertEquals((String)"Active Nodes", (int)(initialActive + 1), (int)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (int)initialLost, (int)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (int)initialUnhealthy, (int)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (int)initialDecommissioned, (int)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (int)initialRebooted, (int)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        Assert.assertNotNull((Object)this.nodesListManagerEvent);
        Assert.assertEquals((Object)NodesListManagerEventType.NODE_USABLE, (Object)this.nodesListManagerEvent.getType());
    }

    @Test
    public void testReconnect() {
        RMNodeImpl node = this.getRunningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)node));
        Assert.assertEquals((String)"Active Nodes", (int)initialActive, (int)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (int)initialLost, (int)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (int)initialUnhealthy, (int)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (int)initialDecommissioned, (int)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (int)initialRebooted, (int)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        Assert.assertNotNull((Object)this.nodesListManagerEvent);
        Assert.assertEquals((Object)NodesListManagerEventType.NODE_USABLE, (Object)this.nodesListManagerEvent.getType());
    }

    private class TestNodeListManagerEventDispatcher
    implements EventHandler<NodesListManagerEvent> {
        private TestNodeListManagerEventDispatcher() {
        }

        public void handle(NodesListManagerEvent event) {
            TestRMNodeTransitions.this.nodesListManagerEvent = event;
        }
    }

    private final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
            TestRMNodeTransitions.this.scheduler.handle((Event)event);
        }
    }
}

