/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MockRM
extends ResourceManager {
    public MockRM() {
        this((Configuration)new YarnConfiguration());
    }

    public MockRM(Configuration conf) {
        this(conf, null);
    }

    public MockRM(Configuration conf, RMStateStore store) {
        this.init((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
        if (store != null) {
            this.setRMStateStore(store);
        }
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
    }

    public void waitForState(ApplicationId appId, RMAppState finalState) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)app.getState()) && timeoutSecs++ < 40) {
            System.out.println("App : " + appId + " State is : " + app.getState() + " Waiting for state : " + finalState);
            Thread.sleep(2000L);
        }
        System.out.println("App State is : " + app.getState());
        Assert.assertEquals((String)"App state is not correct (timedout)", (Object)finalState, (Object)app.getState());
    }

    public void waitForState(ApplicationAttemptId attemptId, RMAppAttemptState finalState) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(attemptId.getApplicationId());
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        int timeoutSecs = 0;
        while (!finalState.equals((Object)attempt.getAppAttemptState()) && timeoutSecs++ < 40) {
            System.out.println("AppAttempt : " + attemptId + " State is : " + attempt.getAppAttemptState() + " Waiting for state : " + finalState);
            Thread.sleep(1000L);
        }
        System.out.println("Attempt State is : " + attempt.getAppAttemptState());
        Assert.assertEquals((String)"Attempt state is not correct (timedout)", (Object)finalState, (Object)attempt.getAppAttemptState());
    }

    public GetNewApplicationResponse getNewAppId() throws Exception {
        ClientRMService client = this.getClientRMService();
        return client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
    }

    public RMApp submitApp(int masterMemory) throws Exception {
        return this.submitApp(masterMemory, "", UserGroupInformation.getCurrentUser().getShortUserName());
    }

    public RMApp submitApp(int masterMemory, String name, String user) throws Exception {
        return this.submitApp(masterMemory, name, user, null, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, String queue) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, queue, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType) throws Exception {
        ClientRMService client = this.getClientRMService();
        GetNewApplicationResponse resp = client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
        ApplicationId appId = resp.getApplicationId();
        SubmitApplicationRequest req = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setApplicationId(appId);
        sub.setApplicationName(name);
        sub.setMaxAppAttempts(maxAppAttempts);
        if (unmanaged) {
            sub.setUnmanagedAM(true);
        }
        if (queue != null) {
            sub.setQueue(queue);
        }
        sub.setApplicationType(appType);
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(masterMemory);
        sub.setResource(capability);
        clc.setApplicationACLs(acls);
        if (ts != null && UserGroupInformation.isSecurityEnabled()) {
            DataOutputBuffer dob = new DataOutputBuffer();
            ts.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            clc.setTokens(securityTokens);
        }
        sub.setAMContainerSpec(clc);
        req.setApplicationSubmissionContext(sub);
        UserGroupInformation fakeUser = UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{"someGroup"});
        PrivilegedAction<SubmitApplicationResponse> action = new PrivilegedAction<SubmitApplicationResponse>(){
            ApplicationClientProtocol client;
            SubmitApplicationRequest req;

            @Override
            public SubmitApplicationResponse run() {
                try {
                    return this.client.submitApplication(this.req);
                }
                catch (YarnException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            PrivilegedAction<SubmitApplicationResponse> setClientReq(ApplicationClientProtocol client, SubmitApplicationRequest req) {
                this.client = client;
                this.req = req;
                return this;
            }
        }.setClientReq((ApplicationClientProtocol)client, req);
        fakeUser.doAs(action);
        this.waitForState(appId, RMAppState.ACCEPTED);
        return (RMApp)this.getRMContext().getRMApps().get(appId);
    }

    public MockNM registerNode(String nodeIdStr, int memory) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, this.getResourceTrackerService());
        nm.registerNode();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, this.getResourceTrackerService());
        nm.registerNode();
        return nm;
    }

    public void sendNodeStarted(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle(new RMNodeEvent(nm.getNodeId(), RMNodeEventType.STARTED));
    }

    public void sendNodeLost(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle(new RMNodeEvent(nm.getNodeId(), RMNodeEventType.EXPIRE));
    }

    public void NMwaitForState(NodeId nodeid, NodeState finalState) throws Exception {
        RMNode node = (RMNode)this.getRMContext().getRMNodes().get(nodeid);
        Assert.assertNotNull((String)"node shouldn't be null", (Object)node);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)node.getState()) && timeoutSecs++ < 20) {
            System.out.println("Node State is : " + node.getState() + " Waiting for state : " + finalState);
            Thread.sleep(500L);
        }
        System.out.println("Node State is : " + node.getState());
        Assert.assertEquals((String)"Node state is not correct (timedout)", (Object)finalState, (Object)node.getState());
    }

    public void killApp(ApplicationId appId) throws Exception {
        ClientRMService client = this.getClientRMService();
        KillApplicationRequest req = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        req.setApplicationId(appId);
        client.forceKillApplication(req);
    }

    public MockAM sendAMLaunched(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        am.waitForState(RMAppAttemptState.ALLOCATED);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.LAUNCHED));
        return am;
    }

    public void sendAMLaunchFailed(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        am.waitForState(RMAppAttemptState.ALLOCATED);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptLaunchFailedEvent(appAttemptId, "Failed"));
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.getRMContext(), (YarnScheduler)this.getResourceScheduler(), this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.rmDTSecretManager){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ResourceTrackerService createResourceTrackerService() {
        Configuration conf = new Configuration();
        this.containerTokenSecretManager.rollMasterKey();
        this.nmTokenSecretManager.rollMasterKey();
        return new ResourceTrackerService(this.getRMContext(), this.nodesListManager, this.nmLivelinessMonitor, this.containerTokenSecretManager, this.nmTokenSecretManager){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.getRMContext(), (YarnScheduler)this.scheduler){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.getRMContext()){

            protected void serviceStart() {
            }

            public void handle(AMLauncherEvent appEvent) {
            }

            protected void serviceStop() {
            }
        };
    }

    protected AdminService createAdminService(ClientRMService clientRMService, ApplicationMasterService applicationMasterService, ResourceTrackerService resourceTrackerService) {
        return new AdminService(this.getConfig(), this.scheduler, this.getRMContext(), this.nodesListManager, clientRMService, applicationMasterService, resourceTrackerService){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    public RMDelegationTokenSecretManager getRMDTSecretManager() {
        return this.rmDTSecretManager;
    }

    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.clientToAMSecretManager;
    }

    protected void startWepApp() {
    }
}

