/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ContainerLaunch
implements Callable<Integer> {
    private static final Log LOG = LogFactory.getLog(ContainerLaunch.class);
    public static final String CONTAINER_SCRIPT = Shell.appendScriptExtension((String)"launch_container");
    public static final String FINAL_CONTAINER_TOKENS_FILE = "container_tokens";
    private static final String PID_FILE_NAME_FMT = "%s.pid";
    private final Dispatcher dispatcher;
    private final ContainerExecutor exec;
    private final Application app;
    private final Container container;
    private final Configuration conf;
    private final Context context;
    private final ContainerManagerImpl containerManager;
    private volatile AtomicBoolean shouldLaunchContainer = new AtomicBoolean(false);
    private volatile AtomicBoolean completed = new AtomicBoolean(false);
    private long sleepDelayBeforeSigKill = 250L;
    private long maxKillWaitTime = 2000L;
    private Path pidFilePath = null;
    private final LocalDirsHandlerService dirsHandler;

    public ContainerLaunch(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        this.context = context;
        this.conf = configuration;
        this.app = app;
        this.exec = exec;
        this.container = container;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
        this.containerManager = containerManager;
        this.sleepDelayBeforeSigKill = this.conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L);
        this.maxKillWaitTime = this.conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        ContainerLaunchContext launchContext = this.container.getLaunchContext();
        Map<Path, List<String>> localResources = null;
        ContainerId containerID = this.container.getContainerId();
        String containerIdStr = ConverterUtils.toString((ContainerId)containerID);
        List command = launchContext.getCommands();
        int ret = -1;
        if (this.container.getContainerState() == ContainerState.KILLING) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before launch."));
            return 0;
        }
        try {
            localResources = this.container.getLocalizedResources();
            if (localResources == null) {
                throw RPCUtil.getRemoteException((String)("Unable to get local resources when Container " + containerID + " is at " + (Object)((Object)this.container.getContainerState())));
            }
            String user = this.container.getUser();
            ArrayList<String> newCmds = new ArrayList<String>(command.size());
            String appIdStr = this.app.getAppId().toString();
            String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr);
            Path containerLogDir = this.dirsHandler.getLogPathForWrite(relativeContainerLogDir, false);
            for (String str : command) {
                newCmds.add(str.replace("<LOG_DIR>", containerLogDir.toString()));
            }
            launchContext.setCommands(newCmds);
            Map environment = launchContext.getEnvironment();
            for (Map.Entry entry : environment.entrySet()) {
                String value = (String)entry.getValue();
                entry.setValue(value.replace("<LOG_DIR>", containerLogDir.toString()));
            }
            FileContext lfs = FileContext.getLocalFSFileContext();
            Path path = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + CONTAINER_SCRIPT);
            Path nmPrivateTokensPath = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format("%s.tokens", containerIdStr));
            FSDataOutputStream containerScriptOutStream = null;
            FSDataOutputStream tokensOutStream = null;
            Path containerWorkDir = this.dirsHandler.getLocalPathForWrite("usercache/" + user + "/" + "appcache" + "/" + appIdStr + "/" + containerIdStr, -1L, false);
            String pidFileSuffix = String.format(PID_FILE_NAME_FMT, containerIdStr);
            this.pidFilePath = this.dirsHandler.getLocalPathForWrite("nmPrivate/" + pidFileSuffix);
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            List<String> logDirs = this.dirsHandler.getLogDirs();
            ArrayList<String> containerLogDirs = new ArrayList<String>();
            for (String logDir : logDirs) {
                containerLogDirs.add(logDir + "/" + relativeContainerLogDir);
            }
            if (!this.dirsHandler.areDisksHealthy()) {
                ret = -101;
                throw new IOException("Most of the disks failed. " + this.dirsHandler.getDisksHealthReport());
            }
            try {
                ArrayList<Path> appDirs = new ArrayList<Path>(localDirs.size());
                for (String localDir : localDirs) {
                    Path usersdir = new Path(localDir, "usercache");
                    Path userdir = new Path(usersdir, user);
                    Path appsdir = new Path(userdir, "appcache");
                    appDirs.add(new Path(appsdir, appIdStr));
                }
                containerScriptOutStream = lfs.create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                environment.put("HADOOP_TOKEN_FILE_LOCATION", new Path(containerWorkDir, FINAL_CONTAINER_TOKENS_FILE).toUri().getPath());
                this.sanitizeEnv(environment, containerWorkDir, appDirs, containerLogDirs, localResources);
                ContainerLaunch.writeLaunchEnv((OutputStream)containerScriptOutStream, environment, localResources, launchContext.getCommands());
                tokensOutStream = lfs.create(nmPrivateTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                Credentials creds = this.container.getCredentials();
                creds.writeTokenStorageToStream((DataOutputStream)tokensOutStream);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{containerScriptOutStream, tokensOutStream});
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerID, ContainerEventType.CONTAINER_LAUNCHED));
            if (!this.shouldLaunchContainer.compareAndSet(false, true)) {
                LOG.info((Object)("Container " + containerIdStr + " not launched as " + "cleanup already called"));
                ret = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            } else {
                this.exec.activateContainer(containerID, this.pidFilePath);
                ret = this.exec.launchContainer(this.container, path, nmPrivateTokensPath, user, appIdStr, containerWorkDir, localDirs, logDirs);
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)"Failed to launch container.", e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            Integer n = ret;
            return n;
        }
        finally {
            this.completed.set(true);
            this.exec.deactivateContainer(containerID);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Container " + containerIdStr + " completed with exit code " + ret));
        }
        if (ret == ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() || ret == ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, ret, "Container exited with a non-zero exit code " + ret));
            return ret;
        }
        if (ret != 0) {
            LOG.warn((Object)("Container exited with a non-zero exit code " + ret));
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, "Container exited with a non-zero exit code " + ret));
            return ret;
        }
        LOG.info((Object)("Container " + containerIdStr + " succeeded "));
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContainer() throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
        LOG.info((Object)("Cleaning up container " + containerIdStr));
        boolean bl = alreadyLaunched = !this.shouldLaunchContainer.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info((Object)("Container " + containerIdStr + " not launched." + " No cleanup needed to be done"));
            return;
        }
        LOG.debug((Object)("Marking container " + containerIdStr + " as inactive"));
        this.exec.deactivateContainer(containerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting pid for container " + containerIdStr + " to kill" + " from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null")));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            if (processId != null) {
                String user = this.container.getUser();
                LOG.debug((Object)("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr));
                if (this.sleepDelayBeforeSigKill > 0L) {
                    boolean result = this.exec.signalContainer(user, processId, ContainerExecutor.Signal.TERM);
                    LOG.debug((Object)("Sent signal to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed")));
                    new ContainerExecutor.DelayedProcessKiller(this.container, user, processId, this.sleepDelayBeforeSigKill, ContainerExecutor.Signal.KILL, this.exec).start();
                }
            }
        }
        catch (Exception e) {
            String message = "Exception when trying to cleanup container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.warn((Object)message);
            this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, message));
        }
        finally {
            if (this.pidFilePath != null) {
                FileContext lfs = FileContext.getLocalFSFileContext();
                lfs.delete(this.pidFilePath, false);
            }
        }
    }

    private String getContainerPid(Path pidFilePath) throws Exception {
        String containerIdStr = ConverterUtils.toString((ContainerId)this.container.getContainerId());
        String processId = null;
        LOG.debug((Object)("Accessing pid for container " + containerIdStr + " from pid file " + pidFilePath));
        int sleepCounter = 0;
        int sleepInterval = 100;
        while (!this.completed.get()) {
            processId = ProcessIdFileReader.getProcessId(pidFilePath);
            if (processId != null) {
                LOG.debug((Object)("Got pid " + processId + " for container " + containerIdStr));
                break;
            }
            if ((long)(sleepCounter * 100) > this.maxKillWaitTime) {
                LOG.info((Object)("Could not get pid for " + containerIdStr + ". Waited for " + this.maxKillWaitTime + " ms."));
                break;
            }
            ++sleepCounter;
            Thread.sleep(100L);
        }
        return processId;
    }

    public static String getRelativeContainerLogDir(String appIdStr, String containerIdStr) {
        return appIdStr + "/" + containerIdStr;
    }

    private String getContainerPrivateDir(String appIdStr, String containerIdStr) {
        return this.getAppPrivateDir(appIdStr) + "/" + containerIdStr + "/";
    }

    private String getAppPrivateDir(String appIdStr) {
        return "nmPrivate/" + appIdStr;
    }

    private static void putEnvIfNotNull(Map<String, String> environment, String variable, String value) {
        if (value != null) {
            environment.put(variable, value);
        }
    }

    private static void putEnvIfAbsent(Map<String, String> environment, String variable) {
        if (environment.get(variable) == null) {
            ContainerLaunch.putEnvIfNotNull(environment, variable, System.getenv(variable));
        }
    }

    public void sanitizeEnv(Map<String, String> environment, Path pwd, List<Path> appDirs, List<String> containerLogDirs, Map<Path, List<String>> resources) throws IOException {
        String inputClassPath;
        String[] whitelist;
        environment.put(ApplicationConstants.Environment.CONTAINER_ID.name(), this.container.getContainerId().toString());
        environment.put(ApplicationConstants.Environment.NM_PORT.name(), String.valueOf(this.context.getNodeId().getPort()));
        environment.put(ApplicationConstants.Environment.NM_HOST.name(), this.context.getNodeId().getHost());
        environment.put(ApplicationConstants.Environment.NM_HTTP_PORT.name(), String.valueOf(this.context.getHttpPort()));
        environment.put(ApplicationConstants.Environment.LOCAL_DIRS.name(), StringUtils.join((CharSequence)",", appDirs));
        environment.put(ApplicationConstants.Environment.LOG_DIRS.name(), StringUtils.join((CharSequence)",", containerLogDirs));
        environment.put(ApplicationConstants.Environment.USER.name(), this.container.getUser());
        environment.put(ApplicationConstants.Environment.LOGNAME.name(), this.container.getUser());
        environment.put(ApplicationConstants.Environment.HOME.name(), this.conf.get("yarn.nodemanager.user-home-dir", "/home/"));
        environment.put(ApplicationConstants.Environment.PWD.name(), pwd.toString());
        ContainerLaunch.putEnvIfNotNull(environment, ApplicationConstants.Environment.HADOOP_CONF_DIR.name(), System.getenv(ApplicationConstants.Environment.HADOOP_CONF_DIR.name()));
        if (!Shell.WINDOWS) {
            environment.put("JVM_PID", "$$");
        }
        for (String whitelistEnvVariable : whitelist = this.conf.get("yarn.nodemanager.env-whitelist", YarnConfiguration.DEFAULT_NM_ENV_WHITELIST).split(",")) {
            ContainerLaunch.putEnvIfAbsent(environment, whitelistEnvVariable.trim());
        }
        Apps.setEnvFromInputString(environment, (String)this.conf.get("yarn.nodemanager.admin-env", "MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX"));
        if (Shell.WINDOWS && (inputClassPath = environment.get(ApplicationConstants.Environment.CLASSPATH.name())) != null && !inputClassPath.isEmpty()) {
            StringBuilder newClassPath = new StringBuilder(inputClassPath);
            for (Map.Entry<Path, List<String>> entry : resources.entrySet()) {
                boolean targetIsDirectory = new File(entry.getKey().toUri().getPath()).isDirectory();
                for (String linkName : entry.getValue()) {
                    newClassPath.append(File.pathSeparator).append(pwd.toString()).append("/").append(linkName);
                    if (!targetIsDirectory) continue;
                    newClassPath.append("/");
                }
            }
            HashMap<String, String> mergedEnv = new HashMap<String, String>(System.getenv());
            mergedEnv.putAll(environment);
            String classPathJar = FileUtil.createJarWithClassPath((String)newClassPath.toString(), (Path)pwd, mergedEnv);
            environment.put(ApplicationConstants.Environment.CLASSPATH.name(), classPathJar);
        }
        for (Map.Entry<String, ByteBuffer> meta : this.containerManager.getAuxServiceMetaData(this.container.getContainerId()).entrySet()) {
            AuxiliaryServiceHelper.setServiceDataIntoEnv((String)meta.getKey(), (ByteBuffer)meta.getValue(), environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command) throws IOException {
        ShellScriptBuilder sb;
        ShellScriptBuilder shellScriptBuilder = sb = Shell.WINDOWS ? new WindowsShellScriptBuilder() : new UnixShellScriptBuilder();
        if (environment != null) {
            for (Map.Entry<String, Object> entry : environment.entrySet()) {
                sb.env(entry.getKey().toString(), ((String)entry.getValue()).toString());
            }
        }
        if (resources != null) {
            for (Map.Entry<String, Object> entry : resources.entrySet()) {
                for (String linkName : (List)entry.getValue()) {
                    sb.symlink((Path)entry.getKey(), new Path(linkName));
                }
            }
        }
        sb.command(command);
        PrintStream pout = null;
        try {
            pout = new PrintStream(out);
            sb.write(pout);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static final class WindowsShellScriptBuilder
    extends ShellScriptBuilder {
        public WindowsShellScriptBuilder() {
            this.line("@setlocal");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("@call ", StringUtils.join((CharSequence)" ", command));
        }

        @Override
        public void env(String key, String value) {
            this.line("@set ", key, "=", value, "\nif %errorlevel% neq 0 exit /b %errorlevel%");
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            File srcFile = new File(src.toUri().getPath());
            String srcFileStr = srcFile.getPath();
            String dstFileStr = new File(dst.toString()).getPath();
            if (!Shell.isJava7OrAbove() && srcFile.isFile()) {
                this.line(String.format("@copy \"%s\" \"%s\"", srcFileStr, dstFileStr));
            } else {
                this.line(String.format("@%s symlink \"%s\" \"%s\"", Shell.WINUTILS, dstFileStr, srcFileStr));
            }
        }

        @Override
        protected void mkdir(Path path) {
            this.line("@if not exist ", path.toString(), " mkdir ", path.toString());
        }
    }

    private static final class UnixShellScriptBuilder
    extends ShellScriptBuilder {
        public UnixShellScriptBuilder() {
            this.line("#!/bin/bash");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("exec /bin/bash -c \"", StringUtils.join((CharSequence)" ", command), "\"");
        }

        @Override
        public void env(String key, String value) {
            this.line("export ", key, "=\"", value, "\"");
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            this.line("ln -sf \"", src.toUri().getPath(), "\" \"", dst.toString(), "\"");
        }

        @Override
        protected void mkdir(Path path) {
            this.line("mkdir -p ", path.toString());
        }
    }

    private static abstract class ShellScriptBuilder {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final StringBuilder sb = new StringBuilder();

        private ShellScriptBuilder() {
        }

        public abstract void command(List<String> var1);

        public abstract void env(String var1, String var2);

        public final void symlink(Path src, Path dst) throws IOException {
            if (!src.isAbsolute()) {
                throw new IOException("Source must be absolute");
            }
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            if (dst.toUri().getPath().indexOf(47) != -1) {
                this.mkdir(dst.getParent());
            }
            this.link(src, dst);
        }

        public String toString() {
            return this.sb.toString();
        }

        public final void write(PrintStream out) throws IOException {
            out.append(this.sb);
        }

        protected final void line(String ... command) {
            for (String s : command) {
                this.sb.append(s);
            }
            this.sb.append(LINE_SEPARATOR);
        }

        protected abstract void link(Path var1, Path var2) throws IOException;

        protected abstract void mkdir(Path var1);
    }
}

