/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathPermissionException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.api.RegistryOperationsFactory;
import org.apache.hadoop.registry.client.exceptions.NoPathPermissionsException;
import org.apache.hadoop.registry.client.impl.RegistryOperationsClient;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.impl.zk.ZKPathDumper;
import org.apache.hadoop.registry.secure.AbstractSecureRegistryTest;
import org.apache.hadoop.registry.server.integration.RMRegistryOperationsService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSecureRMRegistryOperations
extends AbstractSecureRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureRMRegistryOperations.class);
    private Configuration secureConf;
    private Configuration zkClientConf;
    private UserGroupInformation zookeeperUGI;

    @Before
    public void setupTestSecureRMRegistryOperations() throws Exception {
        this.startSecureZK();
        this.secureConf = new Configuration();
        this.secureConf.setBoolean("hadoop.registry.secure", true);
        this.zkClientConf = new Configuration(this.secureZK.getConfig());
        this.zkClientConf.setBoolean("hadoop.registry.secure", true);
        TestSecureRMRegistryOperations.assertNotEmpty(this.zkClientConf.get("hadoop.registry.zk.quorum"));
        this.secureConf.set("hadoop.registry.system.accounts", "sasl:zookeeper@");
        this.zookeeperUGI = TestSecureRMRegistryOperations.loginUGI("zookeeper", keytab_zk);
    }

    @After
    public void teardownTestSecureRMRegistryOperations() {
    }

    public RMRegistryOperationsService startRMRegistryOperations() throws LoginException, IOException, InterruptedException {
        this.secureConf.set("hadoop.registry.client.auth", "kerberos");
        this.secureConf.set("hadoop.registry.jaas.context", "zookeeper");
        RMRegistryOperationsService registryOperations = (RMRegistryOperationsService)this.zookeeperUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RMRegistryOperationsService>(){

            @Override
            public RMRegistryOperationsService run() throws Exception {
                RMRegistryOperationsService operations = new RMRegistryOperationsService("rmregistry", (RegistryBindingSource)TestSecureRMRegistryOperations.this.secureZK);
                TestSecureRMRegistryOperations.this.addToTeardown((Service)operations);
                operations.init(TestSecureRMRegistryOperations.this.secureConf);
                LOG.info(operations.bindingDiagnosticDetails());
                operations.start();
                return operations;
            }
        });
        return registryOperations;
    }

    @Test
    public void testZookeeperCanWriteUnderSystem() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations;
        RMRegistryOperationsService operations = rmRegistryOperations = this.startRMRegistryOperations();
        operations.mknode("/services/hdfs", false);
        ZKPathDumper pathDumper = rmRegistryOperations.dumpPath(true);
        LOG.info(pathDumper.toString());
    }

    @Test
    public void testAnonReadAccess() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations = this.startRMRegistryOperations();
        TestSecureRMRegistryOperations.describe(LOG, "testAnonReadAccess", new Object[0]);
        RegistryOperations operations = RegistryOperationsFactory.createAnonymousInstance((Configuration)this.zkClientConf);
        this.addToTeardown((Service)operations);
        operations.start();
        TestSecureRMRegistryOperations.assertFalse((String)"RegistrySecurity.isClientSASLEnabled()==true", (boolean)RegistrySecurity.isClientSASLEnabled());
        operations.list("/services/");
    }

    @Test
    public void testAnonNoWriteAccess() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations = this.startRMRegistryOperations();
        TestSecureRMRegistryOperations.describe(LOG, "testAnonNoWriteAccess", new Object[0]);
        RegistryOperations operations = RegistryOperationsFactory.createAnonymousInstance((Configuration)this.zkClientConf);
        this.addToTeardown((Service)operations);
        operations.start();
        String servicePath = "/services/hdfs";
        this.expectMkNodeFailure(operations, servicePath);
    }

    @Test
    public void testAnonNoWriteAccessOffRoot() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations = this.startRMRegistryOperations();
        TestSecureRMRegistryOperations.describe(LOG, "testAnonNoWriteAccessOffRoot", new Object[0]);
        RegistryOperations operations = RegistryOperationsFactory.createAnonymousInstance((Configuration)this.zkClientConf);
        this.addToTeardown((Service)operations);
        operations.start();
        TestSecureRMRegistryOperations.assertFalse((String)"mknode(/)", (boolean)operations.mknode("/", false));
        this.expectMkNodeFailure(operations, "/sub");
        this.expectDeleteFailure(operations, "/services/", true);
    }

    public void expectMkNodeFailure(RegistryOperations operations, String path) throws IOException {
        try {
            operations.mknode(path, false);
            TestSecureRMRegistryOperations.fail((String)("should have failed to create a node under " + path));
        }
        catch (PathPermissionException expected) {
        }
        catch (NoPathPermissionsException noPathPermissionsException) {
            // empty catch block
        }
    }

    public void expectDeleteFailure(RegistryOperations operations, String path, boolean recursive) throws IOException {
        try {
            operations.delete(path, recursive);
            TestSecureRMRegistryOperations.fail((String)("should have failed to delete the node " + path));
        }
        catch (PathPermissionException expected) {
        }
        catch (NoPathPermissionsException expected) {
            // empty catch block
        }
    }

    @Test
    public void testAlicePathRestrictedAnonAccess() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations = this.startRMRegistryOperations();
        String aliceHome = rmRegistryOperations.initUserRegistry("alice");
        TestSecureRMRegistryOperations.describe(LOG, "Creating anonymous accessor", new Object[0]);
        RegistryOperations anonOperations = RegistryOperationsFactory.createAnonymousInstance((Configuration)this.zkClientConf);
        this.addToTeardown((Service)anonOperations);
        anonOperations.start();
        anonOperations.list(aliceHome);
        this.expectMkNodeFailure(anonOperations, aliceHome + "/anon");
        this.expectDeleteFailure(anonOperations, aliceHome, true);
    }

    @Test
    public void testUserZookeeperHomePathAccess() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations = this.startRMRegistryOperations();
        String home = rmRegistryOperations.initUserRegistry("zookeeper");
        TestSecureRMRegistryOperations.describe(LOG, "Creating ZK client", new Object[0]);
        RegistryOperations operations = (RegistryOperations)this.zookeeperUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegistryOperations>(){

            @Override
            public RegistryOperations run() throws Exception {
                RegistryOperations operations = RegistryOperationsFactory.createKerberosInstance((Configuration)TestSecureRMRegistryOperations.this.zkClientConf, (String)"zookeeper");
                TestSecureRMRegistryOperations.this.addToTeardown((Service)operations);
                operations.start();
                return operations;
            }
        });
        operations.list(home);
        String path = home + "/subpath";
        operations.mknode(path, false);
        operations.delete(path, true);
    }

    @Test
    public void testUserHomedirsPermissionsRestricted() throws Throwable {
        RMRegistryOperationsService rmRegistryOperations = this.startRMRegistryOperations();
        String home = rmRegistryOperations.initUserRegistry("alice");
        List acls = rmRegistryOperations.zkGetACLS(home);
        ACL aliceACL = null;
        for (ACL acl : acls) {
            LOG.info(RegistrySecurity.aclToString((ACL)acl));
            Id id = acl.getId();
            if (!id.getScheme().equals("sasl") || !id.getId().startsWith("alice")) continue;
            aliceACL = acl;
            break;
        }
        TestSecureRMRegistryOperations.assertNotNull(aliceACL);
        TestSecureRMRegistryOperations.assertEquals((long)15L, (long)aliceACL.getPerms());
    }

    @Test
    public void testDigestAccess() throws Throwable {
        RMRegistryOperationsService registryAdmin = this.startRMRegistryOperations();
        String id = "username";
        String pass = "password";
        registryAdmin.addWriteAccessor(id, pass);
        List clientAcls = registryAdmin.getClientAcls();
        LOG.info("Client ACLS=\n{}", (Object)RegistrySecurity.aclsToString((List)clientAcls));
        String base = "/digested";
        registryAdmin.mknode(base, false);
        List baseACLs = registryAdmin.zkGetACLS(base);
        String aclset = RegistrySecurity.aclsToString((List)baseACLs);
        LOG.info("Base ACLs=\n{}", (Object)aclset);
        ACL found = null;
        for (ACL acl : baseACLs) {
            if (!"digest".equals(acl.getId().getScheme())) continue;
            found = acl;
            break;
        }
        TestSecureRMRegistryOperations.assertNotNull((String)("Did not find digest entry in ACLs " + aclset), found);
        this.zkClientConf.set("hadoop.registry.user.accounts", "sasl:somebody@EXAMPLE.COM, sasl:other");
        RegistryOperations operations = RegistryOperationsFactory.createAuthenticatedInstance((Configuration)this.zkClientConf, (String)id, (String)pass);
        this.addToTeardown((Service)operations);
        operations.start();
        RegistryOperationsClient operationsClient = (RegistryOperationsClient)operations;
        List digestClientACLs = operationsClient.getClientAcls();
        LOG.info("digest client ACLs=\n{}", (Object)RegistrySecurity.aclsToString((List)digestClientACLs));
        operations.stat(base);
        operations.mknode(base + "/subdir", false);
        ZKPathDumper pathDumper = registryAdmin.dumpPath(true);
        LOG.info(pathDumper.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoDigestAuthMissingId() throws Throwable {
        RegistryOperationsFactory.createAuthenticatedInstance((Configuration)this.zkClientConf, (String)"", (String)"pass");
    }

    @Test(expected=ServiceStateException.class)
    public void testNoDigestAuthMissingId2() throws Throwable {
        this.zkClientConf.set("hadoop.registry.client.auth", "digest");
        this.zkClientConf.set("hadoop.registry.client.auth.id", "");
        this.zkClientConf.set("hadoop.registry.client.auth.password", "pass");
        RegistryOperationsFactory.createInstance((String)"DigestRegistryOperations", (Configuration)this.zkClientConf);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoDigestAuthMissingPass() throws Throwable {
        RegistryOperationsFactory.createAuthenticatedInstance((Configuration)this.zkClientConf, (String)"id", (String)"");
    }

    @Test(expected=ServiceStateException.class)
    public void testNoDigestAuthMissingPass2() throws Throwable {
        this.zkClientConf.set("hadoop.registry.client.auth", "digest");
        this.zkClientConf.set("hadoop.registry.client.auth.id", "id");
        this.zkClientConf.set("hadoop.registry.client.auth.password", "");
        RegistryOperationsFactory.createInstance((String)"DigestRegistryOperations", (Configuration)this.zkClientConf);
    }
}

