/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.integration;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.registry.AbstractRegistryTest;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.impl.CuratorEventCatcher;
import org.apache.hadoop.registry.client.impl.zk.ZKPathDumper;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.services.DeleteCompletionCallback;
import org.apache.hadoop.registry.server.services.RegistryAdminService;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegistryRMOperations
extends AbstractRegistryTest {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRegistryRMOperations.class);

    public int purge(String path, String id, String policyMatch, RegistryAdminService.PurgePolicy purgePolicy) throws IOException, ExecutionException, InterruptedException {
        return this.purge(path, id, policyMatch, purgePolicy, null);
    }

    public int purge(String path, String id, String policyMatch, RegistryAdminService.PurgePolicy purgePolicy, BackgroundCallback callback) throws IOException, ExecutionException, InterruptedException {
        Future future = this.registry.purgeRecordsAsync(path, id, policyMatch, purgePolicy, callback);
        try {
            return (Integer)future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Test
    public void testPurgeEntryCuratorCallback() throws Throwable {
        String path = "/users/example/hbase/hbase1/";
        ServiceRecord written = TestRegistryRMOperations.buildExampleServiceEntry("application-attempt");
        written.set("yarn:id", (Object)"testAsyncPurgeEntry_attempt_001");
        this.operations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.operations.bind(path, written, 0);
        ZKPathDumper dump = this.registry.dumpPath(false);
        CuratorEventCatcher events = new CuratorEventCatcher();
        LOG.info("Initial state {}", (Object)dump);
        String id = written.get("yarn:id", "");
        int opcount = this.purge("/", id, "container", RegistryAdminService.PurgePolicy.PurgeAll, events);
        this.assertPathExists(path);
        TestRegistryRMOperations.assertEquals((long)0L, (long)opcount);
        TestRegistryRMOperations.assertEquals((String)"Event counter", (long)0L, (long)events.getCount());
        opcount = this.purge("/", id, "application-attempt", RegistryAdminService.PurgePolicy.PurgeAll, events);
        LOG.info("Final state {}", (Object)dump);
        this.assertPathNotFound(path);
        TestRegistryRMOperations.assertEquals((String)("wrong no of delete operations in " + dump), (long)1L, (long)opcount);
        TestRegistryRMOperations.assertEquals((String)"Event counter", (long)1L, (long)events.getCount());
    }

    @Test
    public void testAsyncPurgeEntry() throws Throwable {
        String path = "/users/example/hbase/hbase1/";
        ServiceRecord written = TestRegistryRMOperations.buildExampleServiceEntry("application-attempt");
        written.set("yarn:id", (Object)"testAsyncPurgeEntry_attempt_001");
        this.operations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.operations.bind(path, written, 0);
        ZKPathDumper dump = this.registry.dumpPath(false);
        LOG.info("Initial state {}", (Object)dump);
        DeleteCompletionCallback deletions = new DeleteCompletionCallback();
        int opcount = this.purge("/", written.get("yarn:id", ""), "container", RegistryAdminService.PurgePolicy.PurgeAll, (BackgroundCallback)deletions);
        this.assertPathExists(path);
        dump = this.registry.dumpPath(false);
        TestRegistryRMOperations.assertEquals((String)("wrong no of delete operations in " + dump), (long)0L, (long)deletions.getEventCount());
        TestRegistryRMOperations.assertEquals((String)("wrong no of delete operations in " + dump), (long)0L, (long)opcount);
        deletions = new DeleteCompletionCallback();
        opcount = this.purge("/", written.get("yarn:id", ""), "application-attempt", RegistryAdminService.PurgePolicy.PurgeAll, (BackgroundCallback)deletions);
        dump = this.registry.dumpPath(false);
        LOG.info("Final state {}", (Object)dump);
        this.assertPathNotFound(path);
        TestRegistryRMOperations.assertEquals((String)("wrong no of delete operations in " + dump), (long)1L, (long)deletions.getEventCount());
        TestRegistryRMOperations.assertEquals((String)("wrong no of delete operations in " + dump), (long)1L, (long)opcount);
    }

    @Test
    public void testPutGetContainerPersistenceServiceEntry() throws Throwable {
        String path = "/users/devteam/org-apache-hadoop/hdfs";
        ServiceRecord written = TestRegistryRMOperations.buildExampleServiceEntry("container");
        this.operations.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.operations.bind(path, written, 0);
        ServiceRecord resolved = this.operations.resolve(path);
        TestRegistryRMOperations.validateEntry(resolved);
        TestRegistryRMOperations.assertMatches(written, resolved);
    }

    @Test
    public void testCreateComplexApplication() throws Throwable {
        String appId = "application_1408631738011_0001";
        String cid = "container_1408631738011_0001_01_";
        String cid1 = cid + "000001";
        String cid2 = cid + "000002";
        String appPath = "/users/devteam/tomcat";
        ServiceRecord webapp = TestRegistryRMOperations.createRecord(appId, "application", "tomcat-based web application", null);
        webapp.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"www", (URI[])new URI[]{new URI("http", "//loadbalancer/", null)}));
        ServiceRecord comp1 = TestRegistryRMOperations.createRecord(cid1, "container", null, null);
        comp1.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"www", (URI[])new URI[]{new URI("http", "//rack4server3:43572", null)}));
        comp1.addInternalEndpoint(RegistryTypeUtils.inetAddrEndpoint((String)"jmx", (String)"JMX", (String)"rack4server3", (int)43573));
        ServiceRecord comp2 = TestRegistryRMOperations.createRecord(cid2, "container", null, null);
        comp2.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"www", (URI[])new URI[]{new URI("http", "//rack1server28:35881", null)}));
        comp2.addInternalEndpoint(RegistryTypeUtils.inetAddrEndpoint((String)"jmx", (String)"JMX", (String)"rack1server28", (int)35882));
        this.operations.mknode("/users/devteam/", false);
        this.operations.bind(appPath, webapp, 1);
        String componentsPath = appPath + "/components/";
        this.operations.mknode(componentsPath, false);
        String dns1 = RegistryPathUtils.encodeYarnID((String)cid1);
        String dns1path = componentsPath + dns1;
        this.operations.bind(dns1path, comp1, 0);
        String dns2 = RegistryPathUtils.encodeYarnID((String)cid2);
        String dns2path = componentsPath + dns2;
        this.operations.bind(dns2path, comp2, 0);
        ZKPathDumper pathDumper = this.registry.dumpPath(false);
        LOG.info(pathDumper.toString());
        TestRegistryRMOperations.logRecord("tomcat", webapp);
        TestRegistryRMOperations.logRecord(dns1, comp1);
        TestRegistryRMOperations.logRecord(dns2, comp2);
        ServiceRecord dns1resolved = this.operations.resolve(dns1path);
        TestRegistryRMOperations.assertEquals((String)"Persistence policies on resolved entry", (Object)"container", (Object)dns1resolved.get("yarn:persistence", ""));
        Map children = RegistryUtils.statChildren((RegistryOperations)this.operations, (String)componentsPath);
        TestRegistryRMOperations.assertEquals((long)2L, (long)children.size());
        Collection componentStats = children.values();
        Map records = RegistryUtils.extractServiceRecords((RegistryOperations)this.operations, (String)componentsPath, componentStats);
        TestRegistryRMOperations.assertEquals((long)2L, (long)records.size());
        ServiceRecord retrieved1 = (ServiceRecord)records.get(dns1path);
        TestRegistryRMOperations.logRecord(retrieved1.get("yarn:id", ""), retrieved1);
        TestRegistryRMOperations.assertMatches(dns1resolved, retrieved1);
        TestRegistryRMOperations.assertEquals((Object)"container", (Object)retrieved1.get("yarn:persistence", ""));
        this.operations.mknode(componentsPath + "subdir", false);
        Map childrenUpdated = RegistryUtils.statChildren((RegistryOperations)this.operations, (String)componentsPath);
        TestRegistryRMOperations.assertEquals((long)3L, (long)childrenUpdated.size());
        Map recordsUpdated = RegistryUtils.extractServiceRecords((RegistryOperations)this.operations, (String)componentsPath, (Map)childrenUpdated);
        TestRegistryRMOperations.assertEquals((long)2L, (long)recordsUpdated.size());
        TestRegistryRMOperations.assertEquals((long)0L, (long)this.purge("/", cid2, "application", RegistryAdminService.PurgePolicy.FailOnChildren));
        TestRegistryRMOperations.assertEquals((long)1L, (long)this.purge("/", cid2, "container", RegistryAdminService.PurgePolicy.FailOnChildren));
        this.assertPathNotFound(dns2path);
        this.assertPathExists(dns1path);
        TestRegistryRMOperations.assertEquals((long)0L, (long)this.purge("/", appId, "application", RegistryAdminService.PurgePolicy.SkipOnChildren));
        this.assertPathExists(appPath);
        this.assertPathExists(dns1path);
        try {
            int p = this.purge("/", appId, "application", RegistryAdminService.PurgePolicy.FailOnChildren);
            TestRegistryRMOperations.fail((String)("expected a failure, got a purge count of " + p));
        }
        catch (PathIsNotEmptyDirectoryException expected) {
            // empty catch block
        }
        this.assertPathExists(appPath);
        this.assertPathExists(dns1path);
        TestRegistryRMOperations.assertEquals((long)1L, (long)this.purge("/", appId, "application", RegistryAdminService.PurgePolicy.PurgeAll));
        this.assertPathNotFound(appPath);
        this.assertPathNotFound(dns1path);
    }

    @Test
    public void testChildDeletion() throws Throwable {
        ServiceRecord app = TestRegistryRMOperations.createRecord("app1", "application", "app", null);
        ServiceRecord container = TestRegistryRMOperations.createRecord("container1", "container", "container", null);
        this.operations.bind("/app", app, 1);
        this.operations.bind("/app/container", container, 1);
        try {
            int p = this.purge("/", "app1", "application", RegistryAdminService.PurgePolicy.FailOnChildren);
            TestRegistryRMOperations.fail((String)("expected a failure, got a purge count of " + p));
        }
        catch (PathIsNotEmptyDirectoryException pathIsNotEmptyDirectoryException) {
            // empty catch block
        }
    }
}

