/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.AbstractZKRegistryTest;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.integration.RMRegistryOperationsService;
import org.apache.hadoop.service.Service;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRegistryTest
extends AbstractZKRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegistryTest.class);
    protected RMRegistryOperationsService registry;
    protected RegistryOperations operations;

    @Before
    public void setupRegistry() throws IOException {
        this.registry = new RMRegistryOperationsService("yarnRegistry");
        this.operations = this.registry;
        this.registry.init((Configuration)this.createRegistryConfiguration());
        this.registry.start();
        this.operations.delete("/", true);
        this.registry.createRootRegistryPaths();
        AbstractRegistryTest.addToTeardown((Service)this.registry);
    }

    protected ServiceRecord putExampleServiceEntry(String path, int createFlags) throws IOException, URISyntaxException {
        return this.putExampleServiceEntry(path, createFlags, "permanent");
    }

    protected ServiceRecord putExampleServiceEntry(String path, int createFlags, String persistence) throws IOException, URISyntaxException {
        ServiceRecord record = AbstractRegistryTest.buildExampleServiceEntry(persistence);
        this.registry.mknode(RegistryPathUtils.parentOf((String)path), true);
        this.operations.bind(path, record, createFlags);
        return record;
    }

    public void assertPathExists(String path) throws IOException {
        this.operations.stat(path);
    }

    public void assertPathNotFound(String path) throws IOException {
        try {
            this.operations.stat(path);
            AbstractRegistryTest.fail((String)("Path unexpectedly found: " + path));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void assertResolves(String path) throws IOException {
        this.operations.resolve(path);
    }
}

