/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.impl.zk.CuratorService;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.impl.zk.ZKPathDumper;
import org.apache.hadoop.registry.secure.AbstractSecureRegistryTest;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.server.auth.SaslServerCallbackHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestSecureRegistry
extends AbstractSecureRegistryTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureRegistry.class);

    @Before
    public void beforeTestSecureZKService() throws Throwable {
        TestSecureRegistry.enableKerberosDebugging();
    }

    @After
    public void afterTestSecureZKService() throws Throwable {
        TestSecureRegistry.disableKerberosDebugging();
        RegistrySecurity.clearZKSaslClientProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLowlevelZKSaslLogin() throws Throwable {
        RegistrySecurity.bindZKToServerJAASContext((String)"ZOOKEEPER_SERVER");
        String serverSection = System.getProperty("zookeeper.sasl.serverconfig", "Server");
        TestSecureRegistry.assertEquals((Object)"ZOOKEEPER_SERVER", (Object)serverSection);
        AppConfigurationEntry[] entries = javax.security.auth.login.Configuration.getConfiguration().getAppConfigurationEntry(serverSection);
        TestSecureRegistry.assertNotNull((String)"null entries", (Object)entries);
        SaslServerCallbackHandler saslServerCallbackHandler = new SaslServerCallbackHandler(javax.security.auth.login.Configuration.getConfiguration());
        Login login = new Login(serverSection, (CallbackHandler)saslServerCallbackHandler);
        try {
            login.startThreadIfNeeded();
        }
        finally {
            login.shutdown();
        }
    }

    @Test
    public void testCreateSecureZK() throws Throwable {
        this.startSecureZK();
        this.secureZK.stop();
    }

    @Test
    public void testInsecureClientToZK() throws Throwable {
        this.startSecureZK();
        this.userZookeeperToCreateRoot();
        RegistrySecurity.clearZKSaslClientProperties();
        CuratorService curatorService = this.startCuratorServiceInstance("insecure client", false);
        curatorService.zkList("/");
        curatorService.zkMkPath("", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZookeeperCanWrite() throws Throwable {
        System.setProperty("curator-log-events", "true");
        this.startSecureZK();
        CuratorService curator = null;
        LoginContext login = this.login("zookeeper/localhost", "zookeeper", keytab_zk);
        try {
            TestSecureRegistry.logLoginDetails((String)"zookeeper", (LoginContext)login);
            RegistrySecurity.setZKSaslClientProperties((String)"zookeeper", (String)"zookeeper");
            curator = this.startCuratorServiceInstance("ZK", true);
            LOG.info(curator.toString());
            this.addToTeardown((Service)curator);
            curator.zkMkPath("/", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
            curator.zkList("/");
            curator.zkMkPath("/zookeeper", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
        }
        catch (Throwable throwable) {
            TestSecureRegistry.logout((LoginContext)login);
            ServiceOperations.stop(curator);
            throw throwable;
        }
        TestSecureRegistry.logout((LoginContext)login);
        ServiceOperations.stop((Service)curator);
    }

    protected CuratorService startCuratorServiceInstance(String name, boolean secure) {
        Configuration clientConf = new Configuration();
        clientConf.set("hadoop.registry.zk.root", "/");
        clientConf.setBoolean("hadoop.registry.secure", secure);
        TestSecureRegistry.describe((Logger)LOG, (String)"Starting Curator service", (Object[])new Object[0]);
        CuratorService curatorService = new CuratorService(name, (RegistryBindingSource)this.secureZK);
        curatorService.init(clientConf);
        curatorService.start();
        LOG.info("Curator Binding {}", (Object)curatorService.bindingDiagnosticDetails());
        return curatorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userZookeeperToCreateRoot() throws Throwable {
        System.setProperty("curator-log-events", "true");
        CuratorService curator = null;
        LoginContext login = this.login("zookeeper/localhost", "zookeeper", keytab_zk);
        try {
            TestSecureRegistry.logLoginDetails((String)"zookeeper", (LoginContext)login);
            RegistrySecurity.setZKSaslClientProperties((String)"zookeeper", (String)"zookeeper");
            curator = this.startCuratorServiceInstance("ZK", true);
            LOG.info(curator.toString());
            this.addToTeardown((Service)curator);
            curator.zkMkPath("/", CreateMode.PERSISTENT, false, RegistrySecurity.WorldReadWriteACL);
            ZKPathDumper pathDumper = curator.dumpPath(true);
            LOG.info(pathDumper.toString());
        }
        catch (Throwable throwable) {
            TestSecureRegistry.logout((LoginContext)login);
            ServiceOperations.stop(curator);
            throw throwable;
        }
        TestSecureRegistry.logout((LoginContext)login);
        ServiceOperations.stop((Service)curator);
    }
}

