/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRegistryPathUtils
extends Assert {
    public static final String EURO = "\u20ac";

    @Test
    public void testFormatAscii() throws Throwable {
        String in = "hostname01101101-1";
        this.assertConverted(in, in);
    }

    @Test
    public void testFormatEuroSymbol() throws Throwable {
        this.assertConverted("xn--lzg", "\u20ac");
    }

    @Test
    public void testFormatIdempotent() throws Throwable {
        this.assertConverted("xn--lzg", RegistryPathUtils.encodeForRegistry((String)"\u20ac"));
    }

    @Test
    public void testFormatCyrillicSpaced() throws Throwable {
        this.assertConverted("xn--pa 3-k4di", "\u0413PA\u0414 3");
    }

    protected void assertConverted(String expected, String in) {
        String out = RegistryPathUtils.encodeForRegistry((String)in);
        TestRegistryPathUtils.assertEquals((String)("Conversion of " + in), (Object)expected, (Object)out);
    }

    @Test
    public void testPaths() throws Throwable {
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/", (String)"/", (String)"");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/", (String)"", (String)"");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/", (String)"", (String)"/");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/", (String)"/", (String)"/");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a", (String)"/a", (String)"");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a", (String)"/", (String)"a");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a/b", (String)"/a", (String)"b");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a/b", (String)"/a/", (String)"b");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a/b", (String)"/a", (String)"/b");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a/b", (String)"/a", (String)"/b/");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/a", (String)"/a", (String)"/");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/alice", (String)"/", (String)"/alice");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/alice", (String)"/alice", (String)"/");
    }

    @Test
    public void testComplexPaths() throws Throwable {
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/", (String)"", (String)"");
        TestRegistryPathUtils.assertCreatedPathEquals((String)"/yarn/registry/users/hadoop/org-apache-hadoop", (String)"/yarn/registry", (String)"users/hadoop/org-apache-hadoop/");
    }

    private static void assertCreatedPathEquals(String expected, String base, String path) throws IOException {
        String fullPath = RegistryPathUtils.createFullPath((String)base, (String)path);
        TestRegistryPathUtils.assertEquals((String)("\"" + base + "\" + \"" + path + "\" =\"" + fullPath + "\""), (Object)expected, (Object)fullPath);
    }

    @Test
    public void testSplittingEmpty() throws Throwable {
        TestRegistryPathUtils.assertEquals((long)0L, (long)RegistryPathUtils.split((String)"").size());
        TestRegistryPathUtils.assertEquals((long)0L, (long)RegistryPathUtils.split((String)"/").size());
        TestRegistryPathUtils.assertEquals((long)0L, (long)RegistryPathUtils.split((String)"///").size());
    }

    @Test
    public void testSplitting() throws Throwable {
        TestRegistryPathUtils.assertEquals((long)1L, (long)RegistryPathUtils.split((String)"/a").size());
        TestRegistryPathUtils.assertEquals((long)0L, (long)RegistryPathUtils.split((String)"/").size());
        TestRegistryPathUtils.assertEquals((long)3L, (long)RegistryPathUtils.split((String)"/a/b/c").size());
        TestRegistryPathUtils.assertEquals((long)3L, (long)RegistryPathUtils.split((String)"/a/b/c/").size());
        TestRegistryPathUtils.assertEquals((long)3L, (long)RegistryPathUtils.split((String)"a/b/c").size());
        TestRegistryPathUtils.assertEquals((long)3L, (long)RegistryPathUtils.split((String)"/a/b//c").size());
        TestRegistryPathUtils.assertEquals((long)3L, (long)RegistryPathUtils.split((String)"//a/b/c/").size());
        List split = RegistryPathUtils.split((String)"//a/b/c/");
        TestRegistryPathUtils.assertEquals((Object)"a", split.get(0));
        TestRegistryPathUtils.assertEquals((Object)"b", split.get(1));
        TestRegistryPathUtils.assertEquals((Object)"c", split.get(2));
    }

    @Test
    public void testParentOf() throws Throwable {
        TestRegistryPathUtils.assertEquals((Object)"/", (Object)RegistryPathUtils.parentOf((String)"/a"));
        TestRegistryPathUtils.assertEquals((Object)"/", (Object)RegistryPathUtils.parentOf((String)"/a/"));
        TestRegistryPathUtils.assertEquals((Object)"/a", (Object)RegistryPathUtils.parentOf((String)"/a/b"));
        TestRegistryPathUtils.assertEquals((Object)"/a/b", (Object)RegistryPathUtils.parentOf((String)"/a/b/c"));
    }

    @Test
    public void testLastPathEntry() throws Throwable {
        TestRegistryPathUtils.assertEquals((Object)"", (Object)RegistryPathUtils.lastPathEntry((String)"/"));
        TestRegistryPathUtils.assertEquals((Object)"", (Object)RegistryPathUtils.lastPathEntry((String)"//"));
        TestRegistryPathUtils.assertEquals((Object)"c", (Object)RegistryPathUtils.lastPathEntry((String)"/a/b/c"));
        TestRegistryPathUtils.assertEquals((Object)"c", (Object)RegistryPathUtils.lastPathEntry((String)"/a/b/c/"));
    }

    @Test(expected=PathNotFoundException.class)
    public void testParentOfRoot() throws Throwable {
        RegistryPathUtils.parentOf((String)"/");
    }

    @Test
    public void testValidPaths() throws Throwable {
        this.assertValidPath("/");
        this.assertValidPath("/a/b/c");
        this.assertValidPath("/users/drwho/org-apache-hadoop/registry/appid-55-55");
        this.assertValidPath("/a50");
    }

    @Test
    public void testInvalidPaths() throws Throwable {
        this.assertInvalidPath("/a_b");
        this.assertInvalidPath("/UpperAndLowerCase");
        this.assertInvalidPath("/space in string");
    }

    private void assertValidPath(String path) throws InvalidPathnameException {
        RegistryPathUtils.validateZKPath((String)path);
    }

    private void assertInvalidPath(String path) throws InvalidPathnameException {
        try {
            RegistryPathUtils.validateElementsAsDNS((String)path);
            TestRegistryPathUtils.fail((String)("path considered valid: " + path));
        }
        catch (InvalidPathnameException invalidPathnameException) {
            // empty catch block
        }
    }
}

