/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import org.apache.hadoop.registry.RegistryTestHelper;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMarshalling
extends RegistryTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TestMarshalling.class);
    @Rule
    public final Timeout testTimeout = new Timeout(10000);
    @Rule
    public TestName methodName = new TestName();
    private static RegistryUtils.ServiceRecordMarshal marshal;

    @BeforeClass
    public static void setupClass() {
        marshal = new RegistryUtils.ServiceRecordMarshal();
    }

    @Test
    public void testRoundTrip() throws Throwable {
        String persistence = "permanent";
        ServiceRecord record = TestMarshalling.createRecord((String)persistence);
        record.set("customkey", (Object)"customvalue");
        record.set("customkey2", (Object)"customvalue2");
        RegistryTypeUtils.validateServiceRecord((String)"", (ServiceRecord)record);
        LOG.info(marshal.toJson((Object)record));
        byte[] bytes = marshal.toBytes((Object)record);
        ServiceRecord r2 = (ServiceRecord)marshal.fromBytes("", bytes);
        TestMarshalling.assertMatches((ServiceRecord)record, (ServiceRecord)r2);
        RegistryTypeUtils.validateServiceRecord((String)"", (ServiceRecord)r2);
    }

    @Test(expected=NoRecordException.class)
    public void testUnmarshallNoData() throws Throwable {
        marshal.fromBytes("src", new byte[0]);
    }

    @Test(expected=NoRecordException.class)
    public void testUnmarshallNotEnoughData() throws Throwable {
        marshal.fromBytes("src", new byte[]{123, 125}, "JSONServiceRecord");
    }

    @Test(expected=InvalidRecordException.class)
    public void testUnmarshallNoBody() throws Throwable {
        byte[] bytes = "this is not valid JSON at all and should fail".getBytes();
        marshal.fromBytes("src", bytes);
    }

    @Test(expected=InvalidRecordException.class)
    public void testUnmarshallWrongType() throws Throwable {
        byte[] bytes = "{'type':''}".getBytes();
        ServiceRecord serviceRecord = (ServiceRecord)marshal.fromBytes("marshalling", bytes);
        RegistryTypeUtils.validateServiceRecord((String)"validating", (ServiceRecord)serviceRecord);
    }

    @Test(expected=NoRecordException.class)
    public void testUnmarshallWrongLongType() throws Throwable {
        ServiceRecord record = new ServiceRecord();
        record.type = "ThisRecordHasALongButNonMatchingType";
        byte[] bytes = marshal.toBytes((Object)record);
        ServiceRecord serviceRecord = (ServiceRecord)marshal.fromBytes("marshalling", bytes, "JSONServiceRecord");
    }

    @Test(expected=NoRecordException.class)
    public void testUnmarshallNoType() throws Throwable {
        ServiceRecord record = new ServiceRecord();
        record.type = "NoRecord";
        byte[] bytes = marshal.toBytes((Object)record);
        ServiceRecord serviceRecord = (ServiceRecord)marshal.fromBytes("marshalling", bytes, "JSONServiceRecord");
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecordValidationWrongType() throws Throwable {
        ServiceRecord record = new ServiceRecord();
        record.type = "NotAServiceRecordType";
        RegistryTypeUtils.validateServiceRecord((String)"validating", (ServiceRecord)record);
    }

    @Test
    public void testUnknownFieldsRoundTrip() throws Throwable {
        ServiceRecord record = TestMarshalling.createRecord((String)"application-attempt");
        record.set("key", (Object)"value");
        record.set("intval", (Object)"2");
        TestMarshalling.assertEquals((Object)"value", (Object)record.get("key"));
        TestMarshalling.assertEquals((Object)"2", (Object)record.get("intval"));
        TestMarshalling.assertNull((Object)record.get("null"));
        TestMarshalling.assertEquals((Object)"defval", (Object)record.get("null", "defval"));
        byte[] bytes = marshal.toBytes((Object)record);
        ServiceRecord r2 = (ServiceRecord)marshal.fromBytes("", bytes);
        TestMarshalling.assertEquals((Object)"value", (Object)r2.get("key"));
        TestMarshalling.assertEquals((Object)"2", (Object)r2.get("intval"));
    }

    @Test
    public void testFieldPropagationInCopy() throws Throwable {
        ServiceRecord record = TestMarshalling.createRecord((String)"application-attempt");
        record.set("key", (Object)"value");
        record.set("intval", (Object)"2");
        ServiceRecord that = new ServiceRecord(record);
        TestMarshalling.assertMatches((ServiceRecord)record, (ServiceRecord)that);
    }
}

