/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.AbstractRegistryTest;
import org.apache.hadoop.registry.cli.RegistryCli;
import org.apache.hadoop.registry.operations.TestRegistryOperations;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRegistryCli
extends AbstractRegistryTest {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRegistryOperations.class);
    private ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    private ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;
    private RegistryCli cli;

    @Before
    public void setUp() throws Exception {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = new PrintStream(this.sysOutStream);
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = new PrintStream(this.sysErrStream);
        System.setOut(this.sysOut);
        this.cli = new RegistryCli(this.operations, (Configuration)this.createRegistryConfiguration(), this.sysOut, this.sysErr);
    }

    @After
    public void tearDown() throws Exception {
        this.cli.close();
    }

    private void assertResult(RegistryCli cli, int code, String ... args) throws Exception {
        int result = cli.run(args);
        TestRegistryCli.assertEquals((long)code, (long)result);
    }

    @Test
    public void testBadCommands() throws Exception {
        this.assertResult(this.cli, -1, new String[0]);
        this.assertResult(this.cli, -1, new String[]{"foo"});
    }

    @Test
    public void testInvalidNumArgs() throws Exception {
        this.assertResult(this.cli, -1, new String[]{"ls"});
        this.assertResult(this.cli, -1, new String[]{"ls", "/path", "/extraPath"});
        this.assertResult(this.cli, -1, new String[]{"resolve"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/path", "/extraPath"});
        this.assertResult(this.cli, -1, new String[]{"mknode"});
        this.assertResult(this.cli, -1, new String[]{"mknode", "/path", "/extraPath"});
        this.assertResult(this.cli, -1, new String[]{"rm"});
        this.assertResult(this.cli, -1, new String[]{"rm", "/path", "/extraPath"});
        this.assertResult(this.cli, -1, new String[]{"bind"});
        this.assertResult(this.cli, -1, new String[]{"bind", "foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "-p", "378", "-h", "host", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "-h", "host", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-api", "Api", "-p", "378", "-h", "host", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "-api", "Api", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "uriString", "-api", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "uriString", "-api", "Api"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "uriString", "-api", "Api"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "-api", "Api", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "uriString", "-api", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"bind", "uriString", "-api", "Api", "/foo"});
    }

    @Test
    public void testBadArgType() throws Exception {
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "fooPort", "-h", "host", "/dir"});
    }

    @Test
    public void testBadPath() throws Exception {
        this.assertResult(this.cli, -1, new String[]{"ls", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"ls", "//"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "//"});
        this.assertResult(this.cli, -1, new String[]{"mknode", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"mknode", "//"});
        this.assertResult(this.cli, -1, new String[]{"rm", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"rm", "//"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "//"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "uriString", "-api", "Api", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "uriString", "-api", "Api", "//"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "uriString", "-api", "Api", "NonSlashPath"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "uriString", "-api", "Api", "//"});
    }

    @Test
    public void testNotExistingPaths() throws Exception {
        this.assertResult(this.cli, -1, new String[]{"ls", "/nonexisting_path"});
        this.assertResult(this.cli, -1, new String[]{"ls", "/NonExistingDir/nonexisting_path"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/nonexisting_path"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/NonExistingDir/nonexisting_path"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/NonExistingDir/nonexisting_path"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-webui", "uriString", "-api", "Api", "/NonExistingDir/nonexisting_path"});
        this.assertResult(this.cli, -1, new String[]{"bind", "-rest", "uriString", "-api", "Api", "/NonExistingDir/nonexisting_path"});
    }

    @Test
    public void testValidCommands() throws Exception {
        this.assertResult(this.cli, 0, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-webui", "uriString", "-api", "Api", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-rest", "uriString", "-api", "Api", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/foo"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/foo"});
        this.assertResult(this.cli, 0, new String[]{"mknode", "/subdir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/subdir"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/subdir/foo"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-webui", "uriString", "-api", "Api", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/subdir/foo"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-rest", "uriString", "-api", "Api", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/subdir/foo"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/subdir/foo"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/subdir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/subdir"});
        this.assertResult(this.cli, 0, new String[]{"mknode", "/dir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/dir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"mknode", "/dir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-webui", "uriString", "-api", "Api", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/dir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"mknode", "/dir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"bind", "-rest", "uriString", "-api", "Api", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/dir"});
        this.assertResult(this.cli, -1, new String[]{"resolve", "/dir"});
        this.assertResult(this.cli, 0, new String[]{"rm", "/Nonexitent"});
    }
}

