/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RegistryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryUtils.class);

    public static String homePathForUser(String username) {
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"null user");
        if (username.startsWith("/users/")) {
            return username;
        }
        if (username.isEmpty()) {
            return "/services/";
        }
        String convertedName = RegistryUtils.convertUsername((String)username);
        return RegistryPathUtils.join((String)"/users/", (String)RegistryPathUtils.encodeForRegistry((String)convertedName));
    }

    public static String convertUsername(String username) {
        int slashSymbol;
        String converted = org.apache.hadoop.util.StringUtils.toLowerCase((String)username);
        int atSymbol = converted.indexOf(64);
        if (atSymbol > 0) {
            converted = converted.substring(0, atSymbol);
        }
        if ((slashSymbol = converted.indexOf(47)) > 0) {
            converted = converted.substring(0, slashSymbol);
        }
        return converted;
    }

    public static String serviceclassPath(String user, String serviceClass) {
        String services = RegistryPathUtils.join((String)RegistryUtils.homePathForUser((String)user), (String)"/services/");
        return RegistryPathUtils.join((String)services, (String)serviceClass);
    }

    public static String servicePath(String user, String serviceClass, String serviceName) {
        return RegistryPathUtils.join((String)RegistryUtils.serviceclassPath((String)user, (String)serviceClass), (String)serviceName);
    }

    public static String componentListPath(String user, String serviceClass, String serviceName) {
        return RegistryPathUtils.join((String)RegistryUtils.servicePath((String)user, (String)serviceClass, (String)serviceName), (String)"/components/");
    }

    public static String componentPath(String user, String serviceClass, String serviceName, String componentName) {
        return RegistryPathUtils.join((String)RegistryUtils.componentListPath((String)user, (String)serviceClass, (String)serviceName), (String)componentName);
    }

    public static Map<String, ServiceRecord> listServiceRecords(RegistryOperations registryOperations, String path) throws IOException {
        Map children = RegistryUtils.statChildren((RegistryOperations)registryOperations, (String)path);
        return RegistryUtils.extractServiceRecords((RegistryOperations)registryOperations, (String)path, children.values());
    }

    public static Map<String, RegistryPathStatus> statChildren(RegistryOperations registryOperations, String path) throws PathNotFoundException, InvalidPathnameException, IOException {
        List childNames = registryOperations.list(path);
        HashMap<String, RegistryPathStatus> results = new HashMap<String, RegistryPathStatus>();
        for (String childName : childNames) {
            String child = RegistryPathUtils.join((String)path, (String)childName);
            try {
                RegistryPathStatus stat = registryOperations.stat(child);
                results.put(childName, stat);
            }
            catch (PathNotFoundException pnfe) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("stat failed on {}: moved? {}", new Object[]{child, pnfe, pnfe});
            }
        }
        return results;
    }

    public static String homePathForCurrentUser() {
        String shortUserName = RegistryUtils.currentUsernameUnencoded();
        return RegistryUtils.homePathForUser((String)shortUserName);
    }

    private static String currentUsernameUnencoded() {
        String env_hadoop_username = System.getenv("HADOOP_USER_NAME");
        return RegistryUtils.getCurrentUsernameUnencoded((String)env_hadoop_username);
    }

    @VisibleForTesting
    public static String getCurrentUsernameUnencoded(String env_hadoop_username) {
        String shortUserName = null;
        if (!UserGroupInformation.isSecurityEnabled()) {
            shortUserName = env_hadoop_username;
        }
        if (StringUtils.isEmpty((String)shortUserName)) {
            try {
                shortUserName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return shortUserName;
    }

    public static String currentUser() {
        String shortUserName = RegistryUtils.currentUsernameUnencoded();
        return RegistryPathUtils.encodeForRegistry((String)shortUserName);
    }

    public static Map<String, ServiceRecord> extractServiceRecords(RegistryOperations operations, String parentpath, Collection<RegistryPathStatus> stats) throws IOException {
        HashMap<String, ServiceRecord> results = new HashMap<String, ServiceRecord>(stats.size());
        for (RegistryPathStatus stat : stats) {
            if (stat.size <= (long)"JSONServiceRecord".length()) continue;
            String path = RegistryPathUtils.join((String)parentpath, (String)stat.path);
            try {
                ServiceRecord serviceRecord = operations.resolve(path);
                results.put(path, serviceRecord);
            }
            catch (EOFException ignored) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("data too short for {}", (Object)path);
            }
            catch (InvalidRecordException record) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Invalid record at {}", (Object)path);
            }
            catch (NoRecordException record) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("No record at {}", (Object)path);
            }
        }
        return results;
    }

    public static Map<String, ServiceRecord> extractServiceRecords(RegistryOperations operations, String parentpath, Map<String, RegistryPathStatus> stats) throws IOException {
        return RegistryUtils.extractServiceRecords((RegistryOperations)operations, (String)parentpath, stats.values());
    }

    public static Map<String, ServiceRecord> extractServiceRecords(RegistryOperations operations, String parentpath) throws IOException {
        return RegistryUtils.extractServiceRecords((RegistryOperations)operations, (String)parentpath, RegistryUtils.statChildren((RegistryOperations)operations, (String)parentpath).values());
    }
}

