/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RpcClientFactory;
import org.apache.hadoop.yarn.factories.RpcServerFactory;
import org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl;
import org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl;
import org.apache.hadoop.yarn.factory.providers.RpcFactoryProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcFactoryProvider {
    @Test
    public void testFactoryProvider() {
        Configuration conf = new Configuration();
        RpcClientFactory clientFactory = null;
        RpcServerFactory serverFactory = null;
        clientFactory = RpcFactoryProvider.getClientFactory((Configuration)conf);
        serverFactory = RpcFactoryProvider.getServerFactory((Configuration)conf);
        Assert.assertEquals(RpcClientFactoryPBImpl.class, clientFactory.getClass());
        Assert.assertEquals(RpcServerFactoryPBImpl.class, serverFactory.getClass());
        conf.set("yarn.ipc.client.factory.class", "unknown");
        conf.set("yarn.ipc.server.factory.class", "unknown");
        conf.set("yarn.ipc.record.factory.class", "unknown");
        try {
            clientFactory = RpcFactoryProvider.getClientFactory((Configuration)conf);
            Assert.fail((String)"Expected an exception - unknown serializer");
        }
        catch (YarnRuntimeException e) {
            // empty catch block
        }
        try {
            serverFactory = RpcFactoryProvider.getServerFactory((Configuration)conf);
            Assert.fail((String)"Expected an exception - unknown serializer");
        }
        catch (YarnRuntimeException e) {
            // empty catch block
        }
        conf = new Configuration();
        conf.set("yarn.ipc.client.factory.class", "NonExistantClass");
        conf.set("yarn.ipc.server.factory.class", RpcServerFactoryPBImpl.class.getName());
        try {
            clientFactory = RpcFactoryProvider.getClientFactory((Configuration)conf);
            Assert.fail((String)"Expected an exception - unknown class");
        }
        catch (YarnRuntimeException e) {
            // empty catch block
        }
        try {
            serverFactory = RpcFactoryProvider.getServerFactory((Configuration)conf);
        }
        catch (YarnRuntimeException e) {
            Assert.fail((String)("Error while loading factory using reflection: [" + RpcServerFactoryPBImpl.class.getName() + "]"));
        }
    }
}

