/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;

public class TestRPC {
    private static final String EXCEPTION_MSG = "test error";
    private static final String EXCEPTION_CAUSE = "exception cause";
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testUnknownCall() {
        Configuration conf = new Configuration();
        conf.set("yarn.ipc.rpc.class", HadoopYarnProtoRPC.class.getName());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String bindAddr = "localhost:0";
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        Server server = rpc.getServer(ContainerManagementProtocol.class, (Object)new DummyContainerManager(), addr, conf, null, 1);
        server.start();
        ApplicationClientProtocol proxy = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, NetUtils.getConnectAddress((Server)server), conf);
        try {
            proxy.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
            Assert.fail((String)"Excepted RPC call to fail with unknown method.");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().matches("Unknown method getNewApplication called on.*org.apache.hadoop.yarn.proto.ApplicationClientProtocol\\$ApplicationClientProtocolService\\$BlockingInterface protocol."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testHadoopProtoRPC() throws Exception {
        this.test(HadoopYarnProtoRPC.class.getName());
    }

    private void test(String rpcClass) throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.ipc.rpc.class", rpcClass);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String bindAddr = "localhost:0";
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        Server server = rpc.getServer(ContainerManagementProtocol.class, (Object)new DummyContainerManager(), addr, conf, null, 1);
        server.start();
        RPC.setProtocolEngine((Configuration)conf, ContainerManagementProtocolPB.class, ProtobufRpcEngine.class);
        ContainerManagementProtocol proxy = (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, NetUtils.getConnectAddress((Server)server), conf);
        ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)0);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)100);
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)1234);
        Resource resource = Resource.newInstance((int)1234, (int)2);
        ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier(containerId, "localhost", "user", resource, System.currentTimeMillis() + 10000L, 42, 42L, Priority.newInstance((int)0), 0L);
        Token containerToken = TestRPC.newContainerToken(nodeId, "password".getBytes(), containerTokenIdentifier);
        StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)containerLaunchContext, (Token)containerToken);
        ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
        list.add(scRequest);
        StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
        proxy.startContainers(allRequests);
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        GetContainerStatusesRequest gcsRequest = GetContainerStatusesRequest.newInstance(containerIds);
        GetContainerStatusesResponse response = proxy.getContainerStatuses(gcsRequest);
        List statuses = response.getContainerStatuses();
        boolean exception = false;
        try {
            StopContainersRequest stopRequest = (StopContainersRequest)recordFactory.newRecordInstance(StopContainersRequest.class);
            stopRequest.setContainerIds(containerIds);
            proxy.stopContainers(stopRequest);
        }
        catch (YarnException e) {
            exception = true;
            Assert.assertTrue((boolean)e.getMessage().contains(EXCEPTION_MSG));
            Assert.assertTrue((boolean)e.getMessage().contains(EXCEPTION_CAUSE));
            System.out.println("Test Exception is " + e.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Assert.assertTrue((boolean)exception);
        server.stop();
        Assert.assertNotNull(statuses.get(0));
        Assert.assertEquals((Object)ContainerState.RUNNING, (Object)((ContainerStatus)statuses.get(0)).getState());
    }

    public static ContainerTokenIdentifier newContainerTokenIdentifier(Token containerToken) throws IOException {
        org.apache.hadoop.security.token.Token token = new org.apache.hadoop.security.token.Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        return (ContainerTokenIdentifier)token.decodeIdentifier();
    }

    public static Token newContainerToken(NodeId nodeId, byte[] password, ContainerTokenIdentifier tokenIdentifier) {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
        Token containerToken = Token.newInstance((byte[])tokenIdentifier.getBytes(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])password, (String)SecurityUtil.buildTokenService((InetSocketAddress)addr).toString());
        return containerToken;
    }

    public class DummyContainerManager
    implements ContainerManagementProtocol {
        private List<ContainerStatus> statuses = new ArrayList<ContainerStatus>();

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            GetContainerStatusesResponse response = (GetContainerStatusesResponse)recordFactory.newRecordInstance(GetContainerStatusesResponse.class);
            response.setContainerStatuses(this.statuses);
            return response;
        }

        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
            StartContainersResponse response = (StartContainersResponse)recordFactory.newRecordInstance(StartContainersResponse.class);
            for (StartContainerRequest request : requests.getStartContainerRequests()) {
                Token containerToken = request.getContainerToken();
                ContainerTokenIdentifier tokenId = null;
                try {
                    tokenId = TestRPC.newContainerTokenIdentifier(containerToken);
                }
                catch (IOException e) {
                    throw RPCUtil.getRemoteException((Throwable)e);
                }
                ContainerStatus status = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
                status.setState(ContainerState.RUNNING);
                status.setContainerId(tokenId.getContainerID());
                status.setExitStatus(0);
                this.statuses.add(status);
            }
            return response;
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            Exception e = new Exception(TestRPC.EXCEPTION_MSG, new Exception(TestRPC.EXCEPTION_CAUSE));
            throw new YarnException((Throwable)e);
        }
    }
}

